/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.NullConnectionManagementStrategy;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class NullConnectionManagementStrategyTestCase
extends AbstractMuleTestCase {
    @Mock
    private ConnectionProvider<Banana> connectionProvider;
    @Mock
    private Apple config;
    @Mock
    private Banana connection;
    @Mock
    private MuleContext muleContext;
    private NullConnectionManagementStrategy<Banana> strategy;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.connectionProvider.connect()).thenReturn((Object)this.connection);
        this.strategy = new NullConnectionManagementStrategy(this.connectionProvider, this.muleContext);
    }

    @Test
    public void getConnection() throws Exception {
        ConnectionHandler connectionHandler = this.strategy.getConnectionHandler();
        Assert.assertThat((Object)connectionHandler.getConnection(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connection)));
    }

    @Test
    public void close() throws Exception {
        this.strategy.close();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider, (VerificationMode)Mockito.never())).disconnect(Matchers.any(Banana.class));
    }
}

