/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import org.apache.commons.pool.ObjectPool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.core.internal.connection.PoolingConnectionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PoolingConnectionHandlerTestCase
extends AbstractMuleTestCase {
    @Mock
    private ObjectPool<Object> pool;
    @Mock
    private Object config;
    @Mock
    private Object connection;
    @Mock
    private PoolingListener<Object> poolingListener;
    @Mock
    private ConnectionProvider connectionProvider;
    private PoolingConnectionHandler<Object> managedConnection;

    @Before
    public void before() {
        this.managedConnection = new PoolingConnectionHandler(this.connection, this.pool, this.poolingListener, this.connectionProvider);
    }

    @Test
    public void getConnection() throws Exception {
        Assert.assertThat((Object)this.managedConnection.getConnection(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connection)));
    }

    @Test
    public void release() throws Exception {
        this.managedConnection.release();
        ((ObjectPool)Mockito.verify(this.pool)).returnObject(this.connection);
        ((PoolingListener)Mockito.verify(this.poolingListener)).onReturn(this.connection);
        this.assertDisconnected();
    }

    @Test
    public void invalidate() throws Exception {
        this.managedConnection.invalidate();
        ((ObjectPool)Mockito.verify(this.pool)).invalidateObject(this.connection);
        this.assertDisconnected();
    }

    private void assertDisconnected() throws ConnectionException {
        try {
            this.managedConnection.getConnection();
            Assert.fail((String)"Was expecting failure");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void close() throws Exception {
        this.managedConnection.close();
        ((ObjectPool)Mockito.verify(this.pool, (VerificationMode)Mockito.never())).returnObject(Matchers.anyObject());
    }

    @Test
    public void getConnectionProvider() {
        Assert.assertThat((Object)this.managedConnection.getConnectionProvider(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.connectionProvider)));
    }
}

