/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.DefaultConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.PoolingConnectionManagementStrategy;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class PoolingConnectionManagementStrategyTestCase
extends AbstractMuleContextTestCase {
    private static final int MAX_ACTIVE = 2;
    private ConnectionProvider<Object> connectionProvider;
    private PoolingProfile poolingProfile = new PoolingProfile(2, 2, 4000L, 1, 0);
    private PoolingConnectionManagementStrategy<Object> strategy;
    private PoolingListener<Object> poolingListener;
    private Injector injector;
    private ConnectionHandler<Object> connection1;
    private ConnectionHandler<Object> connection2;

    @Before
    public void before() throws Exception {
        this.poolingListener = (PoolingListener)Mockito.mock(PoolingListener.class);
        this.injector = MuleTestUtils.spyInjector((MuleContext)muleContext);
        muleContext.start();
        this.resetConnectionProvider();
        this.initStrategy();
        this.connection1 = this.strategy.getConnectionHandler();
        this.connection2 = this.strategy.getConnectionHandler();
    }

    @Test
    public void getConnection() throws Exception {
        Assert.assertThat(this.connection1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(this.connection2))));
        Assert.assertThat((Object)this.connection1.getConnection(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.connection2.getConnection()))));
        ((ConnectionProvider)Mockito.verify(this.connectionProvider, (VerificationMode)Mockito.times((int)2))).connect();
        ((PoolingListener)Mockito.verify(this.poolingListener)).onBorrow(this.connection1.getConnection());
        ((PoolingListener)Mockito.verify(this.poolingListener)).onBorrow(this.connection2.getConnection());
    }

    @Test
    public void poolingListenerFailsOnBorrow() throws Exception {
        this.initStrategy();
        RuntimeException exception = new RuntimeException();
        ((PoolingListener)Mockito.doThrow((Throwable)exception).when(this.poolingListener)).onBorrow(Matchers.any(Lifecycle.class));
        try {
            this.strategy.getConnectionHandler();
            Assert.fail((String)"was expecting poolingListener to fail");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)exception)));
            ((ConnectionProvider)Mockito.verify(this.connectionProvider)).disconnect(Matchers.any(Lifecycle.class));
        }
    }

    @Test
    public void connectionsDependenciesInjected() throws Exception {
        ((Injector)Mockito.verify((Object)this.injector)).inject(this.connection1.getConnection());
        ((Injector)Mockito.verify((Object)this.injector)).inject(this.connection2.getConnection());
    }

    @Test
    public void exhaustion() throws Exception {
        this.poolingProfile = new PoolingProfile(1, 1, 4000L, 0, 0);
        this.initStrategy();
        ConnectionHandler connectionHandler = this.strategy.getConnectionHandler();
        try {
            this.strategy.getConnectionHandler();
            Assert.fail((String)"Was expecting the pool to be exhausted");
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        connectionHandler.release();
        Assert.assertThat((Object)this.strategy.getConnectionHandler(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void release() throws Exception {
        this.connection1.release();
        this.connection2.release();
        this.strategy.close();
        ((ConnectionProvider)Mockito.verify(this.connectionProvider, (VerificationMode)Mockito.times((int)2))).disconnect(Matchers.any(Object.class));
    }

    @Test(expected=ConnectionException.class)
    public void failDueToInvalidConnection() throws ConnectionException {
        Mockito.when((Object)this.connectionProvider.validate(Matchers.anyVararg())).thenReturn((Object)ConnectionValidationResult.failure((String)"Invalid username or password", (Exception)new Exception("401: UNAUTHORIZED")));
        this.strategy.getConnectionHandler().getConnection();
    }

    @Test(expected=ConnectionException.class)
    public void failDueToNullConnectionValidationResult() throws ConnectionException {
        Mockito.when((Object)this.connectionProvider.validate(Matchers.anyVararg())).thenReturn(null);
        this.strategy.getConnectionHandler().getConnection();
    }

    private void resetConnectionProvider() throws ConnectionException {
        ConnectionProvider connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProvider.connect()).thenAnswer(i -> (Lifecycle)Mockito.mock(Lifecycle.class));
        Mockito.when((Object)connectionProvider.validate(Matchers.anyObject())).thenReturn((Object)ConnectionValidationResult.success());
        this.connectionProvider = (ConnectionProvider)Mockito.spy((Object)new DefaultConnectionProviderWrapper(connectionProvider, muleContext));
    }

    private void initStrategy() {
        this.strategy = new PoolingConnectionManagementStrategy(this.connectionProvider, this.poolingProfile, this.poolingListener, muleContext);
    }

    private <T> void verifyThat(Assertion<T> assertion) throws Exception {
        this.verifyThat(assertion, this.connection1.getConnection(), this.connection2.getConnection());
    }

    private <T> void verifyThat(Assertion<T> assertion, T ... subjects) {
        Arrays.stream(subjects).forEach(subject -> {
            try {
                assertion.test(Mockito.verify((Object)subject));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @FunctionalInterface
    private static interface Assertion<T> {
        public void test(T var1) throws Exception;
    }
}

