/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ObjectUtils;
import org.mule.runtime.core.internal.construct.AbstractFlowConstruct;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public abstract class AbstractFlowConstructTestCase
extends AbstractMuleContextTestCase {
    protected DirectInboundMessageSource directInboundMessageSource;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.directInboundMessageSource = new DirectInboundMessageSource();
    }

    protected abstract AbstractFlowConstruct getFlowConstruct() throws Exception;

    protected abstract AbstractFlowConstruct getStoppedFlowConstruct() throws Exception;

    @Test
    public void testStart() throws Exception {
        try {
            this.getFlowConstruct().start();
            Assert.fail((String)"Exception expected: Cannot start an uninitialised service");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getFlowConstruct().initialise();
        this.getFlowConstruct().start();
        try {
            this.getFlowConstruct().initialise();
            Assert.fail((String)"Exception expected: Cannot initialise an already initialised service");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.getFlowConstruct().dispose();
    }

    @Test
    public void testStop() throws Exception {
        Assert.assertFalse((boolean)this.getFlowConstruct().isStarted());
        try {
            this.getFlowConstruct().stop();
            Assert.fail((String)"Exception expected: Cannot stop an uninitialised service");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.getFlowConstruct().initialise();
        Assert.assertFalse((boolean)this.getFlowConstruct().isStarted());
        this.getFlowConstruct().stop();
        Assert.assertFalse((boolean)this.getFlowConstruct().isStarted());
        this.getFlowConstruct().start();
        Assert.assertTrue((boolean)this.getFlowConstruct().isStarted());
        this.getFlowConstruct().stop();
        Assert.assertFalse((boolean)this.getFlowConstruct().isStarted());
        try {
            this.getFlowConstruct().stop();
            Assert.fail((String)"Exception expected: Cannot stop a service that is not started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.getFlowConstruct().isStarted());
        this.getFlowConstruct().dispose();
    }

    @Test
    public void testDispose() throws Exception {
        Assert.assertFalse((boolean)this.getFlowConstruct().isStarted());
        this.getFlowConstruct().dispose();
        try {
            this.getFlowConstruct().dispose();
            Assert.fail((String)"Exception expected: Cannot dispose a service that is already disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.getFlowConstruct().initialise();
            Assert.fail((String)"Exception expected: Cannot invoke initialise (or any lifecycle) on an object once it is disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterUnregister() throws MuleException, Exception {
        AbstractFlowConstruct construct = this.getFlowConstruct();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerFlowConstruct((FlowConstruct)construct);
        Assert.assertNotNull((Object)((MuleContextWithRegistries)muleContext).getRegistry().lookupFlowConstruct(construct.getName()));
    }

    @Test
    public void testInitialStateStopped() throws Exception {
        AbstractFlowConstruct flow = this.getStoppedFlowConstruct();
        Assert.assertFalse((boolean)flow.isStarted());
        Assert.assertFalse((boolean)flow.isStopped());
        flow.initialise();
        Assert.assertFalse((boolean)flow.isStarted());
        Assert.assertFalse((boolean)flow.isStopped());
        flow.start();
        Assert.assertFalse((boolean)flow.isStarted());
        Assert.assertTrue((boolean)flow.isStopped());
        flow.start();
        Assert.assertTrue((boolean)flow.isStarted());
        Assert.assertFalse((boolean)flow.isStopped());
        try {
            flow.start();
            Assert.fail((String)"Exception expected: Cannot start an already started flow");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected static class DirectInboundMessageSource
    extends AbstractComponent
    implements MessageSource {
        private Processor listener;

        protected DirectInboundMessageSource() {
        }

        public void setListener(Processor listener) {
            this.listener = listener;
        }

        public Processor getListener() {
            return this.listener;
        }

        public String toString() {
            return ObjectUtils.toString((Object)((Object)this));
        }
    }
}

