/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.construct.DefaultFlowBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
public class DefaultFlowBuilderTestCase
extends AbstractMuleTestCase {
    public static final String FLOW_NAME = "flowName";
    private MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    private Flow.Builder flowBuilder = new DefaultFlowBuilder("flowName", this.muleContext, new ComponentInitialStateManager(){

        public boolean mustStartMessageSource(Component component) {
            return true;
        }
    });
    private ProcessingStrategyFactory defaultProcessingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
    private ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Mockito.when((Object)muleConfiguration.getDefaultProcessingStrategyFactory()).thenReturn((Object)this.defaultProcessingStrategyFactory);
        Mockito.when((Object)this.defaultProcessingStrategyFactory.create((MuleContext)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any())).thenReturn((Object)this.processingStrategy);
    }

    @Test
    public void buildsSimpleFlow() throws Exception {
        Flow flow = this.flowBuilder.build();
        MatcherAssert.assertThat((Object)flow.getName(), (Matcher)Matchers.equalTo((Object)FLOW_NAME));
        MatcherAssert.assertThat((Object)flow.getMuleContext(), (Matcher)Matchers.is((Object)this.muleContext));
        MatcherAssert.assertThat((Object)flow.getProcessors(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((Object)flow.getSource(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)flow.getExceptionListener(), (Matcher)IsNot.not((Matcher)Matchers.sameInstance((Object)this.muleContext.getDefaultErrorHandler(Optional.empty()))));
        MatcherAssert.assertThat((Object)flow.getProcessingStrategy(), (Matcher)Matchers.sameInstance((Object)this.processingStrategy));
    }

    @Test
    public void buildsFullFlow() throws Exception {
        Processor processor1 = (Processor)Mockito.mock(Processor.class);
        Processor processor2 = (Processor)Mockito.mock(Processor.class);
        ArrayList<Processor> messageProcessors = new ArrayList<Processor>();
        messageProcessors.add(processor1);
        messageProcessors.add(processor2);
        MessageSource messageSource = (MessageSource)Mockito.mock(MessageSource.class);
        ProcessingStrategyFactory processingStrategyFactory = (ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class);
        ProcessingStrategy processingStrategy = (ProcessingStrategy)Mockito.mock(ProcessingStrategy.class);
        Mockito.when((Object)processingStrategyFactory.create((MuleContext)org.mockito.Matchers.any(), (String)org.mockito.Matchers.any())).thenReturn((Object)processingStrategy);
        FlowExceptionHandler exceptionListener = (FlowExceptionHandler)Mockito.mock(FlowExceptionHandler.class);
        Flow flow = this.flowBuilder.processors(messageProcessors).source(messageSource).processingStrategyFactory(processingStrategyFactory).messagingExceptionHandler(exceptionListener).build();
        MatcherAssert.assertThat((Object)flow.getName(), (Matcher)Matchers.equalTo((Object)FLOW_NAME));
        MatcherAssert.assertThat((Object)flow.getMuleContext(), (Matcher)Matchers.is((Object)this.muleContext));
        MatcherAssert.assertThat((Object)flow.getProcessors(), (Matcher)Matchers.contains((Object[])new Processor[]{processor1, processor2}));
        MatcherAssert.assertThat((Object)flow.getSource(), (Matcher)Matchers.is((Object)messageSource));
        MatcherAssert.assertThat((Object)flow.getExceptionListener(), (Matcher)Matchers.is((Object)exceptionListener));
        MatcherAssert.assertThat((Object)flow.getProcessingStrategy(), (Matcher)Matchers.sameInstance((Object)processingStrategy));
    }

    @Test
    public void cannotBuildFlowTwice() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.build();
    }

    @Test
    public void cannotChangeMessageSourceAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.source((MessageSource)Mockito.mock(MessageSource.class));
    }

    @Test
    public void cannotChangeMessageProcessorsListAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.processors(Arrays.asList((Processor)Mockito.mock(Processor.class)));
    }

    @Test
    public void cannotChangeMessageProcessorAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.processors(new Processor[]{(Processor)Mockito.mock(Processor.class)});
    }

    @Test
    public void cannotChangeExceptionListenerAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.messagingExceptionHandler((FlowExceptionHandler)Mockito.mock(FlowExceptionHandler.class));
    }

    @Test
    public void cannotChangeProcessingStrategyFactoryAfterFlowBuilt() throws Exception {
        this.flowBuilder.build();
        this.expectedException.expect(IllegalStateException.class);
        this.flowBuilder.processingStrategyFactory((ProcessingStrategyFactory)Mockito.mock(ProcessingStrategyFactory.class));
    }
}

