/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.context.MuleContextFactory;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transformer.DataTypeConversionResolver;
import org.mule.runtime.core.api.util.StreamCloserService;
import org.mule.runtime.core.internal.config.ClusterConfiguration;
import org.mule.runtime.core.internal.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.DefaultMuleContextBuilder;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.lifecycle.MuleContextLifecycleManager;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.tck.config.TestServicesConfigurationBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleContextTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleContextTestCase.class);
    private SystemExceptionHandler mockSystemExceptionHandler = (SystemExceptionHandler)Mockito.mock(SystemExceptionHandler.class);
    private MessagingException mockMessagingException = (MessagingException)Mockito.mock(MessagingException.class);
    @Rule
    public TestServicesConfigurationBuilder testServicesConfigurationBuilder = new TestServicesConfigurationBuilder();
    private MuleContextFactory muleContextFactory;
    private MuleContext context;

    @Before
    public void before() {
        this.muleContextFactory = new DefaultMuleContextFactory();
    }

    @After
    public void after() throws MuleException {
        if (this.context != null) {
            if (this.context.isStarted()) {
                this.context.stop();
            }
            this.context.dispose();
        }
    }

    @Test
    public void callDisposeIfInitFails() throws Exception {
        ServerNotificationManager mockNotificationManager = (ServerNotificationManager)Mockito.mock(ServerNotificationManager.class);
        ((ServerNotificationManager)Mockito.doThrow(MuleRuntimeException.class).when((Object)mockNotificationManager)).initialise();
        DefaultMuleContextBuilder muleContextBuilder = new DefaultMuleContextBuilder(ArtifactType.APP);
        muleContextBuilder.setLifecycleManager((LifecycleManager)new MuleContextLifecycleManager());
        muleContextBuilder.setNotificationManager(mockNotificationManager);
        DefaultMuleContext defaultMuleContext = (DefaultMuleContext)muleContextBuilder.buildMuleContext();
        try {
            defaultMuleContext.initialise();
            Assert.fail((String)"exception expected");
        }
        catch (Exception e) {
            ((ServerNotificationManager)Mockito.verify((Object)mockNotificationManager)).dispose();
        }
    }

    @Test
    public void callSystemExceptionHandlerWhenExceptionIsMessagingException() throws Exception {
        this.createMuleContext();
        LifecycleUtils.disposeIfNeeded((Object)this.context.getExceptionListener(), (Logger)LOGGER);
        this.context.setExceptionListener(this.mockSystemExceptionHandler);
        this.context.handleException((Exception)this.mockMessagingException);
        ((SystemExceptionHandler)Mockito.verify((Object)this.mockSystemExceptionHandler, (VerificationMode)Mockito.times((int)1))).handleException((Exception)this.mockMessagingException, null);
    }

    @Test
    public void getObjectStoreManager() throws Exception {
        this.createMuleContext();
        ObjectStoreManager osManager = this.context.getObjectStoreManager();
        Assert.assertThat((Object)osManager, (Matcher)CoreMatchers.instanceOf(MuleObjectStoreManager.class));
    }

    @Test
    public void defaultMuleClusterConfiguration() throws Exception {
        this.createMuleContext();
        this.context.start();
        Assert.assertThat((Object)this.context.getClusterId(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)this.context.getClusterNodeId(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void overriddenClusterConfiguration() throws Exception {
        int clusterNodeId = 22;
        String clusterId = "some-id";
        this.createMuleContext();
        ((MuleContextWithRegistries)this.context).getRegistry().registerObject("_muleClusterConfiguration", (Object)new ClusterConfiguration(){

            public String getClusterId() {
                return "some-id";
            }

            public int getClusterNodeId() {
                return 22;
            }
        });
        this.context.start();
        Assert.assertThat((Object)this.context.getClusterId(), (Matcher)Is.is((Object)"some-id"));
        Assert.assertThat((Object)this.context.getClusterNodeId(), (Matcher)Is.is((Object)22));
    }

    @Test
    public void defaultMulePollingController() throws Exception {
        this.createMuleContext();
        this.context.start();
        Assert.assertThat((Object)this.context.isPrimaryPollingInstance(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void overriddenMulePollingController() throws Exception {
        this.createMuleContext();
        ((MuleContextWithRegistries)this.context).getRegistry().registerObject("_mulePollingController", () -> false);
        this.context.start();
        Assert.assertThat((Object)this.context.isPrimaryPollingInstance(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void getStreamCloserService() throws Exception {
        this.createMuleContext();
        StreamCloserService serviceFromRegistry = (StreamCloserService)((MuleContextWithRegistries)this.context).getRegistry().lookupObject("_muleStreamCloserService");
        MuleRegistryHelper registry = (MuleRegistryHelper)Mockito.spy((Object)((MuleRegistryHelper)((MuleContextWithRegistries)this.context).getRegistry()));
        ((DefaultMuleContext)this.context).setMuleRegistry((MuleRegistry)registry);
        StreamCloserService streamCloserService = this.context.getStreamCloserService();
        Assert.assertThat((Object)streamCloserService, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)streamCloserService, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)serviceFromRegistry)));
        Assert.assertThat((Object)this.context.getStreamCloserService(), (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)streamCloserService)));
        ((MuleRegistryHelper)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)1))).lookupObject("_muleStreamCloserService");
    }

    @Test
    public void cachesDataTypeConversionResolver() throws Exception {
        this.createMuleContext();
        LifecycleUtils.disposeIfNeeded((Object)((MuleContextWithRegistries)this.context).getRegistry(), (Logger)LOGGER);
        MuleRegistryHelper muleRegistry = (MuleRegistryHelper)Mockito.mock(MuleRegistryHelper.class);
        ((DefaultMuleContext)this.context).setMuleRegistry((MuleRegistry)muleRegistry);
        DataTypeConversionResolver dataTypeConverterResolver1 = this.context.getDataTypeConverterResolver();
        DataTypeConversionResolver dataTypeConverterResolver2 = this.context.getDataTypeConverterResolver();
        Assert.assertThat((Object)dataTypeConverterResolver1, (Matcher)CoreMatchers.instanceOf(DynamicDataTypeConversionResolver.class));
        Assert.assertThat((Object)dataTypeConverterResolver2, (Matcher)CoreMatchers.sameInstance((Object)dataTypeConverterResolver1));
        ((MuleRegistryHelper)Mockito.verify((Object)muleRegistry)).lookupObject("_converterResolver");
    }

    protected void createMuleContext() throws MuleException {
        this.context = this.muleContextFactory.createMuleContext(new ConfigurationBuilder[]{this.testServicesConfigurationBuilder, new DefaultsConfigurationBuilder()});
    }
}

