/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.context.notification.MessageProcessingFlowTraceManager;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MessageProcessingFlowTraceManagerTestCase
extends AbstractMuleTestCase {
    public static final String CONFIG_FILE_NAME = "muleApp.xml";
    public static final int LINE_NUMBER = 10;
    private static QName docNameAttrName = new QName("http://www.mulesoft.org/schema/mule/documentation", "name");
    private static final String NESTED_FLOW_NAME = "nestedFlow";
    private static final String ROOT_FLOW_NAME = "rootFlow";
    private static final String APP_ID = "MessageProcessingFlowTraceManagerTestCase";
    private static boolean originalFlowTrace;
    private MessageProcessingFlowTraceManager manager;
    private EventContext messageContext;
    private FlowConstruct rootFlowConstruct;
    private FlowConstruct nestedFlowConstruct;

    @BeforeClass
    public static void beforeClass() {
        originalFlowTrace = DefaultMuleConfiguration.flowTrace;
        DefaultMuleConfiguration.flowTrace = true;
    }

    @AfterClass
    public static void afterClass() {
        DefaultMuleConfiguration.flowTrace = originalFlowTrace;
    }

    @Before
    public void before() {
        this.manager = new MessageProcessingFlowTraceManager();
        MuleContext context = (MuleContext)Mockito.mock(MuleContext.class);
        MuleConfiguration config = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)config.getId()).thenReturn((Object)APP_ID);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)config);
        this.manager.setMuleContext(context);
        this.rootFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        ComponentLocation mockComponentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)mockComponentLocation.getFileName()).thenReturn(Optional.of(CONFIG_FILE_NAME));
        Mockito.when((Object)mockComponentLocation.getLineInFile()).thenReturn(Optional.of(10));
        Mockito.when((Object)this.rootFlowConstruct.getLocation()).thenReturn((Object)mockComponentLocation);
        Mockito.when((Object)this.rootFlowConstruct.getName()).thenReturn((Object)ROOT_FLOW_NAME);
        Mockito.when((Object)this.rootFlowConstruct.getMuleContext()).thenReturn((Object)context);
        this.nestedFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)this.nestedFlowConstruct.getLocation()).thenReturn((Object)mockComponentLocation);
        Mockito.when((Object)this.nestedFlowConstruct.getName()).thenReturn((Object)NESTED_FLOW_NAME);
        Mockito.when((Object)this.nestedFlowConstruct.getMuleContext()).thenReturn((Object)context);
        this.messageContext = EventContextFactory.create((FlowConstruct)this.rootFlowConstruct, (ComponentLocation)TEST_CONNECTOR_LOCATION);
    }

    @Test
    public void newFlowInvocation() {
        CoreEvent event = this.buildEvent("newFlowInvocation");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void nestedFlowInvocations() {
        CoreEvent event = this.buildEvent("nestedFlowInvocations");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("nestedFlow_ref", false)));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(event, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        String rootEntry = "at " + this.rootFlowConstruct.getName() + "(" + NESTED_FLOW_NAME + "_ref @ " + APP_ID + ":unknown:-1)";
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at nestedFlow" + System.lineSeparator() + rootEntry)));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)rootEntry));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void newComponentCall() {
        CoreEvent event = this.buildEvent("newComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)"at rootFlow"));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/comp", false)));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)"at rootFlow(/comp @ MessageProcessingFlowTraceManagerTestCase:unknown:-1)"));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    protected String getContextInfo(CoreEvent event, FlowConstruct flow) {
        return (String)this.manager.getContextInfo(EnrichedNotificationInfo.createInfo((Event)event, null, null), null).get("FlowStack");
    }

    @Test
    public void newAnnotatedComponentCall() {
        CoreEvent event = this.buildEvent("newAnnotatedComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        Component annotatedMessageProcessor = (Component)this.createMockProcessor("/comp", true);
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation(docNameAttrName)).thenReturn((Object)"annotatedName");
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, (Processor)annotatedMessageProcessor));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":muleApp.xml:10 (annotatedName))")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void splitStack() {
        CoreEvent event = this.buildEvent("newAnnotatedComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/comp", false)));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":unknown:-1)")));
        CoreEvent eventCopy = this.buildEvent("newAnnotatedComponentCall", event.getFlowCallStack().clone());
        Assert.assertThat((Object)this.getContextInfo(eventCopy, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":unknown:-1)")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        FlowConstruct asyncFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)asyncFlowConstruct.getName()).thenReturn((Object)"asyncFlow");
        this.manager.onPipelineNotificationStart(this.buildPipelineNotification(eventCopy, asyncFlowConstruct.getName()));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy, this.createMockProcessor("/asyncComp", false)));
        Assert.assertThat((Object)this.getContextInfo(eventCopy, asyncFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + asyncFlowConstruct.getName() + "(/asyncComp @ " + APP_ID + ":unknown:-1)" + System.lineSeparator() + "at " + this.rootFlowConstruct.getName() + "(/comp @ " + APP_ID + ":unknown:-1)")));
    }

    @Test
    public void splitStackEnd() {
        CoreEvent event = this.buildEvent("newAnnotatedComponentCall");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/comp", false)));
        FlowCallStack flowCallStack = event.getFlowCallStack();
        CoreEvent eventCopy = this.buildEvent("newAnnotatedComponentCall", flowCallStack.clone());
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        String asyncFlowName = "asyncFlow";
        this.manager.onPipelineNotificationStart(this.buildPipelineNotification(eventCopy, asyncFlowName));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy, this.createMockProcessor("/asyncComp", false)));
        Assert.assertThat((Object)((BaseEventContext)event.getContext()).getProcessorsTrace(), this.hasExecutedProcessors("/comp @ MessageProcessingFlowTraceManagerTestCase:unknown:-1", "/asyncComp @ MessageProcessingFlowTraceManagerTestCase:unknown:-1"));
    }

    @Test
    public void joinStack() {
        CoreEvent event = this.buildEvent("joinStack");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/scatter-gather", false)));
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/scatter-gather @ " + APP_ID + ":unknown:-1)")));
        CoreEvent eventCopy0 = this.buildEvent("joinStack_0", event.getFlowCallStack().clone());
        CoreEvent eventCopy1 = this.buildEvent("joinStack_1", event.getFlowCallStack().clone());
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy0, this.createMockProcessor("/route_0", false)));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("nestedFlow_ref", false)));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(eventCopy1, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("/route_1", false)));
        Assert.assertThat((Object)this.getContextInfo(eventCopy1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at nestedFlow(/route_1 @ MessageProcessingFlowTraceManagerTestCase:unknown:-1)" + System.lineSeparator() + "at " + ROOT_FLOW_NAME + "(" + NESTED_FLOW_NAME + "_ref @ " + APP_ID + ":unknown:-1)")));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName() + "(/scatter-gather @ " + APP_ID + ":unknown:-1)")));
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)this.getContextInfo(event, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    public Processor createMockProcessor(String processorPath, boolean useLocationSettings) {
        ComponentLocation componentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)componentLocation.getLocation()).thenReturn((Object)processorPath);
        Mockito.when((Object)componentLocation.getFileName()).thenReturn(useLocationSettings ? Optional.of(CONFIG_FILE_NAME) : Optional.empty());
        Mockito.when((Object)componentLocation.getLineInFile()).thenReturn(useLocationSettings ? Optional.of(10) : Optional.empty());
        Component annotatedMessageProcessor = (Component)Mockito.mock(Processor.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}).defaultAnswer(Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)annotatedMessageProcessor.getAnnotation((QName)Matchers.any())).thenReturn(null);
        Mockito.when((Object)annotatedMessageProcessor.getLocation()).thenReturn((Object)componentLocation);
        return (Processor)annotatedMessageProcessor;
    }

    @Test
    public void joinStackEnd() {
        CoreEvent event = this.buildEvent("joinStack");
        PipelineMessageNotification pipelineNotification = this.buildPipelineNotification(event, this.rootFlowConstruct.getName());
        this.manager.onPipelineNotificationStart(pipelineNotification);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(event, this.createMockProcessor("/scatter-gather", false)));
        FlowCallStack flowCallStack = event.getFlowCallStack();
        CoreEvent eventCopy0 = this.buildEvent("joinStack_0", flowCallStack.clone());
        CoreEvent eventCopy1 = this.buildEvent("joinStack_1", flowCallStack.clone());
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy0, this.createMockProcessor("/route_0", false)));
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("nestedFlow_ref", false)));
        PipelineMessageNotification pipelineNotificationNested = this.buildPipelineNotification(eventCopy1, NESTED_FLOW_NAME);
        this.manager.onPipelineNotificationStart(pipelineNotificationNested);
        this.manager.onMessageProcessorNotificationPreInvoke(this.buildProcessorNotification(eventCopy1, this.createMockProcessor("/route_1", false)));
        this.manager.onPipelineNotificationComplete(pipelineNotificationNested);
        this.manager.onPipelineNotificationComplete(pipelineNotification);
        Assert.assertThat((Object)((BaseEventContext)event.getContext()).getProcessorsTrace(), this.hasExecutedProcessors("/scatter-gather @ MessageProcessingFlowTraceManagerTestCase:unknown:-1", "/route_0 @ MessageProcessingFlowTraceManagerTestCase:unknown:-1", "nestedFlow_ref @ MessageProcessingFlowTraceManagerTestCase:unknown:-1", "/route_1 @ MessageProcessingFlowTraceManagerTestCase:unknown:-1"));
    }

    @Test
    public void mixedEvents() {
        CoreEvent event1 = this.buildEvent("mixedEvents_1");
        CoreEvent event2 = this.buildEvent("mixedEvents_2");
        PipelineMessageNotification pipelineNotification1 = this.buildPipelineNotification(event1, this.rootFlowConstruct.getName());
        PipelineMessageNotification pipelineNotification2 = this.buildPipelineNotification(event2, this.rootFlowConstruct.getName());
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification1);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        this.manager.onPipelineNotificationStart(pipelineNotification2);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onPipelineNotificationComplete(pipelineNotification1);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)("at " + this.rootFlowConstruct.getName())));
        this.manager.onPipelineNotificationComplete(pipelineNotification2);
        Assert.assertThat((Object)this.getContextInfo(event1, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)this.getContextInfo(event2, this.rootFlowConstruct), (Matcher)CoreMatchers.is((Object)""));
    }

    protected CoreEvent buildEvent(String eventId) {
        return this.buildEvent(eventId, (FlowCallStack)new DefaultFlowCallStack());
    }

    protected CoreEvent buildEvent(String eventId, FlowCallStack flowStack) {
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.messageContext);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.messageContext);
        Mockito.when((Object)event.getFlowCallStack()).thenReturn((Object)flowStack);
        return event;
    }

    protected MessageProcessorNotification buildProcessorNotification(CoreEvent event, Processor processor) {
        return MessageProcessorNotification.createFrom((Event)event, null, (Component)((Component)processor), null, (int)1601);
    }

    protected PipelineMessageNotification buildPipelineNotification(CoreEvent event, String name) {
        Pipeline flowConstruct = (Pipeline)Mockito.mock(Pipeline.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
        Mockito.when((Object)flowConstruct.getName()).thenReturn((Object)name);
        return new PipelineMessageNotification(EnrichedNotificationInfo.createInfo((Event)event, null, (Component)flowConstruct), flowConstruct.getName(), 1801);
    }

    private Matcher<ProcessorsTrace> hasExecutedProcessors(final String ... expectedProcessors) {
        return new TypeSafeMatcher<ProcessorsTrace>(){
            private List<Matcher> failed = new ArrayList<Matcher>();

            protected boolean matchesSafely(ProcessorsTrace processorsTrace) {
                Matcher sizeMatcher = IsCollectionWithSize.hasSize((int)expectedProcessors.length);
                if (!sizeMatcher.matches((Object)processorsTrace.getExecutedProcessors())) {
                    this.failed.add(sizeMatcher);
                }
                int i = 0;
                for (String expectedProcessor : expectedProcessors) {
                    Matcher processorItemMatcher = CoreMatchers.is((Object)expectedProcessor);
                    if (!processorItemMatcher.matches(processorsTrace.getExecutedProcessors().get(i))) {
                        this.failed.add(processorItemMatcher);
                    }
                    ++i;
                }
                return this.failed.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendValue(Arrays.asList(expectedProcessors));
            }

            protected void describeMismatchSafely(ProcessorsTrace item, Description description) {
                description.appendText("was ").appendValue((Object)item.getExecutedProcessors());
            }
        };
    }
}

