/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.el.ModuleNamespace;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.internal.el.DefaultBindingContextBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultBindingContextBuilderTestCase
extends AbstractMuleTestCase {
    private static final String ID = "id";
    private static final String OTHER_ID = "otherId";
    private BindingContext.Builder builder = new DefaultBindingContextBuilder();
    private TypedValue<String> typedValue = new TypedValue((Object)"", DataType.STRING);
    private ModuleNamespace namespace = new ModuleNamespace(new String[]{"org", "mule", "mymodule"});

    @Test
    public void addsBinding() {
        BindingContext context = this.builder.addBinding(ID, this.typedValue).build();
        Assert.assertThat((Object)context.bindings(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)context.identifiers(), (Matcher)Matchers.hasItem((Object)ID));
        Assert.assertThat(context.lookup(ID).get(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(this.typedValue)));
    }

    @Test
    public void addsBindings() {
        ExpressionModule module = ExpressionModule.builder((ModuleNamespace)this.namespace).addBinding(ID, this.typedValue).build();
        BindingContext previousContext = BindingContext.builder().addBinding(ID, this.typedValue).addBinding(OTHER_ID, this.typedValue).addModule(module).build();
        BindingContext context = this.builder.addAll(previousContext).build();
        Assert.assertThat((Object)context.bindings(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)context.identifiers(), (Matcher)Matchers.hasItems((Object[])new String[]{ID, OTHER_ID}));
        Assert.assertThat(context.lookup(ID).get(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(this.typedValue)));
        Assert.assertThat(context.lookup(OTHER_ID).get(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(this.typedValue)));
        Assert.assertThat((Object)context.modules(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)context.modules(), (Matcher)Matchers.hasItems((Object[])new ExpressionModule[]{module}));
        Collection moduleBindings = ((ExpressionModule)context.modules().iterator().next()).bindings();
        Assert.assertThat((Object)moduleBindings, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((Binding)moduleBindings.iterator().next()).identifier(), (Matcher)Matchers.is((Object)ID));
    }

    @Test
    public void fromPreviousBindings() {
        ExpressionModule module = ExpressionModule.builder((ModuleNamespace)this.namespace).addBinding(ID, this.typedValue).build();
        BindingContext previousContext = BindingContext.builder().addBinding(ID, this.typedValue).addBinding(OTHER_ID, this.typedValue).addModule(module).build();
        BindingContext context = BindingContext.builder((BindingContext)previousContext).build();
        Assert.assertThat((Object)context.bindings(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)context.identifiers(), (Matcher)Matchers.hasItems((Object[])new String[]{ID, OTHER_ID}));
        Assert.assertThat(context.lookup(ID).get(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(this.typedValue)));
        Assert.assertThat(context.lookup(OTHER_ID).get(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(this.typedValue)));
        Assert.assertThat((Object)context.modules(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)context.modules(), (Matcher)Matchers.hasItems((Object[])new ExpressionModule[]{module}));
    }
}

