/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="Expression Language")
@Story(value="Support both MVEL and DW")
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExpressionManagerMelDefaultTestCase
extends AbstractMuleContextTestCase {
    private static final String MY_VAR = "myVar";
    @Rule
    public SystemProperty melDefualt = new SystemProperty("mule.test.mel.default", Boolean.TRUE.toString());
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExtendedExpressionManager expressionManager;

    @Before
    public void configureExpressionManager() throws MuleException {
        this.expressionManager = new DefaultExpressionManager();
        LifecycleUtils.initialiseIfNeeded((Object)this.expressionManager, (MuleContext)muleContext);
    }

    @Test
    @Description(value="Verifies that a simple literal expression is successful.")
    public void simple() {
        String expression = "\"wow\"";
        this.assertString(expression);
    }

    @Test
    @Description(value="Verifies that a simple literal expression is successful when using brackets.")
    public void simpleEnclosed() {
        this.assertString("#[\"wow\"]");
    }

    private void assertString(String expression) {
        Assert.assertThat((Object)this.expressionManager.evaluate(expression).getValue(), (Matcher)Matchers.is((Object)"wow"));
    }

    @Test
    @Description(value="Verifies that a map expression is successful.")
    public void map() {
        String expression = "{'name' : 'Sarah', 'surname' : 'Manning'}";
        Object result = this.expressionManager.evaluate(expression).getValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)((Map)result), (Matcher)Matchers.hasEntry((Object)"name", (Object)"Sarah"));
        Assert.assertThat((Object)((Map)result), (Matcher)Matchers.hasEntry((Object)"surname", (Object)"Manning"));
    }

    @Test
    @Description(value="Verifies that custom variables are considered.")
    public void simpleCustomVariable() {
        Object object = new Object();
        BindingContext context = BindingContext.builder().addBinding(MY_VAR, new TypedValue(object, DataType.OBJECT)).build();
        Assert.assertThat((Object)this.expressionManager.evaluate("#[myVar]", context).getValue(), (Matcher)Matchers.equalTo((Object)object));
    }

    @Test
    @Description(value="Verifies that the flow variable exposing it's name works.")
    public void flowName() throws MuleException {
        FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)mockFlowConstruct.getName()).thenReturn((Object)"myFlowName");
        String result = (String)this.expressionManager.evaluate("#[flow.name]", this.testEvent(), (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)mockFlowConstruct.getName())).getValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)mockFlowConstruct.getName()));
    }

    @Test
    @Description(value="Verifies that payload variable works.")
    public void payloadVariable() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.evaluate("payload", this.testEvent()).getValue(), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    @Description(value="Verifies that flowVars work, returning null for non existent ones and it's value for those that do.")
    public void flowVars() throws MuleException {
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)this.testEvent());
        String flowVars = "flowVars.myVar";
        Assert.assertThat((Object)this.expressionManager.evaluate(flowVars, eventBuilder.build()).getValue(), (Matcher)Matchers.nullValue());
        String value = "Leda";
        eventBuilder.addVariable(MY_VAR, (Object)value);
        Assert.assertThat((Object)this.expressionManager.evaluate(flowVars, eventBuilder.build()).getValue(), (Matcher)Matchers.is((Object)value));
    }

    @Test
    @Description(value="Verifies that a simple transformation works. MVEL ignores expectedDataType")
    public void transformation() throws MuleException {
        String expression = "payload";
        TypedValue result = this.expressionManager.evaluate(expression, DataType.BYTE_ARRAY, BindingContext.builder().build(), this.testEvent());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"test"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Object)DataType.STRING));
    }

    @Test
    @Description(value="Verifies that a simple transformation works even when it's not required.")
    public void transformationNotNeeded() throws MuleException {
        String expression = "payload";
        TypedValue result = this.expressionManager.evaluate(expression, DataType.STRING, BindingContext.builder().build(), this.testEvent());
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"test"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Object)DataType.STRING));
    }

    @Test
    @Description(value="Verifies that parsing works with inner expressions in MVEL but only with regular ones in DW.")
    public void parseCompatibility() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.parse("this is #[payload]", this.testEvent(), TEST_CONNECTOR_LOCATION), (Matcher)Matchers.is((Object)String.format("this is %s", "test")));
        Assert.assertThat((Object)this.expressionManager.parse("#[dw:'this is ' ++ payload]", this.testEvent(), TEST_CONNECTOR_LOCATION), (Matcher)Matchers.is((Object)String.format("this is %s", "test")));
    }

    @Test
    @Description(value="Verifies that parsing works for plain String scenarios.")
    public void parse() throws MuleException {
        String expression = "this is a test";
        Assert.assertThat((Object)this.expressionManager.parse(expression, this.testEvent(), TEST_CONNECTOR_LOCATION), (Matcher)Matchers.is((Object)expression));
    }

    @Test
    @Description(value="Verifies that parsing works for log template scenarios for both DW and MVEL.")
    public void parseLog() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[mel:payload]", this.testEvent(), TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)Matchers.is((Object)String.format("this is %s", "test")));
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[payload]", this.testEvent(), TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)Matchers.is((Object)String.format("this is %s", "test")));
    }

    @Test
    @Description(value="Verifies that streams are logged in DW but not in MVEL.")
    public void parseLogStream() throws MuleException {
        ByteArrayInputStream stream = new ByteArrayInputStream("hello".getBytes());
        CoreEvent event = this.getEventBuilder().message(Message.of((Object)stream)).build();
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[dw:payload]", event, TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)Matchers.is((Object)"this is hello"));
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[payload]", event, TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)Matchers.both((Matcher)Matchers.startsWith((String)"this is ")).and(Matchers.containsString((String)stream.getClass().getSimpleName())));
    }

    @Test
    public void isValid() {
        String expression = "2*2";
        Assert.assertThat((Object)this.expressionManager.isValid(expression), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isInvalid() {
        String expression = "2*'2";
        Assert.assertThat((Object)this.expressionManager.isValid(expression), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isExpression() {
        Assert.assertThat((Object)this.expressionManager.isExpression("2*2 + #[var]"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.expressionManager.isExpression("#[var]"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.expressionManager.isExpression("${var}"), (Matcher)Matchers.is((Object)false));
    }
}

