/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

@Feature(value="Expression Language")
@Story(value="Support both MVEL and DW")
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExpressionManagerTestCase
extends AbstractMuleContextTestCase {
    private static final String MY_VAR = "myVar";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private StreamingManager streamingManager;
    private ExtendedExpressionManager expressionManager;

    @Before
    public void configureExpressionManager() throws MuleException {
        this.expressionManager = new DefaultExpressionManager();
        LifecycleUtils.initialiseIfNeeded((Object)this.expressionManager, (MuleContext)muleContext);
    }

    @Test
    @Description(value="Verifies that global bindings can be added.")
    public void globals() {
        final DataType integerType = DataType.fromType(Integer.class);
        ExpressionFunction multiply = new ExpressionFunction(){

            public Object call(Object[] objects, BindingContext bindingContext) {
                return (Integer)objects[0] * (Integer)objects[1];
            }

            public Optional<DataType> returnType() {
                return Optional.of(integerType);
            }

            public List<FunctionParameter> parameters() {
                return Arrays.asList(new FunctionParameter("x", integerType), new FunctionParameter("y", integerType));
            }
        };
        BindingContext globalContext = BindingContext.builder().addBinding("aNum", new TypedValue((Object)4, DataType.fromType(Integer.class))).addBinding("times", new TypedValue((Object)multiply, DataType.fromFunction((ExpressionFunction)multiply))).build();
        this.expressionManager.addGlobalBindings(globalContext);
        TypedValue result = this.expressionManager.evaluate("aNum times 5");
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)20));
        this.expressionManager.addGlobalBindings(BindingContext.builder().addBinding("otherNum", new TypedValue((Object)3, integerType)).build());
        result = this.expressionManager.evaluate("(times(7, 3) + otherNum) / aNum");
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)6));
    }

    @Test
    @Description(value="Verifies that a simple literal expression is successful.")
    public void simple() {
        String expression = "\"wow\"";
        this.assertString(expression);
    }

    @Test
    @Description(value="Verifies that a simple literal expression is successful when using brackets.")
    public void simpleEnclosed() {
        this.assertString("#[\"wow\"]");
    }

    private void assertString(String expression) {
        Assert.assertThat((Object)this.expressionManager.evaluate(expression).getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"wow"));
    }

    @Test
    @Description(value="Verifies that a map expression is successful.")
    public void map() {
        String expression = "{'name' : 'Sarah', 'surname' : 'Manning'}";
        Object result = this.expressionManager.evaluate(expression).getValue();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)((Map)result), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"name", (Object)"Sarah"));
        Assert.assertThat((Object)((Map)result), (Matcher)org.hamcrest.Matchers.hasEntry((Object)"surname", (Object)"Manning"));
    }

    @Test
    @Description(value="Verifies that custom variables are considered.")
    public void simpleCustomVariable() {
        Object object = new Object();
        BindingContext context = BindingContext.builder().addBinding(MY_VAR, new TypedValue(object, DataType.OBJECT)).build();
        Assert.assertThat((Object)this.expressionManager.evaluate("#[myVar]", context).getValue(), (Matcher)org.hamcrest.Matchers.equalTo((Object)object));
    }

    @Test
    @Description(value="Verifies that the flow variable exposing it's name works.")
    public void flowName() throws MuleException {
        FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)mockFlowConstruct.getName()).thenReturn((Object)"myFlowName");
        String result = (String)this.expressionManager.evaluate("#[flow.name]", this.testEvent(), (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)mockFlowConstruct.getName())).getValue();
        Assert.assertThat((Object)result, (Matcher)org.hamcrest.Matchers.is((Object)mockFlowConstruct.getName()));
    }

    @Test
    @Description(value="Verifies that payload variable works.")
    public void payloadVariable() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.evaluate("payload", this.testEvent()).getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"test"));
    }

    @Test
    @Description(value="Verifies that flowVars work, returning null for non existent ones and it's value for those that do.")
    public void flowVars() throws MuleException {
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)this.testEvent());
        String flowVars = "vars.myVar";
        Assert.assertThat((Object)this.expressionManager.evaluate(flowVars, eventBuilder.build()).getValue(), (Matcher)org.hamcrest.Matchers.nullValue());
        String value = "Leda";
        eventBuilder.addVariable(MY_VAR, (Object)value);
        Assert.assertThat((Object)this.expressionManager.evaluate(flowVars, eventBuilder.build()).getValue(), (Matcher)org.hamcrest.Matchers.is((Object)value));
    }

    @Test
    @Description(value="Verifies that a simple transformation works.")
    public void transformation() throws MuleException {
        String expression = "payload";
        TypedValue result = this.expressionManager.evaluate(expression, DataType.BYTE_ARRAY, BindingContext.builder().build(), this.testEvent());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"test".getBytes()));
        Assert.assertThat((Object)result.getDataType(), (Matcher)org.hamcrest.Matchers.is((Object)DataType.BYTE_ARRAY));
    }

    @Test
    @Description(value="Verifies that a simple transformation works even when it's not required.")
    public void transformationNotNeeded() throws MuleException {
        String expression = "payload";
        TypedValue result = this.expressionManager.evaluate(expression, DataType.STRING, BindingContext.builder().build(), this.testEvent());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"test"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)org.hamcrest.Matchers.is((Object)DataType.STRING));
    }

    @Test
    @Description(value="Verifies that parsing works with inner expressions in MVEL but only with regular ones in DW.")
    public void parseCompatibility() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.parse("this is #[mel:payload]", this.testEvent(), TEST_CONNECTOR_LOCATION), (Matcher)org.hamcrest.Matchers.is((Object)String.format("this is %s", "test")));
        Assert.assertThat((Object)this.expressionManager.parse("#['this is ' ++ payload]", this.testEvent(), TEST_CONNECTOR_LOCATION), (Matcher)org.hamcrest.Matchers.is((Object)String.format("this is %s", "test")));
        this.expectedException.expect(RuntimeException.class);
        this.expressionManager.parse("this is #[payload]", this.testEvent(), TEST_CONNECTOR_LOCATION);
    }

    @Test
    @Description(value="Verifies that parsing works for plain String scenarios.")
    public void parse() throws MuleException {
        String expression = "this is a test";
        Assert.assertThat((Object)this.expressionManager.parse(expression, this.testEvent(), TEST_CONNECTOR_LOCATION), (Matcher)org.hamcrest.Matchers.is((Object)expression));
    }

    @Test
    @Description(value="Verifies that parsing works for log template scenarios for both DW and MVEL.")
    public void parseLog() throws MuleException {
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[mel:payload]", this.testEvent(), TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)org.hamcrest.Matchers.is((Object)String.format("this is %s", "test")));
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[payload]", this.testEvent(), TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)org.hamcrest.Matchers.is((Object)String.format("this is %s", "test")));
    }

    @Test
    @Description(value="Verifies that parsing works for log template scenarios for both DW and MVEL using the message.")
    public void parseLogMessage() throws MuleException {
        String expectedOutput = "current message is \norg.mule.runtime.core.internal.message.DefaultMessageBuilder$MessageImplementation\n{\n  payload=java.lang.String\n  mediaType=*/*\n  attributes=null\n  attributesMediaType=*/*\n  exceptionPayload=<not set>\n}";
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("current message is #[mel:message]", this.testEvent(), TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)org.hamcrest.Matchers.is((Object)expectedOutput));
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("current message is #[message]", this.testEvent(), TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)org.hamcrest.Matchers.is((Object)expectedOutput));
    }

    @Test
    @Description(value="Verifies that XML content can be used for logging in DW.")
    public void parseLogXml() throws MuleException {
        CoreEvent event = this.getEventBuilder().message(Message.builder().value((Object)"<?xml version='1.0' encoding='US-ASCII'?>\n<wsc_fields>\n  <operation>echo</operation>\n  <body_test>test</body_test>\n</wsc_fields>").mediaType(MediaType.XML).build()).build();
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[payload.wsc_fields.operation]", event, TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)org.hamcrest.Matchers.is((Object)"this is \"echo\""));
    }

    @Test
    @Description(value="Verifies that streams are logged in DW but not in MVEL.")
    public void parseLogStream() throws MuleException {
        ByteArrayInputStream stream = new ByteArrayInputStream("hello".getBytes());
        CoreEvent event = this.getEventBuilder().message(Message.of((Object)stream)).build();
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[payload]", event, TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)org.hamcrest.Matchers.is((Object)"this is hello"));
        Assert.assertThat((Object)this.expressionManager.parseLogTemplate("this is #[mel:payload]", event, TEST_CONNECTOR_LOCATION, BindingContextUtils.NULL_BINDING_CONTEXT), (Matcher)org.hamcrest.Matchers.both((Matcher)org.hamcrest.Matchers.startsWith((String)"this is ")).and(org.hamcrest.Matchers.containsString((String)stream.getClass().getSimpleName())));
    }

    @Test
    public void isValid() {
        String expression = "2*2";
        Assert.assertThat((Object)this.expressionManager.isValid(expression), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void isInvalid() {
        String expression = "2*'2";
        Assert.assertThat((Object)this.expressionManager.isValid(expression), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void isExpression() {
        Assert.assertThat((Object)this.expressionManager.isExpression("2*2 + #[var]"), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)this.expressionManager.isExpression("#[var]"), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)this.expressionManager.isExpression("${var}"), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void managedCursor() throws Exception {
        DefaultExpressionLanguageFactoryService mockFactory = (DefaultExpressionLanguageFactoryService)Mockito.mock(DefaultExpressionLanguageFactoryService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ExpressionLanguage expressionLanguage = (ExpressionLanguage)Mockito.mock(ExpressionLanguage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        CursorProvider cursorProvider = (CursorProvider)Mockito.mock(CursorProvider.class);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)registry.lookupByType(DefaultExpressionLanguageFactoryService.class)).thenReturn(Optional.of(mockFactory));
        Mockito.when((Object)registry.lookupByName("_muleExpressionLanguage")).thenReturn(Optional.of(Mockito.mock(MVELExpressionLanguage.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        Mockito.when((Object)registry.lookupByName("_compatibilityPluginInstalled")).thenReturn(Optional.empty());
        TypedValue value = new TypedValue((Object)cursorProvider, DataType.BYTE_ARRAY);
        Mockito.when((Object)expressionLanguage.evaluate(Matchers.anyString(), (BindingContext)Matchers.any())).thenReturn((Object)value);
        Mockito.when((Object)expressionLanguage.evaluate(Matchers.anyString(), (DataType)Matchers.any(), (BindingContext)Matchers.any())).thenReturn((Object)value);
        Mockito.when((Object)mockFactory.create()).thenReturn((Object)expressionLanguage);
        this.expressionManager = new DefaultExpressionManager();
        ((DefaultExpressionManager)this.expressionManager).setRegistry(registry);
        ((DefaultExpressionManager)this.expressionManager).setStreamingManager(this.streamingManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.expressionManager, (boolean)false, (MuleContext)muleContext);
        CoreEvent event = this.testEvent();
        Mockito.when((Object)this.streamingManager.manage(cursorProvider, event)).thenReturn((Object)cursorProvider);
        this.expressionManager.evaluate("someExpression", event);
        ((StreamingManager)Mockito.verify((Object)this.streamingManager)).manage(cursorProvider, event);
    }

    @Test
    public void doNotRegistersMelWhenCompatibilityPluginIsNotInstalled() throws Exception {
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)registry.lookupByType(DefaultExpressionLanguageFactoryService.class)).thenReturn(Optional.of(Mockito.mock(DefaultExpressionLanguageFactoryService.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        Mockito.when((Object)registry.lookupByName("_compatibilityPluginInstalled")).thenReturn(Optional.empty());
        MuleContextWithRegistries mockMuleContext = MuleContextUtils.mockMuleContext();
        MuleConfiguration config = mockMuleContext.getConfiguration();
        ((MuleConfiguration)Mockito.doReturn((Object)true).when((Object)config)).isValidateExpressions();
        this.expressionManager = new DefaultExpressionManager();
        ((DefaultExpressionManager)this.expressionManager).setRegistry(registry);
        ((DefaultExpressionManager)this.expressionManager).setMuleContext((MuleContext)mockMuleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.expressionManager, (boolean)false, (MuleContext)mockMuleContext);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("There is no expression language registered for 'mel'");
        this.expressionManager.isValid("mel:'Hello'");
    }
}

