/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import javax.activation.DataHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.el.context.AbstractELTestCase;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
public class ExpressionLanguageEnrichmentTestCase
extends AbstractELTestCase {
    protected MVELExpressionLanguage expressionLanguage;

    public ExpressionLanguageEnrichmentTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() throws Exception {
        this.expressionLanguage = new MVELExpressionLanguage(muleContext);
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("_muleExpressionLanguage", (Object)this.expressionLanguage);
    }

    @Test
    public void enrichReplacePayload() throws Exception {
        CoreEvent event = CoreEvent.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.expressionLanguage.enrich("message.payload", event, eventBuilder, this.flowConstruct.getLocation(), (Object)"bar");
        Assert.assertThat((Object)eventBuilder.build().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void enrichObjectPayload() throws Exception {
        Apple apple = new Apple();
        FruitCleaner fruitCleaner = new FruitCleaner(){

            public void wash(Fruit fruit) {
            }

            public void polish(Fruit fruit) {
            }
        };
        CoreEvent event = CoreEvent.builder((EventContext)this.context).message(Message.of((Object)apple)).build();
        this.expressionLanguage.enrich("message.payload.appleCleaner", event, CoreEvent.builder((CoreEvent)event), this.flowConstruct.getLocation(), (Object)fruitCleaner);
        Assert.assertThat((Object)apple.getAppleCleaner(), (Matcher)CoreMatchers.is((Object)fruitCleaner));
    }

    @Test
    public void enrichMessageProperty() throws Exception {
        CoreEvent event = CoreEvent.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.expressionLanguage.enrich("message.outboundProperties.foo", event, eventBuilder, this.flowConstruct.getLocation(), (Object)"bar");
        Assert.assertThat((Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundProperty("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void enrichMessageAttachment() throws Exception {
        DataHandler dataHandler = new DataHandler(new Object(), "test/xml");
        CoreEvent event = CoreEvent.builder((EventContext)this.context).message(Message.of((Object)"foo")).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.expressionLanguage.enrich("message.outboundAttachments.foo", event, eventBuilder, this.flowConstruct.getLocation(), (Object)dataHandler);
        Assert.assertThat((Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundAttachment("foo"), (Matcher)CoreMatchers.is((Object)dataHandler));
    }

    @Test
    public void enrichFlowVariable() throws Exception {
        CoreEvent event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.expressionLanguage.enrich("flowVars['foo']", event, eventBuilder, this.flowConstruct.getLocation(), (Object)"bar");
        Assert.assertThat((Object)((TypedValue)eventBuilder.build().getVariables().get("foo")).getValue(), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)((PrivilegedEvent)eventBuilder.build()).getSession().getProperty("foo"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void enrichSessionVariable() throws Exception {
        CoreEvent event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"")).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.expressionLanguage.enrich("sessionVars['foo']", event, eventBuilder, this.flowConstruct.getLocation(), (Object)"bar");
        Assert.assertThat((Object)((PrivilegedEvent)eventBuilder.build()).getSession().getProperty("foo"), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        Assert.assertThat(eventBuilder.build().getVariables().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)"foo")));
    }

    @Test
    public void enrichWithDolarPlaceholder() throws Exception {
        CoreEvent event = CoreEvent.builder((EventContext)this.context).message(Message.of((Object)"")).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.expressionLanguage.enrich("message.outboundProperties.put('foo', $)", event, eventBuilder, this.flowConstruct.getLocation(), (Object)"bar");
        Assert.assertThat((Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundProperty("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
    }
}

