/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.core.internal.el.ExpressionLanguageAdaptorHandler;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;

@Feature(value="Expression Language")
@Story(value="Support Mixing DW and MEL in a same application")
@RunWith(value=Parameterized.class)
@SmallTest
public class ExpressionLanguagePrefixTestCase
extends AbstractMuleTestCase {
    private ExpressionLanguageAdaptorHandler elAdapter;
    private DataWeaveExpressionLanguageAdaptor dwLanguage;
    private MVELExpressionLanguage melLanguage;
    @Rule
    public SystemProperty melDefault;
    private VerificationMode melLangMode;
    private VerificationMode dwLangMode;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Boolean> params() {
        return Arrays.asList(true, false);
    }

    public ExpressionLanguagePrefixTestCase(Boolean melDefault) {
        this.melDefault = new SystemProperty("mule.test.mel.default", melDefault.toString());
        if (melDefault.booleanValue()) {
            this.dwLangMode = Mockito.never();
            this.melLangMode = Mockito.times((int)1);
        } else {
            this.dwLangMode = Mockito.times((int)1);
            this.melLangMode = Mockito.never();
        }
    }

    @Before
    public void before() {
        this.dwLanguage = (DataWeaveExpressionLanguageAdaptor)Mockito.mock(DataWeaveExpressionLanguageAdaptor.class);
        this.melLanguage = (MVELExpressionLanguage)Mockito.mock(MVELExpressionLanguage.class);
        this.elAdapter = new ExpressionLanguageAdaptorHandler((ExtendedExpressionLanguageAdaptor)this.dwLanguage, (ExtendedExpressionLanguageAdaptor)this.melLanguage);
    }

    @Test
    public void singleLineNoPrefixNoMarker() {
        this.elAdapter.validate("expr");
        this.doVerify();
    }

    @Test
    public void singleLineNoPrefixMarker() {
        this.elAdapter.validate("#[expr]");
        this.doVerify();
    }

    @Test
    public void singleLineMelPrefixNoMarker() {
        this.elAdapter.validate("mel:expr");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
    }

    @Test
    public void singleLineMelPrefixMarker() {
        this.elAdapter.validate("#[mel:expr]");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
    }

    @Test
    public void singleLineWeavePrefixNoMarker() {
        this.elAdapter.validate("dw:expr");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
    }

    @Test
    public void singleLineWeavePrefixMarker() {
        this.elAdapter.validate("#[dw:expr]");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
    }

    @Test
    public void singleLineInvalidPrefixNoMarker() {
        this.elAdapter.validate("nolang:expr");
        this.doVerify();
    }

    @Test
    public void singleLineInvalidPrefixMarker() {
        this.elAdapter.validate("#[nolang:expr]");
        this.doVerify();
    }

    @Test
    public void multiLineNoPrefixNoMarker() {
        this.elAdapter.validate("expr" + System.lineSeparator() + "a:b");
        this.doVerify();
    }

    @Test
    public void multiLineNoPrefixMarker() {
        this.elAdapter.validate("#[expr" + System.lineSeparator() + "a:b]");
        this.doVerify();
    }

    @Test
    public void multiLineMelPrefixNoMarker() {
        this.elAdapter.validate("mel:expr" + System.lineSeparator() + "a:b");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
    }

    @Test
    public void multiLineMelPrefixMarker() {
        this.elAdapter.validate("#[mel:expr" + System.lineSeparator() + "a:b]");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
    }

    @Test
    public void multiLineWeavePrefixNoMarker() {
        this.elAdapter.validate("dw:expr" + System.lineSeparator() + "a:b");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
    }

    @Test
    public void multiLineWeavePrefixMarker() {
        this.elAdapter.validate("#[dw:expr" + System.lineSeparator() + "a:b]");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
    }

    @Test
    public void multiLineInvalidPrefixNoMarker() {
        this.elAdapter.validate("nolang:expr" + System.lineSeparator() + "a:b");
        this.doVerify();
    }

    @Test
    public void multiLineInvalidPrefixMarker() {
        this.elAdapter.validate("#[nolang:expr" + System.lineSeparator() + "a:b]");
        this.doVerify();
    }

    @Test
    public void paddedNoPrefixNoMarker() {
        this.elAdapter.validate("    expr a:b");
        this.doVerify();
    }

    @Test
    public void paddedNoPrefixMarker() {
        this.elAdapter.validate("#[    expr a:b]");
        this.doVerify();
    }

    @Test
    public void paddedMelPrefixNoMarker() {
        this.elAdapter.validate("    mel:expr a:b");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
    }

    @Test
    public void paddedMelPrefixMarker() {
        this.elAdapter.validate("#[    mel:expr a:b]");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.times((int)1))).validate(Matchers.anyString());
    }

    @Test
    public void paddedInvalidPrefixNoMarker() {
        this.elAdapter.validate("    nolang:expr a:b");
        this.doVerify();
    }

    @Test
    public void paddedInvalidPrefixMarker() {
        this.elAdapter.validate("#[    nolang:expr a:b]");
        this.doVerify();
    }

    private void doVerify() {
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage, (VerificationMode)this.dwLangMode)).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)this.melLangMode)).validate(Matchers.anyString());
    }

    @Test
    public void fullWeaveScript() {
        this.elAdapter.validate("%dw 2.0 --- expr]");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage)).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
    }

    @Test
    public void fullWeaveMultilineScript() {
        this.elAdapter.validate(System.lineSeparator() + "%dw 2.0" + System.lineSeparator() + " ---" + System.lineSeparator() + "expr]");
        ((DataWeaveExpressionLanguageAdaptor)Mockito.verify((Object)this.dwLanguage)).validate(Matchers.anyString());
        ((MVELExpressionLanguage)Mockito.verify((Object)this.melLanguage, (VerificationMode)Mockito.never())).validate(Matchers.anyString());
    }
}

