/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.privileged.el.GlobalBindingContextProvider;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;

@Feature(value="Expression Language")
@Story(value="Support Functions")
public class GlobalBindingContextProviderTestCase
extends AbstractMuleContextTestCase {
    public static final String KEY = "testProvider";

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        WeaveDefaultExpressionLanguageFactoryService weaveExpressionExecutor = new WeaveDefaultExpressionLanguageFactoryService();
        objects.put(weaveExpressionExecutor.getName(), weaveExpressionExecutor);
        objects.put(KEY, new TestGlobalBindingContextProvider());
        return objects;
    }

    @Test
    public void variable() {
        TypedValue result = muleContext.getExpressionManager().evaluate("number");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.NUMBER)));
    }

    @Test
    public void function() {
        TypedValue result = muleContext.getExpressionManager().evaluate("repeat('oa', 3)");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"oaoaoa"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.STRING)));
    }

    private class TestExpressionFunction
    implements ExpressionFunction {
        private TestExpressionFunction() {
        }

        public Object call(Object[] objects, BindingContext bindingContext) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < (Integer)objects[1]; ++i) {
                builder.append((String)objects[0]);
            }
            return builder.toString();
        }

        public Optional<DataType> returnType() {
            return Optional.of(DataType.STRING);
        }

        public List<FunctionParameter> parameters() {
            ArrayList<FunctionParameter> parameters = new ArrayList<FunctionParameter>();
            parameters.add(new FunctionParameter("word", DataType.STRING));
            parameters.add(new FunctionParameter("times", DataType.fromType(Integer.class), ctx -> 1));
            return parameters;
        }
    }

    private class TestGlobalBindingContextProvider
    implements GlobalBindingContextProvider {
        private TestGlobalBindingContextProvider() {
        }

        public BindingContext getBindingContext() {
            TestExpressionFunction function = new TestExpressionFunction();
            return BindingContext.builder().addBinding("number", new TypedValue((Object)1, DataType.NUMBER)).addBinding("repeat", new TypedValue((Object)function, DataType.fromFunction((ExpressionFunction)function))).build();
        }
    }
}

