/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.context;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.context.AbstractELTestCase;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.MuleTestUtils;

public class ExceptionTestCase
extends AbstractELTestCase {
    private Error mockError = (Error)Mockito.mock(Error.class);
    private ErrorType mockErrorType = (ErrorType)Mockito.mock(ErrorType.class);

    public ExceptionTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Override
    public void setupFlowConstruct() throws Exception {
        this.flowConstruct = MuleTestUtils.getTestFlow((MuleContext)muleContext);
    }

    @Test
    public void exception() throws Exception {
        PrivilegedEvent event = this.createEvent();
        RuntimeException rte = new RuntimeException();
        Mockito.when((Object)this.mockError.getCause()).thenReturn((Object)rte);
        Mockito.when((Object)this.mockError.getErrorType()).thenReturn((Object)this.mockErrorType);
        event = CoreEvent.builder((CoreEvent)event).message((Message)InternalMessage.builder((Message)event.getMessage()).build()).build();
        Object exception = this.evaluate("exception", (CoreEvent)event);
        Assert.assertThat((Object)exception, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MessagingException.class)));
        Assert.assertThat((Object)((MessagingException)exception).getCause(), (Matcher)Matchers.is((Object)rte));
    }

    @Test
    public void assignException() throws Exception {
        PrivilegedEvent event = this.createEvent();
        event = CoreEvent.builder((CoreEvent)event).message((Message)InternalMessage.builder((Message)event.getMessage()).build()).build();
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.mockError.getCause()).thenReturn((Object)runtimeException);
        Mockito.when((Object)this.mockError.getErrorType()).thenReturn((Object)this.mockErrorType);
        this.assertImmutableVariable("exception='other'", (CoreEvent)event);
    }

    @Test
    public void exceptionCausedBy() throws Exception {
        PrivilegedEvent event = this.createEvent();
        Message message = event.getMessage();
        MessagingException me = new MessagingException(CoreMessages.createStaticMessage((String)""), (CoreEvent)InternalEvent.builder((EventContext)this.context).message(message).build(), (Throwable)new IllegalAccessException());
        Mockito.when((Object)this.mockError.getCause()).thenReturn((Object)me);
        Assert.assertTrue((boolean)((Boolean)this.evaluate("exception.causedBy(java.lang.IllegalAccessException)", (CoreEvent)event)));
    }

    private PrivilegedEvent createEvent() throws Exception {
        return PrivilegedEvent.builder((EventContext)this.context).message(Message.of((Object)"")).error(this.mockError).build();
    }
}

