/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.context.AbstractELTestCase;
import org.mule.runtime.core.internal.message.InternalMessage;

public class MessagePropertiesTestCase
extends AbstractELTestCase {
    private CoreEvent event;

    public MessagePropertiesTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() throws Exception {
        this.event = CoreEvent.builder((EventContext)this.context).message(Message.of((Object)"")).build();
    }

    @Test
    public void inboundPropertyMap() throws Exception {
        this.event = CoreEvent.builder((EventContext)this.context).message((Message)InternalMessage.builder().value((Object)"").inboundProperties(Collections.singletonMap("foo", "bar")).build()).build();
        Assert.assertTrue((boolean)(this.evaluate("message.inboundProperties", this.event) instanceof Map));
    }

    @Test
    public void assignToInboundPropertyMap() throws Exception {
        this.assertFinalProperty("message.inboundProperties='foo'", this.event);
    }

    @Test
    public void inboundProperty() throws Exception {
        this.event = CoreEvent.builder((EventContext)this.context).message((Message)InternalMessage.builder().value((Object)"").inboundProperties(Collections.singletonMap("foo", "bar")).build()).build();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.inboundProperties['foo']", this.event));
    }

    @Test
    public void assignValueToInboundProperty() throws Exception {
        this.event = CoreEvent.builder((EventContext)this.context).message((Message)InternalMessage.builder().value((Object)"").inboundProperties(Collections.singletonMap("foo", "bar")).build()).build();
        this.assertUnsupportedOperation("message.inboundProperties['foo']='bar'", this.event);
    }

    @Test
    public void assignValueToNewInboundProperty() throws Exception {
        this.assertUnsupportedOperation("message.inboundProperties['foo_new']='bar'", this.event);
    }

    @Test
    public void outboundPropertyMap() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"bar")).build()).build();
        Assert.assertTrue((boolean)(this.evaluate("message.outboundProperties", this.event) instanceof Map));
    }

    @Test
    public void assignToOutboundPropertyMap() throws Exception {
        this.assertFinalProperty("message.outboundProperties='foo'", this.event);
    }

    @Test
    public void outboundProperty() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"bar")).build()).build();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.outboundProperties['foo']", this.event));
    }

    @Test
    public void assignValueToOutboundProperty() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"bar_old")).build()).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)this.event);
        this.evaluate("message.outboundProperties['foo']='bar'", this.event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundProperty("foo"));
    }

    @Test
    public void assignValueToNewOutboundProperty() throws Exception {
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)this.event);
        this.evaluate("message.outboundProperties['foo']='bar'", this.event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)((InternalMessage)eventBuilder.build().getMessage()).getOutboundProperty("foo"));
    }

    @Test
    public void inboundClear() throws Exception {
        this.assertUnsupportedOperation("message.inboundProperties.clear())", this.event);
    }

    @Test
    public void inboundSize() throws Exception {
        Message message = this.event.getMessage();
        Mockito.mock(DataHandler.class);
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"abc")).addInboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Assert.assertEquals((Object)2, (Object)this.evaluate("message.inboundProperties.size()", this.event));
    }

    @Test
    public void inboundKeySet() throws Exception {
        Message message = this.event.getMessage();
        Mockito.mock(DataHandler.class);
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"abc")).addInboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Assert.assertThat((Object)((Iterable)this.evaluate("message.inboundProperties.keySet()", this.event)), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"foo", "bar"}));
    }

    @Test
    public void inboundContainsKey() throws Exception {
        Message message = this.event.getMessage();
        Mockito.mock(DataHandler.class);
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"abc")).build()).build();
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundProperties.containsKey('foo')", this.event)));
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundProperties.containsKey('bar')", this.event)));
    }

    @Test
    public void inboundContainsValue() throws Exception {
        Message message = this.event.getMessage();
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"abc")).build()).build();
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundProperties.containsValue('abc')", this.event)));
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundProperties.containsValue('xyz')", this.event)));
    }

    @Test
    public void inboundEntrySet() throws Exception {
        Message message = this.event.getMessage();
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"abc")).addInboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Set entrySet = (Set)this.evaluate("message.inboundProperties.entrySet()", this.event);
        Assert.assertEquals((long)2L, (long)entrySet.size());
        entrySet.contains(new DefaultMapEntry((Object)"foo", (Object)"abc"));
        entrySet.contains(new DefaultMapEntry((Object)"bar", (Object)"xyz"));
    }

    @Test
    public void inboundValues() throws Exception {
        Message message = this.event.getMessage();
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"abc")).addInboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Collection values = (Collection)this.evaluate("message.inboundProperties.values()", this.event);
        Assert.assertEquals((long)2L, (long)values.size());
        values.contains("abc");
        values.contains("xyz");
    }

    @Test
    public void inboundIsEmpty() throws Exception {
        Message message = this.event.getMessage();
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundProperties.isEmpty()", this.event)));
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)message).addInboundProperty("foo", (Serializable)((Object)"abc")).addInboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundProperties.isEmpty()", this.event)));
    }

    @Test
    public void inboundPutAll() throws Exception {
        this.assertUnsupportedOperation("message.inboundProperties.putAll(['foo': 'abc','bar': 'xyz'])", this.event);
    }

    @Test
    public void inboundRemove() throws Exception {
        this.assertUnsupportedOperation("message.inboundProperties.remove('foo')", this.event);
    }

    @Test
    public void outboundClear() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).addOutboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)this.event);
        this.evaluate("message.outboundProperties.clear()", this.event, eventBuilder);
        Assert.assertEquals((long)0L, (long)((InternalMessage)eventBuilder.build().getMessage()).getOutboundPropertyNames().size());
    }

    @Test
    public void outboundSize() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).addOutboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Assert.assertEquals((Object)2, (Object)this.evaluate("message.outboundProperties.size()", this.event));
    }

    @Test
    public void outboundKeySet() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).addOutboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Assert.assertThat((Object)this.evaluate("message.outboundProperties.keySet().toArray()[0]", this.event), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"foo"), (Matcher)CoreMatchers.equalTo((Object)"bar")));
        Assert.assertThat((Object)this.evaluate("message.outboundProperties.keySet().toArray()[1]", this.event), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"foo"), (Matcher)CoreMatchers.equalTo((Object)"bar")));
    }

    @Test
    public void outboundContainsKey() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).build()).build();
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.containsKey('foo')", this.event)));
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.containsKey('bar')", this.event)));
    }

    @Test
    public void outboundContainsValue() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).build()).build();
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.containsValue('abc')", this.event)));
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.containsValue('xyz')", this.event)));
    }

    @Test
    public void outboundEntrySet() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).addOutboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Set entrySet = (Set)this.evaluate("message.outboundProperties.entrySet()", this.event);
        Assert.assertEquals((long)2L, (long)entrySet.size());
        entrySet.contains(new DefaultMapEntry((Object)"foo", (Object)"abc"));
        entrySet.contains(new DefaultMapEntry((Object)"bar", (Object)"xyz"));
    }

    @Test
    public void outboundValues() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).addOutboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Collection values = (Collection)this.evaluate("message.outboundProperties.values()", this.event);
        Assert.assertEquals((long)2L, (long)values.size());
        values.contains("abc");
        values.contains("xyz");
    }

    @Test
    public void outboundIsEmpty() throws Exception {
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", this.event)));
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).addOutboundProperty("bar", (Serializable)((Object)"xyz")).build()).build();
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", this.event)));
    }

    @Test
    public void outboundPutAll() throws Exception {
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)this.event);
        this.evaluate("message.outboundProperties.putAll(['foo': 'abc','bar': 'xyz'])", this.event, eventBuilder);
        Assert.assertEquals((Object)"abc", (Object)this.evaluate("message.outboundProperties['foo']", eventBuilder.build()));
        Assert.assertEquals((Object)"xyz", (Object)this.evaluate("message.outboundProperties['bar']", eventBuilder.build()));
    }

    @Test
    public void outboundInboundRemove() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).message((Message)InternalMessage.builder((Message)this.event.getMessage()).addOutboundProperty("foo", (Serializable)((Object)"abc")).build()).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)this.event);
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", this.event)));
        this.evaluate("message.outboundProperties.remove('foo')", this.event, eventBuilder);
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", eventBuilder.build())));
    }
}

