/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.context;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.context.AbstractELTestCase;
import org.mule.runtime.core.internal.message.InternalMessage;

public class PayloadTestCase
extends AbstractELTestCase {
    private CoreEvent event;
    private Message message;
    private CoreEvent.Builder eventBuilder;

    public PayloadTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() throws MuleException {
        this.message = (Message)Mockito.mock(InternalMessage.class);
        this.event = this.getEventBuilder().message(this.message).build();
        this.eventBuilder = (CoreEvent.Builder)Mockito.spy((Object)CoreEvent.builder((CoreEvent)this.event));
    }

    @Test
    public void payload() throws Exception {
        Object payload = new Object();
        Mockito.when((Object)this.message.getPayload()).thenReturn((Object)new TypedValue(payload, DataType.OBJECT));
        Assert.assertSame((Object)payload, (Object)this.evaluate("payload", this.event));
    }

    @Test
    public void assignPayload() throws Exception {
        this.message = Message.of((Object)"");
        this.event = this.getEventBuilder().message(this.message).build();
        this.evaluate("payload = 'foo'", this.event, this.eventBuilder);
        ArgumentCaptor argument = ArgumentCaptor.forClass(InternalMessage.class);
        ((CoreEvent.Builder)Mockito.verify((Object)this.eventBuilder)).message((Message)argument.capture());
        Assert.assertThat((Object)((InternalMessage)argument.getValue()).getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"foo"));
    }
}

