/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.context;

import java.io.Serializable;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.context.AbstractELTestCase;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class VariablesTestCase
extends AbstractELTestCase {
    private CoreEvent event;

    public VariablesTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setup() throws Exception {
        this.event = CoreEvent.builder((EventContext)this.context).message(Message.of((Object)"")).build();
    }

    @Test
    public void flowVariablesMap() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.event).addVariable("foo", (Object)"bar").build();
        Assert.assertTrue((boolean)(this.evaluate("flowVars", this.event) instanceof Map));
    }

    @Test
    public void assignToFlowVariablesMap() throws Exception {
        this.assertImmutableVariable("flowVars='foo'", this.event);
    }

    @Test
    public void flowVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).addVariable("foo", (Object)"bar").build();
        Assert.assertEquals((Object)((TypedValue)event.getVariables().get("foo")).getValue(), (Object)this.evaluate("flowVars['foo']", (CoreEvent)event));
    }

    @Test
    public void assignValueToFlowVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).addVariable("foo", (Object)"bar_old").build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.evaluate("flowVars['foo']='bar'", (CoreEvent)event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)((TypedValue)eventBuilder.build().getVariables().get("foo")).getValue());
    }

    @Test
    public void assignValueToNewFlowVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.evaluate("flowVars['foo']='bar'", (CoreEvent)event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)((TypedValue)eventBuilder.build().getVariables().get("foo")).getValue());
    }

    @Test
    public void sessionVariablesMap() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        ((PrivilegedEvent)event).getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertTrue((boolean)(this.evaluate("sessionVars", (CoreEvent)event) instanceof Map));
    }

    @Test
    public void assignToSessionVariablesMap() throws Exception {
        this.assertImmutableVariable("sessionVars='foo'", this.event);
    }

    @Test
    public void sessionVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertEquals((Object)event.getSession().getProperty("foo"), (Object)this.evaluate("sessionVars['foo']", (CoreEvent)event));
    }

    @Test
    public void assignValueToSessionVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar_old"));
        this.evaluate("sessionVars['foo']='bar'", (CoreEvent)event);
        Assert.assertEquals((Object)"bar", (Object)event.getSession().getProperty("foo"));
    }

    @Test
    public void assignValueToNewSessionVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        this.evaluate("sessionVars['foo']='bar'", (CoreEvent)event);
        Assert.assertEquals((Object)"bar", (Object)((PrivilegedEvent)event).getSession().getProperty("foo"));
    }

    @Test
    public void variableFromFlowScope() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).addVariable("foo", (Object)"bar").build();
        ((PrivilegedEvent)event).getSession().setProperty("foo", (Serializable)((Object)"NOTbar"));
        Assert.assertEquals((Object)((TypedValue)event.getVariables().get("foo")).getValue(), (Object)this.evaluate("foo", (CoreEvent)event));
    }

    @Test
    public void updateVariableFromFlowScope() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).addVariable("foo", (Object)"bar").build();
        Assert.assertEquals((Object)"bar_new", (Object)this.evaluate("foo='bar_new'", (CoreEvent)event));
    }

    @Test
    public void variableFromSessionScope() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        event.getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertEquals((Object)event.getSession().getProperty("foo"), (Object)this.evaluate("foo", (CoreEvent)event));
    }

    @Test
    public void updateVariableFromSessionScope() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        ((PrivilegedEvent)event).getSession().setProperty("foo", (Serializable)((Object)"bar"));
        Assert.assertEquals((Object)"bar_new", (Object)this.evaluate("foo='bar_new'", (CoreEvent)event));
    }

    @Test
    public void assignValueToVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).addVariable("foo", (Object)"bar_old").build();
        CoreEvent.Builder eventBuilder = CoreEvent.builder((CoreEvent)event);
        this.evaluate("foo='bar'", (CoreEvent)event, eventBuilder);
        Assert.assertEquals((Object)"bar", (Object)((TypedValue)eventBuilder.build().getVariables().get("foo")).getValue());
    }

    @Test
    public void assignValueToLocalVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        this.evaluate("localVar='bar'", (CoreEvent)event);
    }

    @Test
    public void reassignValueToLocalVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        this.evaluate("localVar='bar';localVar='bar2'", (CoreEvent)event);
    }

    @Test
    public void localVariable() throws Exception {
        Message message = Message.of((Object)"");
        InternalEvent event = InternalEvent.builder((EventContext)this.context).message(message).build();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("localVar='bar';localVar", (CoreEvent)event));
    }
}

