/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.dataweave;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.api.security.DefaultMuleAuthentication;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.runtime.core.internal.el.dataweave.AbstractWeaveExpressionLanguageTestCase;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.message.BaseAttributes;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;
import org.mule.tck.util.MuleContextUtils;
import org.mule.weave.v2.model.structure.QualifiedName;

@Feature(value="Expression Language")
@Story(value="Support DW")
public class DataWeaveExpressionLanguageAdaptorTestCase
extends AbstractWeaveExpressionLanguageTestCase {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void stringExpression() throws Exception {
        TypedValue result = this.expressionLanguage.evaluate("\"hey\"", this.testEvent(), BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"hey"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)org.hamcrest.Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.STRING)));
    }

    @Test
    public void withPrefixExpression() throws Exception {
        TypedValue result = this.expressionLanguage.evaluate("#[dw:\"hey\"]", this.testEvent(), BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"hey"));
        Assert.assertThat((Object)result.getDataType(), (Matcher)org.hamcrest.Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.STRING)));
    }

    @Test
    public void attributesBinding() throws Exception {
        CoreEvent event = this.getEventWithError(Optional.empty());
        SomeAttributes attributes = new SomeAttributes();
        InternalMessage message = (InternalMessage)Message.builder().nullValue().attributesValue((Object)attributes).build();
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        TypedValue result = this.expressionLanguage.evaluate("attributes", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)attributes)));
        Assert.assertThat((Object)result.getDataType().getType(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo(SomeAttributes.class)));
    }

    @Test
    public void splitByJson() throws Exception {
        CoreEvent jsonMessage = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.builder().value((Object)"[1,2,3]").mediaType(MediaType.APPLICATION_JSON).build()).build();
        Iterator payload = this.expressionLanguage.split("payload", jsonMessage, BindingContext.builder().build());
        Assert.assertThat((Object)payload.hasNext(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)((TypedValue)payload.next()).getValue().toString(), (Matcher)org.hamcrest.Matchers.is((Object)"1"));
        Assert.assertThat((Object)payload.hasNext(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)((TypedValue)payload.next()).getValue().toString(), (Matcher)org.hamcrest.Matchers.is((Object)"2"));
        Assert.assertThat((Object)payload.hasNext(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        Assert.assertThat((Object)((TypedValue)payload.next()).getValue().toString(), (Matcher)org.hamcrest.Matchers.is((Object)"3"));
        Assert.assertThat((Object)payload.hasNext(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void expectedOutputShouldBeUsed() throws Exception {
        CoreEvent jsonMessage = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.builder().value((Object)"{\"student\": false}").mediaType(MediaType.APPLICATION_JSON).build()).build();
        TypedValue result = this.expressionLanguage.evaluate("payload.student", DataType.BOOLEAN, jsonMessage, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void errorBinding() throws Exception {
        Error error = (Error)Mockito.mock(Error.class);
        Optional<Error> opt = Optional.of(error);
        CoreEvent event = this.getEventWithError(opt);
        ((CoreEvent)Mockito.doReturn((Object)this.testEvent().getMessage()).when((Object)event)).getMessage();
        TypedValue result = this.expressionLanguage.evaluate("error", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.sameInstance((Object)error)));
    }

    @Test
    public void fullErrorBinding() throws Exception {
        String description = "An error occurred";
        String detailedDescription = "A division by zero has collapsed our systems.";
        String exceptionMessage = "dividend cannot be zero";
        String errorId = "WEAVE_TEST";
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)errorType.getIdentifier()).thenReturn((Object)errorId);
        Error error = ErrorBuilder.builder().description(description).detailedDescription(detailedDescription).exception((Throwable)new IllegalArgumentException(exceptionMessage)).errorType(errorType).build();
        Optional<Error> opt = Optional.of(error);
        CoreEvent event = this.getEventWithError(opt);
        ((CoreEvent)Mockito.doReturn((Object)this.testEvent().getMessage()).when((Object)event)).getMessage();
        String expression = "'$(error.description) $(error.detailedDescription) $(error.cause.message) $(error.errorType.identifier)'";
        TypedValue result = this.expressionLanguage.evaluate(expression, event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)String.format("%s %s %s %s", description, detailedDescription, exceptionMessage, errorId)));
    }

    @Test
    public void childErrorsErrorBinding() throws Exception {
        String childErrorMessage = "error";
        String otherChildErrorMessage = "oops";
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Error error = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)error.getChildErrors()).thenReturn(Arrays.asList(ErrorBuilder.builder((Throwable)new IOException(childErrorMessage)).errorType(errorType).build(), ErrorBuilder.builder((Throwable)new DefaultMuleException(otherChildErrorMessage)).errorType(errorType).build()));
        Optional<Error> opt = Optional.of(error);
        CoreEvent event = this.getEventWithError(opt);
        ((CoreEvent)Mockito.doReturn((Object)this.testEvent().getMessage()).when((Object)event)).getMessage();
        String expression = "error.childErrors reduce ((child, acc = '') -> acc ++ child.cause.message)";
        TypedValue result = this.expressionLanguage.evaluate(expression, event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)String.format("%s%s", childErrorMessage, otherChildErrorMessage)));
    }

    @Test
    public void messageErrorBinding() throws Exception {
        Error error = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)error.getErrorMessage()).thenReturn((Object)Message.of((Object)new Integer[]{1, 3, 6}));
        Optional<Error> opt = Optional.of(error);
        CoreEvent event = this.getEventWithError(opt);
        ((CoreEvent)Mockito.doReturn((Object)this.testEvent().getMessage()).when((Object)event)).getMessage();
        String expression = "error.errorMessage.payload reduce ($$ + $)";
        TypedValue result = this.expressionLanguage.evaluate(expression, event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)10));
    }

    @Test
    public void errorMessageContainsDataweaveExceptionCauseMessage() throws Exception {
        Error error = (Error)Mockito.mock(Error.class);
        Optional<Error> opt = Optional.of(error);
        CoreEvent event = this.getEventWithError(opt);
        ((CoreEvent)Mockito.doReturn((Object)this.testEvent().getMessage()).when((Object)event)).getMessage();
        String expressionThatThrowsException = "payload + 'foo'";
        this.expectedEx.expect(ExpressionRuntimeException.class);
        this.expectedEx.expectMessage(org.hamcrest.Matchers.containsString((String)"You called the function '+' with these arguments"));
        this.expectedEx.expectMessage(org.hamcrest.Matchers.containsString((String)("evaluating expression: \"" + expressionThatThrowsException)));
        this.expressionLanguage.evaluate(expressionThatThrowsException, event, BindingContext.builder().build());
    }

    @Test
    public void payloadBinding() throws Exception {
        CoreEvent event = this.getEventWithError(Optional.empty());
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        TypedValue payload = new TypedValue((Object)"hey", DataType.STRING);
        TypedValue attributes = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)message.getAttributes()).thenReturn((Object)attributes);
        TypedValue result = this.expressionLanguage.evaluate("payload", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)payload.getValue())));
        Assert.assertThat((Object)result.getDataType(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)payload.getDataType())));
    }

    @Test
    public void dataTypeBinding() throws Exception {
        CoreEvent event = this.getEventWithError(Optional.empty());
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        TypedValue payload = new TypedValue((Object)"hey", DataType.STRING);
        TypedValue attributes = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)payload);
        Mockito.when((Object)message.getAttributes()).thenReturn((Object)attributes);
        TypedValue result = this.expressionLanguage.evaluate("dataType", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo((Object)DataType.STRING)));
        Assert.assertThat((Object)result.getDataType(), (Matcher)org.hamcrest.Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.fromType(DataType.class))));
    }

    @Test
    public void variablesBindings() throws Exception {
        CoreEvent event = this.getEventWithError(Optional.empty());
        String var1 = "var1";
        String var2 = "var2";
        Mockito.when(event.getVariables().keySet()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{var1, var2}));
        TypedValue varValue = new TypedValue(null, DataType.OBJECT);
        Mockito.when((Object)event.getVariables()).thenReturn((Object)ImmutableMap.builder().put((Object)var1, (Object)varValue).put((Object)var2, (Object)varValue).build());
        TypedValue result = this.expressionLanguage.evaluate("vars", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)org.hamcrest.Matchers.hasEntry((Object)var1, (Object)varValue));
        Assert.assertThat((Object)((Map)result.getValue()), (Matcher)org.hamcrest.Matchers.hasEntry((Object)var2, (Object)varValue));
    }

    @Test
    public void variablesCannotOverrideEventBindings() throws MuleException {
        CoreEvent event = (CoreEvent)Mockito.spy((Object)this.testEvent());
        TypedValue varValue = new TypedValue((Object)"", DataType.STRING);
        ImmutableMap variablesMap = ImmutableMap.builder().put((Object)"payload", (Object)varValue).put((Object)"attributes", (Object)varValue).put((Object)"error", (Object)varValue).put((Object)"vars", (Object)varValue).put((Object)"flow", (Object)varValue).build();
        Mockito.when((Object)event.getVariables()).thenReturn((Object)variablesMap);
        String flowName = "myFlowName";
        Assert.assertThat((Object)this.expressionLanguage.evaluate("payload", event, BindingContext.builder().build()).getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"test"));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("attributes", event, BindingContext.builder().build()).getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("error", event, BindingContext.builder().build()).getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("vars", event, BindingContext.builder().build()).getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf(Map.class)));
        Assert.assertThat((Object)this.expressionLanguage.evaluate("flow.name", event, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)flowName), BindingContext.builder().build()).getValue(), (Matcher)org.hamcrest.Matchers.is((Object)flowName));
    }

    @Test
    public void messageBinding() throws Exception {
        CoreEvent event = this.testEvent();
        TypedValue result = this.expressionLanguage.evaluate("message", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf(Message.class)));
        Assert.assertEquals((Object)((Message)result.getValue()).getPayload(), (Object)event.getMessage().getPayload());
    }

    @Test
    public void nullItemSequenceInfoBinding() throws Exception {
        CoreEvent event = this.testEvent();
        TypedValue result = this.expressionLanguage.evaluate("itemSequenceInfo", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
    }

    @Test
    public void noSequenceSizeItemSequenceInfoBinding() throws Exception {
        CoreEvent event = (CoreEvent)Mockito.spy((Object)this.testEvent());
        Mockito.when((Object)event.getItemSequenceInfo()).thenReturn(Optional.of(ItemSequenceInfo.of((int)43)));
        TypedValue result = this.expressionLanguage.evaluate("itemSequenceInfo.position", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)43));
        result = this.expressionLanguage.evaluate("itemSequenceInfo.sequenceSize", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
    }

    @Test
    public void itemSequenceInfoBinding() throws Exception {
        CoreEvent event = (CoreEvent)Mockito.spy((Object)this.testEvent());
        Mockito.when((Object)event.getItemSequenceInfo()).thenReturn(Optional.of(ItemSequenceInfo.of((int)43, (int)100)));
        TypedValue result = this.expressionLanguage.evaluate("itemSequenceInfo.position", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)43));
        result = this.expressionLanguage.evaluate("itemSequenceInfo.sequenceSize", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)100));
    }

    @Test
    public void authenticationBinding() throws Exception {
        CoreEvent event = (CoreEvent)Mockito.spy((Object)this.testEvent());
        DefaultMuleAuthentication authentication = new DefaultMuleAuthentication((Credentials)new DefaultMuleCredentials("username", "password".toCharArray()));
        Mockito.when((Object)event.getAuthentication()).thenReturn(Optional.of(authentication));
        TypedValue result = this.expressionLanguage.evaluate("authentication", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf(Authentication.class)));
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)authentication));
        Assert.assertThat((Object)result.getDataType().getType(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.equalTo(Authentication.class)));
    }

    @Test
    public void authenticationBindingWhenNullSecurityContext() throws Exception {
        CoreEvent event = (CoreEvent)Mockito.spy((Object)this.testEvent());
        TypedValue result = this.expressionLanguage.evaluate("authentication", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.nullValue()));
    }

    @Test
    public void accessRegistryBean() throws MuleException {
        CoreEvent event = this.testEvent();
        Mockito.when((Object)this.registry.lookupByName("myBean")).thenReturn(Optional.of(new MyBean("DataWeave")));
        TypedValue evaluate = this.expressionLanguage.evaluate("app.registry.myBean.name", event, BindingContext.builder().build());
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)"DataWeave"));
    }

    @Test
    public void accessRegistryAnnotatedBean() throws MuleException {
        CoreEvent event = this.testEvent();
        Mockito.when((Object)this.registry.lookupByName("myBean")).thenReturn(Optional.of(new MyAnnotatedBean("DataWeave")));
        TypedValue evaluate = this.expressionLanguage.evaluate("app.registry.myBean", DataType.fromType(MyBean.class), event, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"flow"), BindingContext.builder().build(), false);
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf(MyAnnotatedBean.class)));
    }

    @Test
    public void accessRegistryCglibAnnotatedBean() throws Exception {
        CoreEvent event = this.testEvent();
        MyBean annotatedMyBean = (MyBean)AnnotatedObjectInvocationHandler.addAnnotationsToClass(MyBean.class).newInstance();
        annotatedMyBean.setName("DataWeave");
        Mockito.when((Object)this.registry.lookupByName("myBean")).thenReturn(Optional.of(annotatedMyBean));
        TypedValue evaluate = this.expressionLanguage.evaluate("app.registry.myBean", DataType.fromType(MyBean.class), event, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"flow"), BindingContext.builder().build(), false);
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.instanceOf(MyBean.class)));
    }

    @Test
    public void accessServerFileSeparator() throws MuleException {
        CoreEvent event = this.testEvent();
        Mockito.when((Object)this.registry.lookupByName("myBean")).thenReturn(Optional.of(new MyBean("DataWeave")));
        TypedValue evaluate = this.expressionLanguage.evaluate("server.fileSeparator", event, BindingContext.builder().build());
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)SystemUtils.FILE_SEPARATOR));
    }

    @Test
    public void accessMuleVersion() throws MuleException {
        CoreEvent event = this.testEvent();
        Mockito.when((Object)this.registry.lookupByName("myBean")).thenReturn(Optional.of(new MyBean("DataWeave")));
        TypedValue evaluate = this.expressionLanguage.evaluate("mule.version", event, BindingContext.builder().build());
        Assert.assertThat((Object)evaluate.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)MuleManifest.getProductVersion()));
    }

    @Test
    public void flowNameBinding() {
        CoreEvent event = this.getEventWithError(Optional.empty());
        String flowName = "myFlowName";
        TypedValue result = this.expressionLanguage.evaluate("flow.name", event, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)flowName), BindingContext.builder().build());
        Assert.assertThat((Object)result.getDataType(), (Matcher)org.hamcrest.Matchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.STRING)));
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)flowName));
    }

    @Test
    public void payloadExpressionShouldNotBeEvaluate() throws MuleException {
        BindingContext bindingContext = BindingContext.builder().build();
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        DefaultExpressionLanguageFactoryService languageFactory = (DefaultExpressionLanguageFactoryService)Mockito.mock(DefaultExpressionLanguageFactoryService.class);
        ExpressionLanguage expressionLanguage = (ExpressionLanguage)Mockito.spy(ExpressionLanguage.class);
        Mockito.when((Object)languageFactory.create()).thenReturn((Object)expressionLanguage);
        CoreEvent event = this.testEvent();
        new DataWeaveExpressionLanguageAdaptor(muleContext, this.registry, languageFactory).evaluate("#[payload]", event, bindingContext);
        ((ExpressionLanguage)Mockito.verify((Object)expressionLanguage, (VerificationMode)Mockito.never())).evaluate((String)Matchers.eq((Object)"payload"), (BindingContext)Matchers.any(BindingContext.class));
    }

    @Test
    public void entrySetFunction() throws Exception {
        String key = "foo";
        String value = "bar";
        CoreEvent event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.builder().value(Collections.singletonMap("foo", "bar")).build()).build();
        TypedValue result = this.expressionLanguage.evaluate("dw::core::Objects::entrySet(payload)", event, BindingContext.builder().build());
        Assert.assertThat((Object)result.getValue(), (Matcher)org.hamcrest.Matchers.instanceOf(List.class));
        Assert.assertThat(((List)result.getValue()).get(0), (Matcher)org.hamcrest.Matchers.instanceOf(Map.class));
        Map entry = (Map)((List)result.getValue()).get(0);
        Assert.assertThat(entry.get("key"), (Matcher)org.hamcrest.Matchers.instanceOf(QualifiedName.class));
        Assert.assertThat((Object)((QualifiedName)entry.get("key")).name(), (Matcher)org.hamcrest.Matchers.equalTo((Object)"foo"));
        Assert.assertThat(entry.get("value"), (Matcher)org.hamcrest.Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void unbalancedBrackets() throws MuleException {
        CoreEvent event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"test")).build();
        this.expectedEx.expect(ExpressionExecutionException.class);
        this.expectedEx.expectMessage(org.hamcrest.Matchers.containsString((String)"Unbalanced brackets in expression"));
        this.expressionLanguage.evaluate("#[unbalanced", event, BindingContext.builder().build());
    }

    private CoreEvent getEventWithError(Optional<Error> error) {
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ((CoreEvent)Mockito.doReturn(error).when((Object)event)).getError();
        Mockito.when((Object)event.getMessage().getPayload()).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        Mockito.when((Object)event.getMessage().getAttributes()).thenReturn((Object)new TypedValue(null, DataType.OBJECT));
        Mockito.when((Object)event.getAuthentication()).thenReturn(Optional.empty());
        Mockito.when((Object)event.getItemSequenceInfo()).thenReturn(Optional.empty());
        return event;
    }

    private static class MyAnnotatedBean
    extends MyBean
    implements Component {
        private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();

        public MyAnnotatedBean(String name) {
            super(name);
        }

        public Object getAnnotation(QName qName) {
            return this.annotations.get(qName);
        }

        public Map<QName, Object> getAnnotations() {
            return Collections.unmodifiableMap(this.annotations);
        }

        public synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
            this.annotations.clear();
            this.annotations.putAll(newAnnotations);
        }

        public ComponentLocation getLocation() {
            return (ComponentLocation)this.getAnnotation(AbstractComponent.LOCATION_KEY);
        }

        private String getRootContainerName() {
            String rootContainerName = (String)this.getAnnotation(AbstractComponent.ROOT_CONTAINER_NAME_KEY);
            if (rootContainerName == null) {
                rootContainerName = this.getLocation().getRootContainerName();
            }
            return rootContainerName;
        }

        public Location getRootContainerLocation() {
            return Location.builder().globalName(this.getRootContainerName()).build();
        }
    }

    public static class MyBean {
        private String name;

        public MyBean() {
        }

        public MyBean(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private class SomeAttributes
    extends BaseAttributes {
        private SomeAttributes() {
        }
    }
}

