/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.dataweave;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import io.qameta.allure.junit4.DisplayName;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.el.ExpressionLanguageAdaptorHandler;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.context.MessageContext;
import org.mule.runtime.core.internal.el.dataweave.AbstractWeaveExpressionLanguageTestCase;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.util.MuleContextUtils;

@Feature(value="Expression Language")
@Story(value="Support both MVEL and DW")
@DisplayName(value="MVEL vs. DW Expression Language")
public class ExtendedExpressionLanguageAdapterTestCase
extends AbstractWeaveExpressionLanguageTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ExpressionLanguageAdaptorHandler expressionLanguageAdapter;
    private BindingContext emptyBindingContext = BindingContext.builder().build();

    @Override
    @Before
    public void setUp() {
        super.setUp();
        MVELExpressionLanguage mvelExpressionLanguage = (MVELExpressionLanguage)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject("_muleExpressionLanguage");
        this.expressionLanguageAdapter = new ExpressionLanguageAdaptorHandler((ExtendedExpressionLanguageAdaptor)this.expressionLanguage, (ExtendedExpressionLanguageAdaptor)mvelExpressionLanguage);
    }

    @Test
    @Description(value="Verifies that global binding context only work for DW.")
    public void globalContext() throws Exception {
        ExpressionFunction expressionFunction = new ExpressionFunction(){
            private DataType dataType = DataType.STRING;

            public Object call(Object[] objects, BindingContext bindingContext) {
                return ((String)objects[0]).toUpperCase();
            }

            public Optional<DataType> returnType() {
                return Optional.of(this.dataType);
            }

            public List<FunctionParameter> parameters() {
                return Arrays.asList(new FunctionParameter("x", this.dataType));
            }
        };
        String global = "global";
        String value = "var";
        BindingContext context = BindingContext.builder().addBinding(global, new TypedValue((Object)value, DataType.STRING)).addBinding("upper", new TypedValue((Object)expressionFunction, DataType.fromFunction((ExpressionFunction)expressionFunction))).build();
        this.expressionLanguageAdapter.addGlobalBindings(context);
        Assert.assertThat((Object)this.expressionLanguageAdapter.evaluate(global, this.testEvent(), this.emptyBindingContext).getValue(), (Matcher)Matchers.is((Object)value));
        Assert.assertThat((Object)this.expressionLanguageAdapter.evaluate("upper('hey')", this.testEvent(), this.emptyBindingContext).getValue(), (Matcher)Matchers.is((Object)"HEY"));
        Assert.assertThat((Object)this.expressionLanguageAdapter.evaluate(this.melify(global), this.testEvent(), context).getValue(), (Matcher)Matchers.is((Object)value));
        this.expectedException.expect(ExpressionRuntimeException.class);
        this.expressionLanguageAdapter.evaluate(this.melify(global), this.testEvent(), this.emptyBindingContext);
    }

    @Test
    @Description(value="Verifies that the Event variable still works for MVEL but that it fails for DW.")
    public void eventCompatibilityVariables() throws MuleException {
        String expression = "_muleEvent";
        Object mvelFlowResult = this.expressionLanguageAdapter.evaluate(this.melify(expression), this.testEvent(), this.emptyBindingContext).getValue();
        Assert.assertThat((Object)mvelFlowResult, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(CoreEvent.class)));
        this.expectedException.expect(RuntimeException.class);
        this.expressionLanguageAdapter.evaluate(expression, this.testEvent(), this.emptyBindingContext).getValue();
    }

    @Test
    @Description(value="Verifies that the MuleContext variable still works for MVEL but that it fails for DW.")
    public void muleContextCompatibilityVariables() throws MuleException {
        String expression = "_muleContext";
        Object mvelFlowResult = this.expressionLanguageAdapter.evaluate(this.melify(expression), this.testEvent(), this.emptyBindingContext).getValue();
        Assert.assertThat((Object)mvelFlowResult, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MuleContext.class)));
        this.expectedException.expect(RuntimeException.class);
        this.expressionLanguageAdapter.evaluate(expression, this.testEvent(), this.emptyBindingContext).getValue();
    }

    @Test
    @Description(value="Verifies that the Message variable works for MVEL and DW.")
    public void messageCompatibilityVariables() throws MuleException {
        String expression = "message";
        Object mvelFlowResult = this.expressionLanguageAdapter.evaluate(this.melify(expression), this.testEvent(), this.emptyBindingContext).getValue();
        Assert.assertThat((Object)mvelFlowResult, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MessageContext.class)));
        Object dwFlowResult = this.expressionLanguageAdapter.evaluate(expression, this.testEvent(), this.emptyBindingContext).getValue();
        Assert.assertThat((Object)dwFlowResult, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Message.class)));
    }

    @Test
    @Description(value="Verifies that the Flow name variable works for MVEL and DW.")
    public void flowNameVariable() throws MuleException {
        String expression = "flow.name";
        String myFlowName = "myFlowName";
        TypedValue mvelResult = this.expressionLanguageAdapter.evaluate(this.melify(expression), this.testEvent(), (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)myFlowName), this.emptyBindingContext);
        Assert.assertThat((Object)mvelResult.getValue(), (Matcher)Matchers.is((Object)myFlowName));
        TypedValue dwResult = this.expressionLanguageAdapter.evaluate(expression, this.testEvent(), (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)myFlowName), this.emptyBindingContext);
        Assert.assertThat((Object)dwResult.getValue(), (Matcher)Matchers.is((Object)myFlowName));
    }

    @Test
    @Description(value="Verifies that variables can be modified under MVEL but not DW.")
    public void variablesMutation() throws Exception {
        CoreEvent event = this.testEvent();
        CoreEvent.Builder builder1 = CoreEvent.builder((CoreEvent)event);
        TypedValue result = this.expressionLanguageAdapter.evaluate(this.melify("flowVars.put('key','value')"), event, builder1, TEST_CONNECTOR_LOCATION, this.emptyBindingContext);
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat(builder1.build().getVariables().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"key"}));
        CoreEvent.Builder builder2 = CoreEvent.builder((CoreEvent)event);
        TypedValue result2 = this.expressionLanguageAdapter.evaluate("vars.put('key','value')", event, builder2, TEST_CONNECTOR_LOCATION, this.emptyBindingContext);
        Assert.assertThat((Object)result2.getValue(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat(builder2.build().getVariables().keySet(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"key"})));
    }

    @Test
    @Description(value="Verifies that the payload can be modified under MVEL but not DW.")
    public void payloadMutation() throws Exception {
        CoreEvent event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)1)).build();
        CoreEvent.Builder builder1 = CoreEvent.builder((CoreEvent)event);
        String expression = "payload = 3";
        TypedValue result = this.expressionLanguageAdapter.evaluate(this.melify(expression), event, builder1, TEST_CONNECTOR_LOCATION, this.emptyBindingContext);
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)builder1.build().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)3));
        CoreEvent.Builder builder2 = CoreEvent.builder((CoreEvent)event);
        this.expectedException.expect(ExpressionRuntimeException.class);
        this.expressionLanguageAdapter.evaluate(expression, event, builder2, TEST_CONNECTOR_LOCATION, this.emptyBindingContext);
    }

    @Test
    @Description(value="Verifies that enrichment using an Object only works for MVEL.")
    public void enrichObjectCompatibility() throws MuleException {
        CoreEvent event = this.testEvent();
        CoreEvent.Builder builder = CoreEvent.builder((CoreEvent)event);
        String myPayload = "myPayload";
        String expression = "payload";
        this.expressionLanguageAdapter.enrich(this.melify(expression), event, builder, TEST_CONNECTOR_LOCATION, (Object)myPayload);
        Assert.assertThat((Object)builder.build().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)myPayload));
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expressionLanguageAdapter.enrich(expression, event, builder, TEST_CONNECTOR_LOCATION, (Object)myPayload);
    }

    @Test
    @Description(value="Verifies that enrichment using a TypedValue only works for MVEL.")
    public void enrichTypedValueCompatibility() throws MuleException {
        CoreEvent event = this.testEvent();
        CoreEvent.Builder builder = CoreEvent.builder((CoreEvent)event);
        TypedValue myPayload = new TypedValue((Object)"myPayload", DataType.STRING);
        String expression = "payload";
        this.expressionLanguageAdapter.enrich(this.melify(expression), event, builder, TEST_CONNECTOR_LOCATION, myPayload);
        CoreEvent enrichedEvent = builder.build();
        Assert.assertThat((Object)enrichedEvent.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)myPayload.getValue()));
        Assert.assertThat((Object)enrichedEvent.getMessage().getPayload().getDataType(), (Matcher)Matchers.is((Object)myPayload.getDataType()));
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expressionLanguageAdapter.enrich(expression, event, builder, TEST_CONNECTOR_LOCATION, myPayload);
    }

    private String melify(String expression) {
        return String.format("mel:%s", expression);
    }
}

