/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel;

import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.el.context.AbstractELTestCase;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionExecutor;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguageContext;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.size.SmallTest;
import org.objectweb.asm.ClassWriter;

@SmallTest
public class MVELExpressionExecutorTestCase
extends AbstractELTestCase {
    public static final String SIMPLE_EXPRESSION = "'hi'";
    protected MVELExpressionExecutor mvel;
    protected MVELExpressionLanguageContext context;

    public MVELExpressionExecutorTestCase(String mvelOptimizer) {
        super(mvelOptimizer);
    }

    @Before
    public void setupMVEL() throws InitialisationException {
        this.mvel = new MVELExpressionExecutor(new ParserConfiguration());
        this.context = (MVELExpressionLanguageContext)Mockito.mock(MVELExpressionLanguageContext.class);
        Mockito.when((Object)this.context.isResolveable(Mockito.anyString())).thenReturn((Object)false);
    }

    @Test
    public void evaluateReturnInt() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*2", null));
    }

    @Test
    public void evaluateReturnString() {
        Assert.assertEquals((Object)"hi", (Object)this.mvel.execute(SIMPLE_EXPRESSION, null));
    }

    @Test(expected=CompileException.class)
    public void evaluateInvalidExpression() {
        Assert.assertEquals((Object)4, (Object)this.mvel.execute("2*'2", null));
    }

    @Test(expected=CompileException.class)
    public void invalidExpression() {
        this.mvel.validate("a9-#'");
    }

    @Test
    public void validExpression() {
        this.mvel.validate("var a = 2");
    }

    @Test
    public void useContextClassLoader() throws ClassNotFoundException {
        ClassUtils.withContextClassLoader((ClassLoader)new MyClassClassLoader(), () -> {
            try {
                Assert.assertFalse((boolean)((Boolean)this.mvel.execute("1 is org.MyClass", null)));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        });
    }

    @Test
    public void safeMapPropertyAccessIsEnabled() {
        Assert.assertEquals(null, (Object)this.mvel.execute("['test1' : null].doesntExist", this.context));
    }

    @Test
    public void safeMapNestedPropertyAccessIsEnabled() {
        Assert.assertEquals(null, (Object)this.mvel.execute("['test1' : null].test1", this.context));
    }

    @Test
    public void safeBeanPropertyAccessIsEnabled() {
        Assert.assertNull((Object)this.mvel.execute("new Object().doesntExist", this.context));
    }

    @Test
    public void safeNestedBeanPropertyAccessIsEnabled() {
        Assert.assertNull((Object)this.mvel.execute("new Object().?doesntExist.other", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void nestedMapAccessFailsCorrectly() {
        Assert.assertNull((Object)this.mvel.execute("['test1' : null]['test2']['test2']", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void safeNestedBeanPropertyAccessMaintainsNullSafeBehavior() {
        Assert.assertNull((Object)this.mvel.execute("new Object().doesntExist.other", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void safeNestedMapPropertyAccessMaintainsNullSafeBehavior() {
        Assert.assertNull((Object)this.mvel.execute("['test1' : null].doesntExist.other", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void safePropertyDoesntMessNullSafeMode() {
        Assert.assertNull((Object)this.mvel.execute("null.doesntExist", this.context));
    }

    @Test(expected=RuntimeException.class)
    public void invalidMethodCallFails() {
        Assert.assertNull((Object)this.mvel.execute("new Object().doesntExist()", this.context));
    }

    @Test
    public void cachesCompiledExpressions() throws Exception {
        Serializable compiledExpression1 = this.mvel.getCompiledExpression(SIMPLE_EXPRESSION);
        Serializable compiledExpression2 = this.mvel.getCompiledExpression(SIMPLE_EXPRESSION);
        Assert.assertThat((Object)compiledExpression1, (Matcher)Matchers.is((Object)compiledExpression2));
    }

    @Test
    public void doesNotCachesCompiledExpressions() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.disableMelExpressionCache", (String)"", (MuleTestUtils.TestCallback)new MuleTestUtils.TestCallback(){

            public void run() throws Exception {
                MVELExpressionExecutorTestCase.this.setupMVEL();
                Serializable compiledExpression1 = MVELExpressionExecutorTestCase.this.mvel.getCompiledExpression(MVELExpressionExecutorTestCase.SIMPLE_EXPRESSION);
                Serializable compiledExpression2 = MVELExpressionExecutorTestCase.this.mvel.getCompiledExpression(MVELExpressionExecutorTestCase.SIMPLE_EXPRESSION);
                Assert.assertThat((Object)compiledExpression1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)compiledExpression2)));
            }
        });
    }

    static class MyClassClassLoader
    extends ClassLoader {
        MyClassClassLoader() {
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            if (className.equals("org.MyClass")) {
                ClassWriter cw = new ClassWriter(2);
                cw.visit(49, 1, "org/MyClass", null, "java/lang/Object", null);
                return this.defineClass(className, cw.toByteArray(), 0, cw.toByteArray().length);
            }
            return super.findClass(className);
        }
    }
}

