/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.PropertyAccessException;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.AbstractDataTypeBuilderFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.el.context.MessageContext;
import org.mule.runtime.core.internal.el.mvel.ExpressionLanguageContext;
import org.mule.runtime.core.internal.el.mvel.ExpressionLanguageExtension;
import org.mule.runtime.core.internal.el.mvel.ExpressionLanguageFunction;
import org.mule.runtime.core.internal.el.mvel.MVELArtifactContext;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.el.mvel.function.RegexExpressionLanguageFuntion;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;

@RunWith(value=Parameterized.class)
public class MVELExpressionLanguageTestCase
extends AbstractMuleContextTestCase {
    protected Variant variant;
    protected MVELExpressionLanguage mvel;
    private FlowConstruct flowConstruct;
    final String largeExpression = "payload = 'Tom,Fennelly,Male,4,Ireland';StringBuilder sb = new StringBuilder(); fields = payload.split(',');if (fields.length > 4) {    sb.append('  <Contact>\n');    sb.append('    <FirstName>').append(fields[0]).append('</FirstName>\n');    sb.append('    <LastName>').append(fields[1]).append('</LastName>\n');    sb.append('    <Address>').append(fields[2]).append('</Address>\n');    sb.append('    <TelNum>').append(fields[3]).append('</TelNum>\n');    sb.append('    <SIN>').append(fields[4]).append('</SIN>\n');    sb.append('  </Contact>\n');}sb.toString();";
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    public MVELExpressionLanguageTestCase(Variant variant, String mvelOptimizer) {
        this.variant = variant;
        OptimizerFactory.setDefaultOptimizer((String)mvelOptimizer);
    }

    @Before
    public void setupMVEL() throws InitialisationException {
        this.mvel = new MVELExpressionLanguage(muleContext);
        this.mvel.initialise();
        this.flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
        Mockito.when((Object)this.flowConstruct.getName()).thenReturn((Object)"myFlow");
        DefaultComponentLocation location = DefaultComponentLocation.fromSingleComponent((String)"myFlow");
        Mockito.when((Object)this.flowConstruct.getAnnotation(AbstractComponent.LOCATION_KEY)).thenReturn((Object)location);
        Mockito.when((Object)this.flowConstruct.getLocation()).thenReturn((Object)location);
    }

    @Test
    public void testEvaluateString() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'"));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2"));
        Assert.assertEquals((Object)"hiho", (Object)this.evaluate("'hi'+'ho'"));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone"));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version"));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name"));
    }

    @Test
    public void testEvaluateStringMapOfStringObject() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", Collections.emptyMap()));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", Collections.emptyMap()));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", Collections.emptyMap()));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", Collections.emptyMap()));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", Collections.emptyMap()));
        Assert.assertEquals((Object)1, (Object)this.evaluate("foo", Collections.singletonMap("foo", 1)));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", Collections.singletonMap("foo", "bar")));
    }

    @Test
    public void testEvaluateStringMuleEvent() throws Exception {
        PrivilegedEvent event = this.createEvent();
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", event));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", event));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", event));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", event));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", event));
        Assert.assertEquals((Object)"myFlow", (Object)this.evaluate("flow.name", event));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", event));
    }

    @Test
    public void testEvaluateMapOfStringObject() throws Exception {
        PrivilegedEvent event = this.createEvent();
        Assert.assertEquals((Object)1, (Object)this.evaluate("foo", Collections.singletonMap("foo", 1)));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", Collections.singletonMap("foo", "bar")));
    }

    @Test
    public void testEvaluateStringMuleMessage() throws Exception {
        PrivilegedEvent event = this.createEvent();
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", event));
    }

    @Test
    public void testEvaluateAttributes() throws Exception {
        PrivilegedEvent event = this.createEventWithAttributes();
        Assert.assertEquals((Object)"number 1", (Object)this.evaluate("attributes.one", event));
        Assert.assertEquals((Object)"number 2", (Object)this.evaluate("attributes.two", event));
    }

    @Test
    public void testValidate() {
        Assert.assertThat((Object)this.validate("2*2").isSuccess(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testValidateInvalid() {
        Assert.assertThat((Object)this.validate("2*'2").isSuccess(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void regexFunction() throws Exception {
        PrivilegedEvent testEvent = ((PrivilegedEvent.Builder)this.getEventBuilder()).message(Message.of((Object)"TESTfooTEST")).build();
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("regex('TEST(\\\\w+)TEST')", testEvent));
    }

    @Test
    public void appTakesPrecedenceOverEverything() throws Exception {
        this.mvel.setAliases(Collections.singletonMap("app", "'other1'"));
        PrivilegedEvent event = ((PrivilegedEvent.Builder)this.getEventBuilder()).message(Message.of((Object)"")).addVariable("app", (Object)"otherb").build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("foo", context -> context.addVariable("app", (Object)"otherc"));
        this.mvel.initialise();
        Assert.assertEquals(MVELArtifactContext.class, this.evaluate("app", event).getClass());
    }

    @Test
    public void messageTakesPrecedenceOverEverything() throws Exception {
        this.mvel.setAliases(Collections.singletonMap("message", "'other1'"));
        PrivilegedEvent event = ((PrivilegedEvent.Builder)this.getEventBuilder()).message(Message.of((Object)"")).addVariable("message", (Object)"other2").build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("foo", context -> context.addVariable("message", (Object)"other3"));
        this.mvel.initialise();
        Assert.assertEquals(MessageContext.class, this.evaluate("message", event).getClass());
    }

    @Test
    public void extensionTakesPrecedenceOverAutoResolved() throws Exception {
        PrivilegedEvent event = ((PrivilegedEvent.Builder)this.getEventBuilder()).message(Message.of((Object)"")).addVariable("foo", (Object)"other").build();
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("key", context -> context.addVariable("foo", (Object)"bar"));
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", event));
    }

    @Test
    public void aliasTakesPrecedenceOverAutoResolved() throws RegistrationException, InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("foo", "'bar'"));
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("key", context -> context.addVariable("foo", (Object)"other"));
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo"));
    }

    @Test
    public void aliasTakesPrecedenceOverExtension() throws Exception {
        this.mvel.setAliases(Collections.singletonMap("foo", "'bar'"));
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo"));
    }

    @Test
    public void addImport() throws InitialisationException {
        this.mvel.setImports(Collections.singletonMap("loc", Locale.class));
        this.mvel.initialise();
        Assert.assertEquals(Locale.class, (Object)this.evaluate("loc"));
    }

    @Test
    public void addAlias() throws InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("appName", "app.name"));
        this.mvel.initialise();
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("appName"));
    }

    @Test
    public void addGlobalFunction() throws InitialisationException {
        this.mvel.addGlobalFunction("hello", (Function)new HelloWorldFunction(new ParserContext(this.mvel.parserConfiguration)));
        this.mvel.initialise();
        Assert.assertEquals((Object)"Hello World!", (Object)this.evaluate("hello()"));
    }

    @Test
    public void defaultImports() throws InitialisationException, ClassNotFoundException, IOException {
        Assert.assertEquals(InputStream.class, (Object)this.evaluate(InputStream.class.getSimpleName()));
        Assert.assertEquals(FileReader.class, (Object)this.evaluate(FileReader.class.getSimpleName()));
        Assert.assertEquals(Object.class, (Object)this.evaluate(Object.class.getSimpleName()));
        Assert.assertEquals(System.class, (Object)this.evaluate(System.class.getSimpleName()));
        Assert.assertEquals(URI.class, (Object)this.evaluate(URI.class.getSimpleName()));
        Assert.assertEquals(URL.class, (Object)this.evaluate(URL.class.getSimpleName()));
        Assert.assertEquals(Collection.class, (Object)this.evaluate(Collection.class.getSimpleName()));
        Assert.assertEquals(List.class, (Object)this.evaluate(List.class.getSimpleName()));
        Assert.assertEquals(BigDecimal.class, (Object)this.evaluate(BigDecimal.class.getSimpleName()));
        Assert.assertEquals(BigInteger.class, (Object)this.evaluate(BigInteger.class.getSimpleName()));
        Assert.assertEquals(DataHandler.class, (Object)this.evaluate(DataHandler.class.getSimpleName()));
        Assert.assertEquals(MimeType.class, (Object)this.evaluate(MimeType.class.getSimpleName()));
        Assert.assertEquals(Pattern.class, (Object)this.evaluate(Pattern.class.getSimpleName()));
        Assert.assertEquals(DataType.class, (Object)this.evaluate(DataType.class.getSimpleName()));
        Assert.assertEquals(AbstractDataTypeBuilderFactory.class, (Object)this.evaluate(AbstractDataTypeBuilderFactory.class.getSimpleName()));
    }

    @Test
    public void testConcurrentCompilation() throws Exception {
        int N = 100;
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(100);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            new Thread(() -> {
                try {
                    start.await();
                    this.evaluate("payload = 'Tom,Fennelly,Male,4,Ireland';StringBuilder sb = new StringBuilder(); fields = payload.split(',');if (fields.length > 4) {    sb.append('  <Contact>\n');    sb.append('    <FirstName>').append(fields[0]).append('</FirstName>\n');    sb.append('    <LastName>').append(fields[1]).append('</LastName>\n');    sb.append('    <Address>').append(fields[2]).append('</Address>\n');    sb.append('    <TelNum>').append(fields[3]).append('</TelNum>\n');    sb.append('    <SIN>').append(fields[4]).append('</SIN>\n');    sb.append('  </Contact>\n');}sb.toString();" + new Random().nextInt());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    end.countDown();
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void testConcurrentEvaluation() throws Exception {
        int N = 100;
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch end = new CountDownLatch(100);
        AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            new Thread(() -> {
                try {
                    start.await();
                    this.testEvaluateString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    end.countDown();
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void propertyAccessException() throws InitialisationException {
        try {
            this.evaluate("doesntExist");
        }
        catch (Exception e) {
            Assert.assertEquals(ExpressionRuntimeException.class, e.getClass());
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CompileException.class));
        }
    }

    @Test
    public void propertyAccessException2() throws InitialisationException {
        try {
            this.evaluate("app.doesntExist");
        }
        catch (Exception e) {
            Assert.assertEquals(ExpressionRuntimeException.class, e.getClass());
            Assert.assertEquals(PropertyAccessException.class, e.getCause().getClass());
        }
    }

    @Test
    public void expressionExceptionHasMvelCauseMessage() throws InitialisationException {
        String expressionWhichThrowsError = "doesntExist";
        this.expectedEx.expect(ExpressionRuntimeException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)("Error: unresolvable property or identifier: " + expressionWhichThrowsError)));
        this.expectedEx.expectMessage(Matchers.containsString((String)("evaluating expression: \"" + expressionWhichThrowsError + "\"")));
        this.evaluate(expressionWhichThrowsError);
    }

    @Test
    public void returnsDataType() throws Exception {
        DataType dataType = DataType.builder().type(String.class).mediaType(MediaType.JSON).charset(StandardCharsets.UTF_16.name()).build();
        PrivilegedEvent event = this.createEvent("Test Message", dataType);
        TypedValue typedValue = this.evaluateTyped("payload", (CoreEvent)event);
        Assert.assertThat((Object)((String)typedValue.getValue()), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        Assert.assertThat((Object)typedValue.getDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.JSON, (Charset)StandardCharsets.UTF_16));
    }

    protected Object evaluate(String expression) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluateUntyped("#[mel:" + expression + "]", null, null, null, null);
        }
        return this.mvel.evaluateUntyped(expression, null, null, null, null);
    }

    protected TypedValue evaluateTyped(String expression, CoreEvent event) throws Exception {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluate("#[mel:" + expression + "]", event, CoreEvent.builder((CoreEvent)event), this.flowConstruct.getLocation(), BindingContext.builder().build());
        }
        return this.mvel.evaluate(expression, event, CoreEvent.builder((CoreEvent)event), this.flowConstruct.getLocation(), BindingContext.builder().build());
    }

    protected Object evaluate(String expression, Map<String, Object> vars) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluateUntyped("#[mel:" + expression + "]", vars);
        }
        return this.mvel.evaluateUntyped(expression, vars);
    }

    protected Object evaluate(String expression, PrivilegedEvent event) throws Exception {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluateUntyped("#[mel:" + expression + "]", event, PrivilegedEvent.builder((CoreEvent)event), this.flowConstruct.getLocation(), null);
        }
        return this.mvel.evaluateUntyped(expression, event, PrivilegedEvent.builder((CoreEvent)event), this.flowConstruct.getLocation(), null);
    }

    protected ValidationResult validate(String expression) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.validate("#[mel:" + expression + "]");
        }
        return this.mvel.validate(expression);
    }

    protected PrivilegedEvent createEvent(DataType dataType) {
        return this.createEvent("foo", DataType.STRING);
    }

    protected PrivilegedEvent createEventWithAttributes(DataType dataType) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("one", "number 1");
        attributes.put("two", "number 2");
        return this.createEvent("foo", DataType.STRING, attributes, DataType.OBJECT);
    }

    protected PrivilegedEvent createEvent(String payload, DataType dataType) {
        return this.createEvent(payload, dataType, null, DataType.OBJECT);
    }

    protected PrivilegedEvent createEvent(String payload, DataType dataType, Object attributes, DataType attributesDataType) {
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)new TypedValue((Object)payload, dataType));
        Mockito.when((Object)message.getAttributes()).thenReturn((Object)new TypedValue(attributes, attributesDataType));
        try {
            return ((PrivilegedEvent.Builder)this.getEventBuilder()).message((Message)message).build();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected PrivilegedEvent createEvent() {
        return this.createEvent(DataType.STRING);
    }

    protected PrivilegedEvent createEventWithAttributes() {
        return this.createEventWithAttributes(DataType.STRING);
    }

    @Parameterized.Parameters(name="{0}, {1}")
    public static List<Object[]> parameters() {
        return Arrays.asList({Variant.EXPRESSION_WITH_DELIMITER, OptimizerFactory.SAFE_REFLECTIVE}, {Variant.EXPRESSION_WITH_DELIMITER, OptimizerFactory.DYNAMIC}, {Variant.EXPRESSION_STRAIGHT_UP, OptimizerFactory.SAFE_REFLECTIVE}, {Variant.EXPRESSION_STRAIGHT_UP, OptimizerFactory.DYNAMIC});
    }

    @Test
    public void collectionAccessPayloadChangedMULE7506() throws Exception {
        PrivilegedEvent event = ((PrivilegedEvent.Builder)this.getEventBuilder()).message(Message.of((Object)new String[]{"1", "2"})).build();
        Assert.assertEquals((Object)"1", (Object)this.mvel.evaluateUntyped("payload[0]", event, PrivilegedEvent.builder((CoreEvent)event), this.flowConstruct.getLocation(), null));
        event = PrivilegedEvent.builder((CoreEvent)event).message((Message)InternalMessage.builder((Message)event.getMessage()).value(Collections.singletonList("1")).build()).build();
        Assert.assertEquals((Object)"1", (Object)this.mvel.evaluateUntyped("payload[0]", event, PrivilegedEvent.builder((CoreEvent)event), this.flowConstruct.getLocation(), null));
    }

    private static class HelloWorldFunction
    extends Function {
        public HelloWorldFunction(ParserContext parserContext) {
            super("hello", new char[0], 0, 0, 0, 0, 0, parserContext);
        }

        public Object call(Object ctx, Object thisValue, VariableResolverFactory factory, Object[] parms) {
            return "Hello World!";
        }
    }

    public static enum Variant {
        EXPRESSION_WITH_DELIMITER,
        EXPRESSION_STRAIGHT_UP;

    }

    static class DummyExpressionLanguageExtension
    implements ExpressionLanguageExtension {
        DummyExpressionLanguageExtension() {
        }

        public void configureContext(ExpressionLanguageContext context) {
            for (int i = 0; i < 20; ++i) {
                context.declareFunction("dummy-function-" + i, (ExpressionLanguageFunction)new RegexExpressionLanguageFuntion());
            }
        }
    }
}

