/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

public class MVELMapHandlingTestCase
extends AbstractMuleContextTestCase {
    private static final String KEY = "Name";
    private static final String VALUE = "MG";
    private ExpressionManager el;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.el = muleContext.getExpressionManager();
    }

    @Test
    public void keyWithNonNullValue() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put(KEY, VALUE);
        this.assertMapKey(payload, KEY, (Object)VALUE);
    }

    @Test
    public void keyWithNullValue() throws Exception {
        HashMap payload = new HashMap();
        this.assertMapKey(payload, KEY, null);
    }

    @Test
    public void keyWithNullableValue() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put(KEY, VALUE);
        CoreEvent event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(payload)).build();
        this.assertMapKey(event, KEY, (Object)VALUE);
        payload.remove(KEY);
        this.assertMapKey(event, KEY, (Object)null);
    }

    @Test
    public void nullKeyWhichGetsValueLater() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        CoreEvent event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of(payload)).build();
        this.assertMapKey(event, KEY, (Object)null);
        payload.put(KEY, VALUE);
        this.assertMapKey(event, KEY, (Object)VALUE);
    }

    private void assertMapKey(Object payload, String key, Object expectedValue) throws Exception {
        this.assertMapKey(MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)payload)).build(), key, expectedValue);
    }

    private void assertMapKey(CoreEvent event, String key, Object expectedValue) throws Exception {
        this.runExpressionAndExpect(String.format("#[mel:payload.%s]", key), expectedValue, event);
        this.runExpressionAndExpect(String.format("#[mel:payload['%s']]", key), expectedValue, event);
        this.runExpressionAndExpect(String.format("#[mel:payload.'%s']", key), expectedValue, event);
    }

    private void runExpressionAndExpect(String expression, Object expectedValue, CoreEvent event) throws Exception {
        Object result = this.el.evaluate(expression, event, TEST_CONNECTOR_LOCATION).getValue();
        Assert.assertThat((String)String.format("Expression %s returned unexpected value", expression), (Object)result, (Matcher)CoreMatchers.equalTo((Object)expectedValue));
    }
}

