/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel.datatype;

import java.io.Serializable;
import java.util.ArrayList;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.el.mvel.datatype.EnricherDataTypePropagator;
import org.mule.runtime.core.internal.el.mvel.datatype.MvelEnricherDataTypePropagator;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MvelEnricherDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    public static final String MEL_EXPRESSION = "foo = bar";
    private final TypedValue typedValue = new TypedValue((Object)"Test Message", DataType.STRING);
    private final EnricherDataTypePropagator propagator1 = (EnricherDataTypePropagator)Mockito.mock(EnricherDataTypePropagator.class);
    private final EnricherDataTypePropagator propagator2 = (EnricherDataTypePropagator)Mockito.mock(EnricherDataTypePropagator.class);

    @Test
    public void invokesDataTypeAllPropagators() throws Exception {
        CompiledExpression compiledExpression = this.compileMelExpression();
        ArrayList<EnricherDataTypePropagator> propagators = new ArrayList<EnricherDataTypePropagator>();
        propagators.add(this.propagator1);
        propagators.add(this.propagator2);
        MvelEnricherDataTypePropagator dataTypePropagator = new MvelEnricherDataTypePropagator(propagators);
        PrivilegedEvent.Builder builder = PrivilegedEvent.builder((CoreEvent)this.testEvent());
        dataTypePropagator.propagate(this.typedValue, (PrivilegedEvent)this.testEvent(), builder, (Serializable)compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator1)).propagate((PrivilegedEvent)this.testEvent(), builder, this.typedValue, compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator2)).propagate((PrivilegedEvent)this.testEvent(), builder, this.typedValue, compiledExpression);
    }

    @Test
    public void stopsCheckingDataTypePropagatorsAfterSuccessfulPropagation() throws Exception {
        CompiledExpression compiledExpression = this.compileMelExpression();
        ArrayList<EnricherDataTypePropagator> propagators = new ArrayList<EnricherDataTypePropagator>();
        propagators.add(this.propagator1);
        PrivilegedEvent.Builder builder = PrivilegedEvent.builder((CoreEvent)this.testEvent());
        Mockito.when((Object)this.propagator1.propagate((PrivilegedEvent)this.testEvent(), builder, this.typedValue, compiledExpression)).thenReturn((Object)true);
        propagators.add(this.propagator2);
        MvelEnricherDataTypePropagator dataTypePropagator = new MvelEnricherDataTypePropagator(propagators);
        dataTypePropagator.propagate(this.typedValue, (PrivilegedEvent)this.testEvent(), builder, (Serializable)compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator1)).propagate((PrivilegedEvent)this.testEvent(), builder, this.typedValue, compiledExpression);
        ((EnricherDataTypePropagator)Mockito.verify((Object)this.propagator2, (VerificationMode)Mockito.never())).propagate((PrivilegedEvent)this.testEvent(), builder, this.typedValue, compiledExpression);
    }

    private CompiledExpression compileMelExpression() {
        MVELExpressionLanguage expressionLanguage = new MVELExpressionLanguage(muleContext);
        return (CompiledExpression)MVEL.compileExpression((String)MEL_EXPRESSION, (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
    }
}

