/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel.function;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.el.ExpressionExecutor;
import org.mule.runtime.core.internal.el.context.MessageContext;
import org.mule.runtime.core.internal.el.mvel.ExpressionLanguageContext;
import org.mule.runtime.core.internal.el.mvel.ExpressionLanguageFunction;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionExecutor;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguageContext;
import org.mule.runtime.core.internal.el.mvel.function.WildcardExpressionLanguageFuntion;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class WildcardExpressionLanguageFunctionTestCase
extends AbstractMuleTestCase {
    protected ExpressionExecutor<MVELExpressionLanguageContext> expressionExecutor;
    protected MVELExpressionLanguageContext context;
    protected WildcardExpressionLanguageFuntion wildcardFunction;
    protected MuleContext muleContext;
    private CoreEvent event;
    private CoreEvent.Builder eventBuilder;
    private InternalMessage message;

    @Before
    public void setup() throws InitialisationException {
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        this.expressionExecutor = new MVELExpressionExecutor(parserConfiguration);
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        this.context = new MVELExpressionLanguageContext(parserConfiguration, this.muleContext);
        this.wildcardFunction = new WildcardExpressionLanguageFuntion();
        this.context.declareFunction("wildcard", (ExpressionLanguageFunction)this.wildcardFunction);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatches() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'*ASDF*QWER*'"}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesMVEL() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('*ASDF*QWER*')", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatches() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"TEST*TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('TEST*TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgument() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'*ASDF*QWER*'", "TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentMVEL() throws Exception {
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('*ASDF*QWER*', 'TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgument() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"TEST*TEST", "TESTfooTEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('TEST*TEST', 'TESTfooTEST')", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityIsTrue() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'tes*'", "TEST", true}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityMVELIsTrue() throws Exception {
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('tes?', 'TEST', true)", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityIsFalse() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'*ASDF*QWER*'", "TEST", false}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityMVELIsFalse() throws Exception {
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('*ASDF*QWER*', 'TEST', false)", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityIsTrue() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"test*TEST", "testfooTEST", true}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityMVELIsTrue() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('test*TEST', 'testfooTEST', true)", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityIsFalse() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"TEST*test", "testfooTEST", false}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityMVELIsFalse() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('TEST???test', 'testfooTEST', false)", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullPattern() throws Exception {
        this.wildcardFunction.call(new Object[]{null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullPatternMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard(null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringPattern() throws Exception {
        this.wildcardFunction.call(new Object[]{new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringWildcardPatternMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard(new java.util.Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullText() throws Exception {
        this.wildcardFunction.call(new Object[]{"TEST*TEST", null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullTextMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard('TEST*TEST',null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringText() throws Exception {
        this.wildcardFunction.call(new Object[]{"TEST*TEST", new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringTextMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard('TEST*TEST',new Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBlankStringText() throws Exception {
        this.wildcardFunction.call(new Object[]{"", "testfooTEST"}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidBlankStringTextMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard('', 'testfooTEST')", (ExpressionLanguageContext)this.context);
    }

    protected void addMessageToContextWithPayload(String payload) throws MuleException {
        this.message = (InternalMessage)Mockito.mock(InternalMessage.class);
        this.event = this.getEventBuilder().message((Message)this.message).build();
        this.eventBuilder = CoreEvent.builder((CoreEvent)this.event);
        InternalMessage transformedMessage = (InternalMessage)Mockito.mock(InternalMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)transformedMessage.getPayload()).thenReturn((Object)new TypedValue((Object)payload, DataType.STRING));
        TransformationService transformationService = (TransformationService)Mockito.mock(TransformationService.class);
        Mockito.when((Object)this.muleContext.getTransformationService()).thenReturn((Object)transformationService);
        Mockito.when((Object)transformationService.transform((Message)Matchers.any(InternalMessage.class), (DataType)Matchers.any(DataType.class))).thenReturn((Object)transformedMessage);
        this.context.addFinalVariable("message", (Object)new MessageContext(this.event, this.eventBuilder, this.muleContext));
    }
}

