/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@Feature(value="EventContext")
@Story(value="Response and completion publishers")
@RunWith(value=Parameterized.class)
public class DefaultEventContextTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Supplier<DefaultEventContext> context;
    private Function<CompletableFuture<Void>, BaseEventContext> contextWithCompletion;
    private Function<ComponentLocation, BaseEventContext> contextWithComponentLocation;
    private BaseEventContext parent;
    private BaseEventContext child;
    private AtomicReference<CoreEvent> parentResultValue = new AtomicReference();
    private AtomicReference<Throwable> parentErrorValue = new AtomicReference();
    private AtomicBoolean parentCompletion = new AtomicBoolean();
    private AtomicBoolean parentTerminated = new AtomicBoolean();
    private AtomicReference<CoreEvent> childResultValue = new AtomicReference();
    private AtomicReference<Throwable> childErrorValue = new AtomicReference();
    private AtomicBoolean childCompletion = new AtomicBoolean();

    public DefaultEventContextTestCase(Supplier<DefaultEventContext> context, Function<CompletableFuture<Void>, BaseEventContext> contextWithCompletion, Function<ComponentLocation, BaseEventContext> contextWithComponentLocation) {
        this.context = context;
        this.contextWithCompletion = contextWithCompletion;
        this.contextWithComponentLocation = contextWithComponentLocation;
    }

    @Before
    public void setup() {
        this.parent = (BaseEventContext)this.context.get();
        this.setupParentListeners(this.parent);
    }

    private BaseEventContext addChild(BaseEventContext parent) {
        this.child = DefaultEventContext.child((BaseEventContext)parent, Optional.empty());
        this.setupChildListeners(this.child);
        return this.child;
    }

    private void setupParentListeners(BaseEventContext parent) {
        parent.onResponse((event, throwable) -> {
            this.parentResultValue.set((CoreEvent)event);
            this.parentErrorValue.set((Throwable)throwable);
        });
        parent.onComplete((response, throwable) -> this.parentCompletion.set(true));
        parent.onTerminated((response, throwable) -> this.parentTerminated.set(true));
    }

    private void setupChildListeners(BaseEventContext child) {
        child.onResponse((event, throwable) -> {
            this.childResultValue.set((CoreEvent)event);
            this.childErrorValue.set((Throwable)throwable);
        });
        child.onTerminated((response, throwable) -> this.childCompletion.set(true));
    }

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({() -> EventContextFactory.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION), externalCompletion -> EventContextFactory.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)TEST_CONNECTOR_LOCATION, null, Optional.of(externalCompletion)), location -> EventContextFactory.create((FlowConstruct)MuleTestUtils.getTestFlow((MuleContext)muleContext), (ComponentLocation)location)}, {() -> EventContextFactory.create((String)"id", (String)DefaultEventContextTestCase.class.getName(), (ComponentLocation)TEST_CONNECTOR_LOCATION, (FlowExceptionHandler)NullExceptionHandler.getInstance()), externalCompletion -> EventContextFactory.create((String)"id", (String)DefaultEventContextTestCase.class.getName(), (ComponentLocation)TEST_CONNECTOR_LOCATION, null, Optional.of(externalCompletion), (FlowExceptionHandler)NullExceptionHandler.getInstance()), location -> EventContextFactory.create((String)"id", (String)DefaultEventContextTestCase.class.getName(), (ComponentLocation)location, (FlowExceptionHandler)NullExceptionHandler.getInstance())});
    }

    @Test
    @Description(value="EventContext response publisher completes with value of result. Also given response publisher completed and there there are no child contexts the completion publisher also completes.")
    public void successWithResult() throws Exception {
        CoreEvent event = this.testEvent();
        this.parent.success(event);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="EventContext response publisher completes with null result. Also given response publisher completed and there there are no child contexts the completion publisher also completes.")
    public void successNoResult() throws Exception {
        this.parent.success();
        this.assertParent((Matcher<Object>)CoreMatchers.nullValue(), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="EventContext response publisher completes with error. Also given response publisher completed and there there are no child contexts the completion publisher also completes.")
    public void error() throws Exception {
        Exception exception = new Exception();
        this.parent.error((Throwable)exception);
        this.assertParent((Matcher<Object>)CoreMatchers.nullValue(), (Matcher<Object>)CoreMatchers.is((Object)exception), true, true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete.")
    public void childSuccessWithResult() throws Exception {
        this.child = this.addChild(this.parent);
        CoreEvent event = this.testEvent();
        this.child.success(event);
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
        this.parent.success(event);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete, even when child context completes after parent context response.")
    public void childDelayedSuccessWithResult() throws Exception {
        this.child = this.addChild(this.parent);
        CoreEvent event = this.testEvent();
        this.parent.success(event);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
        this.child.success(event);
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with no value and all child contexts are complete.")
    public void childSuccessWithNoResult() throws Exception {
        this.addChild(this.parent);
        this.child.success();
        this.parent.success();
        this.assertChild((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with no value and all child contexts are complete, even when child context completes after parent context response.")
    public void childDelayedSuccessWithNoResult() throws Exception {
        this.child = this.addChild(this.parent);
        this.parent.success();
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
        this.child.success();
        this.assertChild((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with error and all child contexts are complete.")
    public void childError() throws Exception {
        this.child = this.addChild(this.parent);
        RuntimeException exception = new RuntimeException();
        this.child.error((Throwable)exception);
        this.parent.error((Throwable)exception);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Object)exception), true, true);
        this.assertChild((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Object)exception), true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with error and all child contexts are complete, even when child context completes after parent context response.")
    public void childDelayedError() throws Exception {
        this.child = this.addChild(this.parent);
        RuntimeException exception = new RuntimeException();
        this.parent.error((Throwable)exception);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Object)exception), false, false);
        this.child.error((Throwable)exception);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Object)exception), true, true);
        this.assertChild((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Object)exception), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete, even when child is run async with a delay.")
    public void asyncChild() throws Exception {
        this.child = this.addChild(this.parent);
        CoreEvent event = this.testEvent();
        Scheduler testScheduler = muleContext.getSchedulerService().ioScheduler();
        Latch latch1 = new Latch();
        try {
            testScheduler.submit(() -> {
                this.child.success(event);
                latch1.countDown();
                return null;
            });
            this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
            this.parent.success(event);
            latch1.await();
            this.assertChild((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
            this.assertParent((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
        }
        finally {
            testScheduler.stop();
        }
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child and grandchild contexts are complete.")
    public void multipleLevelsGrandchildFirst() throws Exception {
        this.child = this.addChild(this.parent);
        BaseEventContext grandchild = DefaultEventContext.child((BaseEventContext)this.child, Optional.empty());
        grandchild.success(this.testEvent());
        this.assertChild((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
        this.child.success(this.testEvent());
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
        this.parent.success(this.testEvent());
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child and grandchild contexts are complete, even if parent response is available earlier.")
    public void multipleLevelsParentFirst() throws Exception {
        this.child = this.addChild(this.parent);
        BaseEventContext grandchild = DefaultEventContext.child((BaseEventContext)this.child, Optional.empty());
        this.parent.success(this.testEvent());
        this.assertChild((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
        this.child.success(this.testEvent());
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), false, false);
        grandchild.success();
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete, even if one branch of the tree completes.")
    public void multipleBranches() throws Exception {
        BaseEventContext parent = (BaseEventContext)this.context.get();
        BaseEventContext child1 = DefaultEventContext.child((BaseEventContext)parent, Optional.empty());
        BaseEventContext child2 = DefaultEventContext.child((BaseEventContext)parent, Optional.empty());
        BaseEventContext grandchild1 = DefaultEventContext.child((BaseEventContext)child1, Optional.empty());
        BaseEventContext grandchild2 = DefaultEventContext.child((BaseEventContext)child1, Optional.empty());
        BaseEventContext grandchild3 = DefaultEventContext.child((BaseEventContext)child2, Optional.empty());
        BaseEventContext grandchild4 = DefaultEventContext.child((BaseEventContext)child2, Optional.empty());
        grandchild1.success();
        grandchild2.success();
        Assert.assertThat((Object)grandchild1.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)grandchild2.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)child1.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)parent.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        child1.success();
        Assert.assertThat((Object)child1.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parent.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        grandchild3.success();
        grandchild4.success();
        child2.success();
        Assert.assertThat((Object)grandchild3.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)grandchild4.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)child2.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)parent.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        parent.success();
        Assert.assertThat((Object)parent.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="EventContext response publisher completes with value of result but the completion publisher only completes once the external publisher completes.")
    public void externalCompletionSuccess() throws Exception {
        CompletableFuture<Object> externalCompletion = new CompletableFuture<Object>();
        this.parent = this.contextWithCompletion.apply(externalCompletion);
        this.setupParentListeners(this.parent);
        CoreEvent event = this.testEvent();
        Assert.assertThat((Object)this.parent.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        this.parent.success(event);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, false);
        externalCompletion.complete(null);
        Assert.assertThat((Object)this.parent.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="EventContext response publisher completes with error but the completion publisher only completes once the external publisher completes.")
    public void externalCompletionError() throws Exception {
        CompletableFuture<Object> externalCompletion = new CompletableFuture<Object>();
        this.parent = this.contextWithCompletion.apply(externalCompletion);
        this.setupParentListeners(this.parent);
        RuntimeException exception = new RuntimeException();
        Assert.assertThat((Object)this.parent.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        this.parent.error((Throwable)exception);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), (Matcher<Object>)CoreMatchers.is((Object)exception), true, false);
        externalCompletion.complete(null);
        Assert.assertThat((Object)this.parent.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Parent EventContext only completes once response publisher completes with a value and all child contexts are complete and external completion completes.")
    public void externalCompletionWithChild() throws Exception {
        CompletableFuture<Object> externalCompletion = new CompletableFuture<Object>();
        this.parent = this.contextWithCompletion.apply(externalCompletion);
        this.setupParentListeners(this.parent);
        this.child = this.addChild(this.parent);
        CoreEvent event = this.testEvent();
        this.child.success(event);
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
        Assert.assertThat((Object)this.parent.isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        this.parent.success(event);
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)event), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, false);
        externalCompletion.complete(null);
        Assert.assertThat((Object)this.parent.isTerminated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="When a child event context is de-serialized it is decoupled from parent context but response and completion publisher still complete when a response event is available.")
    public void deserializedChild() throws Exception {
        this.child = this.addChild(this.parent);
        byte[] bytes = muleContext.getObjectSerializer().getExternalProtocol().serialize((Object)this.child);
        this.child = (BaseEventContext)muleContext.getObjectSerializer().getExternalProtocol().deserialize(bytes);
        this.setupChildListeners(this.child);
        this.child.success(this.testEvent());
        this.assertChild((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true);
    }

    @Test
    @Description(value="When a parent event context is de-serialized the parent context no longer waits for completion of childcontext.")
    public void deserializedParent() throws Exception {
        this.child = this.addChild(this.parent);
        byte[] bytes = muleContext.getObjectSerializer().getExternalProtocol().serialize((Object)this.parent);
        this.parent = (BaseEventContext)muleContext.getObjectSerializer().getExternalProtocol().deserialize(bytes);
        this.setupParentListeners(this.parent);
        this.parent.success(this.testEvent());
        this.assertParent((Matcher<Object>)CoreMatchers.is((Object)this.testEvent()), (Matcher<Object>)CoreMatchers.is((Matcher)CoreMatchers.nullValue()), true, true);
    }

    @Test
    @Description(value="Verify that a location produces connector and source data.")
    public void componentData() throws Exception {
        TypedComponentIdentifier typedComponentIdentifier = TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.SOURCE).identifier(ComponentIdentifier.buildFromStringRepresentation((String)"http:listener")).build();
        ComponentLocation location = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)location.getComponentIdentifier()).thenReturn((Object)typedComponentIdentifier);
        Mockito.when((Object)location.getParts()).thenReturn(Arrays.asList(new DefaultComponentLocation.DefaultLocationPart("flow", Optional.empty(), Optional.empty(), Optional.empty())));
        BaseEventContext context = this.contextWithComponentLocation.apply(location);
        Assert.assertThat((Object)context.getOriginatingLocation().getComponentIdentifier().getIdentifier().getNamespace(), (Matcher)CoreMatchers.is((Object)"http"));
        Assert.assertThat((Object)context.getOriginatingLocation().getComponentIdentifier().getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"listener"));
    }

    @Test
    @Description(value="Verify that a single component location produces connector and source data.")
    public void componentDataFromSingleComponent() throws Exception {
        BaseEventContext context = (BaseEventContext)this.context.get();
        Assert.assertThat((Object)context.getOriginatingLocation().getComponentIdentifier().getIdentifier().getNamespace(), (Matcher)CoreMatchers.is((Object)"mule"));
        Assert.assertThat((Object)context.getOriginatingLocation().getComponentIdentifier().getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"test"));
    }

    private void assertParent(Matcher<Object> eventMatcher, Matcher<Object> errorMatcher, boolean complete, boolean terminated) {
        Assert.assertThat((Object)this.parentResultValue.get(), eventMatcher);
        Assert.assertThat((Object)this.parentErrorValue.get(), errorMatcher);
        Assert.assertThat((Object)this.parentCompletion.get(), (Matcher)CoreMatchers.is((Object)complete));
        Assert.assertThat((Object)this.parentTerminated.get(), (Matcher)CoreMatchers.is((Object)terminated));
    }

    private void assertChild(Matcher<Object> eventMatcher, Matcher<Object> errorMatcher, boolean complete) {
        Assert.assertThat((Object)this.childResultValue.get(), eventMatcher);
        Assert.assertThat((Object)this.childErrorValue.get(), errorMatcher);
        Assert.assertThat((Object)this.childCompletion.get(), (Matcher)CoreMatchers.is((Object)complete));
    }
}

