/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.internal.exception.DefaultErrorTypeRepository;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Error Handling")
@Story(value="Error Types")
public class DefaultErrorTypeRepositoryTestCase
extends AbstractMuleTestCase {
    private ErrorTypeRepository errorTypeRepository = new DefaultErrorTypeRepository();
    private ComponentIdentifier INTERNAL_ERROR = ComponentIdentifier.builder().namespace("NS").name("NAME").build();
    private ComponentIdentifier EXPOSED_ERROR = ComponentIdentifier.builder().namespace("NS2").name("OTHER_NAME").build();
    private ComponentIdentifier OTHER_INTERNAL_ERROR = ComponentIdentifier.builder().namespace("NS2").name("NAME").build();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY, this.errorTypeRepository.getAnyErrorType());
        this.errorTypeRepository.addErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING, this.errorTypeRepository.getAnyErrorType());
        this.errorTypeRepository.addErrorType(this.EXPOSED_ERROR, this.errorTypeRepository.getAnyErrorType());
        this.errorTypeRepository.addInternalErrorType(this.INTERNAL_ERROR, this.errorTypeRepository.getCriticalErrorType());
        this.errorTypeRepository.addInternalErrorType(this.OTHER_INTERNAL_ERROR, this.errorTypeRepository.getCriticalErrorType());
    }

    @Test
    public void lookupsAvailableErrorType() {
        Optional errorType = this.errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY);
        Assert.assertThat((Object)errorType.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ErrorType)errorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)Errors.ComponentIdentifiers.Handleable.CONNECTIVITY.getName()));
        Assert.assertThat((Object)((ErrorType)errorType.get()).getParentErrorType().getIdentifier(), (Matcher)Matchers.is((Object)"ANY"));
    }

    @Test
    public void doesNotLookupUnavailableErrorType() {
        Assert.assertThat((Object)this.errorTypeRepository.lookupErrorType(this.INTERNAL_ERROR).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void getsAvailableErrorTypes() {
        Optional myErrorType = this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY);
        Assert.assertThat((Object)myErrorType.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)"CONNECTIVITY"));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getParentErrorType().getIdentifier(), (Matcher)Matchers.is((Object)"ANY"));
    }

    @Test
    public void getsUnavailableErrorTypes() {
        Optional myErrorType = this.errorTypeRepository.getErrorType(this.INTERNAL_ERROR);
        Assert.assertThat((Object)myErrorType.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getIdentifier(), (Matcher)Matchers.is((Object)"NAME"));
        Assert.assertThat((Object)((ErrorType)myErrorType.get()).getParentErrorType().getIdentifier(), (Matcher)Matchers.is((Object)"CRITICAL"));
    }

    @Test
    public void doesNotAddInternalTypeAsRegularOne() {
        this.expectedException.expectMessage(Matchers.is((Object)"An error type with identifier 'NS:NAME' already exists"));
        this.errorTypeRepository.addErrorType(this.INTERNAL_ERROR, this.errorTypeRepository.getAnyErrorType());
    }

    @Test
    public void doesNotAddRegularTypeAsInternalOne() {
        this.expectedException.expectMessage(Matchers.is((Object)"An error type with identifier 'MULE:CONNECTIVITY' already exists"));
        this.errorTypeRepository.addInternalErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY, this.errorTypeRepository.getCriticalErrorType());
    }

    @Test
    public void returnsUnrepeatedExposedAndInternalNamespaces() {
        Collection errorNamespaces = this.errorTypeRepository.getErrorNamespaces();
        Assert.assertThat((Object)errorNamespaces, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)errorNamespaces, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"MULE", "NS", "NS2"}));
    }
}

