/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.DefaultSystemExceptionStrategy;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DefaultExceptionStrategyTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testExceptions() throws Exception {
        InstrumentedExceptionStrategy strategy = new InstrumentedExceptionStrategy(muleContext);
        strategy.setMuleContext(muleContext);
        strategy.setNotificationFirer((NotificationDispatcher)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationDispatcher.class));
        strategy.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        strategy.handleException(new IllegalArgumentException("boom"));
        Assert.assertEquals((long)1L, (long)strategy.getCount());
    }

    @Test
    public void testExceptionNotifications() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger notificationCount = new AtomicInteger(0);
        ((NotificationListenerRegistry)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationListenerRegistry.class)).registerListener((NotificationListener)((ExceptionNotificationListener)notification -> {
            if (new IntegerAction(1101).equals((Object)notification.getAction())) {
                Assert.assertEquals((Object)"exception", (Object)notification.getActionName());
                Assert.assertEquals((String)"Wrong info type", (Object)"error", (Object)notification.getType());
                notificationCount.incrementAndGet();
                latch.countDown();
            }
        }));
        InstrumentedExceptionStrategy strategy = new InstrumentedExceptionStrategy(muleContext);
        strategy.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        strategy.setMuleContext(muleContext);
        strategy.setNotificationFirer((NotificationDispatcher)((MuleContextWithRegistries)muleContext).getRegistry().lookupObject(NotificationDispatcher.class));
        strategy.handleException(new IllegalArgumentException("boom"));
        latch.await(2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)notificationCount.get());
    }

    private static class InstrumentedExceptionStrategy
    extends DefaultSystemExceptionStrategy {
        private volatile int count = 0;

        public InstrumentedExceptionStrategy(MuleContext muleContext) {
        }

        public void handleException(Exception exception) {
            ++this.count;
            super.handleException(exception);
        }

        public int getCount() {
            return this.count;
        }
    }
}

