/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.DefaultErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.ErrorHandlerFactory;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.exception.OnCriticalErrorHandler;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import reactor.core.publisher.Mono;

@SmallTest
@Feature(value="Error Handling")
@Story(value="Error Handler")
@RunWith(value=MockitoJUnitRunner.class)
public class ErrorHandlerTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private MessagingExceptionHandlerAcceptor mockTestExceptionStrategy1;
    @Mock
    private MessagingExceptionHandlerAcceptor mockTestExceptionStrategy2;
    private DefaultMessagingExceptionHandlerAcceptor defaultMessagingExceptionHandler = (DefaultMessagingExceptionHandlerAcceptor)Mockito.spy((Object)new DefaultMessagingExceptionHandlerAcceptor());
    private CoreEvent event;
    private MuleContextWithRegistries mockMuleContext = MuleContextUtils.mockContextWithServices();
    @Mock
    private ErrorType mockErrorType;
    private MessagingException mockException;

    @Before
    public void before() throws MuleException {
        Error mockError = (Error)Mockito.mock(Error.class);
        Mockito.when((Object)mockError.getErrorType()).thenReturn((Object)this.mockErrorType);
        this.event = this.getEventBuilder().message(Message.of((Object)"")).error(mockError).build();
        this.mockException = new MessagingException(this.event, (Throwable)new Exception());
        CoreEvent handledEvent = this.testEvent();
        Mockito.when((Object)this.mockTestExceptionStrategy1.accept((CoreEvent)org.mockito.Matchers.any(CoreEvent.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockTestExceptionStrategy1.apply((Exception)org.mockito.Matchers.any(MessagingException.class))).thenReturn((Object)Mono.just((Object)handledEvent));
        Mockito.when((Object)this.mockTestExceptionStrategy2.accept((CoreEvent)org.mockito.Matchers.any(CoreEvent.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockTestExceptionStrategy2.apply((Exception)org.mockito.Matchers.any(MessagingException.class))).thenReturn((Object)Mono.just((Object)handledEvent));
    }

    @Test
    public void secondMatches() throws Exception {
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler(Optional.empty())).thenReturn((Object)this.defaultMessagingExceptionHandler);
        errorHandler.setMuleContext((MuleContext)this.mockMuleContext);
        errorHandler.setRootContainerName("root");
        errorHandler.initialise();
        Mockito.when((Object)this.mockTestExceptionStrategy1.accept((CoreEvent)org.mockito.Matchers.any(CoreEvent.class))).thenReturn((Object)false);
        errorHandler.handleException((Exception)this.mockException, this.event);
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy1, (VerificationMode)VerificationModeFactory.times((int)0))).apply((Exception)org.mockito.Matchers.any(MessagingException.class));
        ((DefaultMessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.defaultMessagingExceptionHandler, (VerificationMode)VerificationModeFactory.times((int)0))).apply((Exception)org.mockito.Matchers.any(MessagingException.class));
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy2, (VerificationMode)VerificationModeFactory.times((int)1))).handleException((Exception)org.mockito.Matchers.eq((Object)this.mockException), (CoreEvent)org.mockito.Matchers.any(CoreEvent.class));
    }

    @Test
    public void firstAcceptsAllMatches() throws Exception {
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1, this.mockTestExceptionStrategy2)));
        errorHandler.setMuleContext((MuleContext)this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler(Optional.empty())).thenReturn((Object)this.defaultMessagingExceptionHandler);
        Mockito.when((Object)this.mockTestExceptionStrategy1.acceptsAll()).thenReturn((Object)true);
        Mockito.when((Object)this.mockTestExceptionStrategy2.acceptsAll()).thenReturn((Object)false);
        errorHandler.setRootContainerName("root");
        this.expectedException.expectMessage(Matchers.containsString((String)"Only last exception strategy inside <error-handler> can accept any message."));
        errorHandler.initialise();
    }

    @Test
    public void criticalIsNotHandled() throws Exception {
        Mockito.when((Object)this.mockErrorType.getParentErrorType()).thenReturn((Object)DefaultErrorTypeRepository.CRITICAL_ERROR_TYPE);
        ErrorHandler errorHandler = new ErrorHandler();
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler(Optional.empty())).thenReturn((Object)this.defaultMessagingExceptionHandler);
        errorHandler.setExceptionListeners(new ArrayList<MessagingExceptionHandlerAcceptor>(Arrays.asList(this.mockTestExceptionStrategy1)));
        errorHandler.setMuleContext((MuleContext)this.mockMuleContext);
        errorHandler.setRootContainerName("root");
        errorHandler.initialise();
        errorHandler.handleException((Exception)this.mockException, this.event);
        ((MessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.mockTestExceptionStrategy1, (VerificationMode)VerificationModeFactory.times((int)0))).apply((Exception)org.mockito.Matchers.any(MessagingException.class));
        ((DefaultMessagingExceptionHandlerAcceptor)Mockito.verify((Object)this.defaultMessagingExceptionHandler, (VerificationMode)VerificationModeFactory.times((int)0))).apply((Exception)org.mockito.Matchers.any(MessagingException.class));
    }

    @Test
    public void defaultErrorHandler() throws InitialisationException {
        ErrorHandler defaultHandler = new ErrorHandlerFactory().createDefault((NotificationDispatcher)Mockito.mock(NotificationDispatcher.class));
        Assert.assertThat((Object)defaultHandler.getExceptionListeners(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)defaultHandler.getExceptionListeners(), (Matcher)IsCollectionContaining.hasItem((Matcher)Matchers.instanceOf(OnErrorPropagateHandler.class)));
    }

    @Test
    public void ifUserDefaultIsMissingCatchAllThenGetsInjectedOurDefault() throws Exception {
        ErrorHandler errorHandler = new ErrorHandler();
        LinkedList<MessagingExceptionHandlerAcceptor> handlerList = new LinkedList<MessagingExceptionHandlerAcceptor>();
        handlerList.add(this.mockTestExceptionStrategy1);
        errorHandler.setExceptionListeners(handlerList);
        errorHandler.setMuleContext((MuleContext)this.mockMuleContext);
        errorHandler.setRootContainerName("root");
        errorHandler.setName("myDefault");
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getDefaultErrorHandlerName()).thenReturn((Object)"myDefault");
        Mockito.when((Object)this.mockMuleContext.getDefaultErrorHandler(Optional.of("root"))).thenReturn((Object)errorHandler);
        errorHandler.initialise();
        Assert.assertThat((Object)errorHandler.getExceptionListeners(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat(errorHandler.getExceptionListeners().get(0), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(OnCriticalErrorHandler.class)));
        Assert.assertThat(errorHandler.getExceptionListeners().get(1), (Matcher)Matchers.is((Object)this.mockTestExceptionStrategy1));
        MessagingExceptionHandlerAcceptor injected = (MessagingExceptionHandlerAcceptor)errorHandler.getExceptionListeners().get(2);
        Assert.assertThat((Object)injected, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(OnErrorPropagateHandler.class)));
    }

    class DefaultMessagingExceptionHandlerAcceptor
    implements MessagingExceptionHandlerAcceptor {
        DefaultMessagingExceptionHandlerAcceptor() {
        }

        public boolean accept(CoreEvent event) {
            return true;
        }

        public boolean acceptsAll() {
            return true;
        }

        public CoreEvent handleException(Exception exception, CoreEvent event) {
            if (exception instanceof MessagingException) {
                ((MessagingException)exception).setHandled(true);
            }
            return event;
        }
    }
}

