/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.ExceptionMapper;
import org.mule.runtime.core.internal.exception.DefaultErrorTypeRepository;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Error Handling")
@Story(value="Exception Mappings")
public class ErrorTypeLocatorTestCase
extends AbstractMuleTestCase {
    private final ErrorTypeRepository repository = new DefaultErrorTypeRepository();

    @Test
    public void useDefaultErrorWhenNoMappingFound() {
        ErrorType mockedError = (ErrorType)Mockito.mock(ErrorType.class);
        ErrorType unknown = (ErrorType)this.repository.getErrorType(Errors.ComponentIdentifiers.Handleable.UNKNOWN).get();
        ErrorTypeLocator locator = ErrorTypeLocator.builder((ErrorTypeRepository)this.repository).defaultExceptionMapper(ExceptionMapper.builder().addExceptionMapping(Exception.class, mockedError).build()).defaultError(unknown).build();
        ErrorType expectedError = locator.lookupErrorType(Exception.class);
        Assert.assertThat((Object)expectedError, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)mockedError)));
        ErrorType defaultError = locator.lookupErrorType(Throwable.class);
        Assert.assertThat((Object)defaultError, (Matcher)Is.is((Matcher)CoreMatchers.sameInstance((Object)unknown)));
    }
}

