/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ExceptionListenerTestCase
extends AbstractMuleTestCase {
    @Test
    public void setSingleGoodProcessorEndpoint() throws Exception {
        OnErrorPropagateHandler router = new OnErrorPropagateHandler();
        Processor messageProcessor = (Processor)Mockito.mock(Processor.class);
        router.setMessageProcessors(Collections.singletonList(messageProcessor));
        Assert.assertNotNull((Object)router.getMessageProcessors());
        Assert.assertTrue((boolean)router.getMessageProcessors().contains(messageProcessor));
    }

    @Test
    public void setGoodProcessors() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Mockito.mock(Processor.class));
        list.add(Mockito.mock(Processor.class));
        OnErrorPropagateHandler router = new OnErrorPropagateHandler();
        Assert.assertNotNull((Object)router.getMessageProcessors());
        Assert.assertEquals((long)0L, (long)router.getMessageProcessors().size());
        router.setMessageProcessors(Collections.singletonList(Mockito.mock(Processor.class)));
        Assert.assertEquals((long)1L, (long)router.getMessageProcessors().size());
        router.setMessageProcessors(list);
        Assert.assertNotNull((Object)router.getMessageProcessors());
        Assert.assertEquals((long)2L, (long)router.getMessageProcessors().size());
    }
}

