/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.internal.exception.AbstractErrorHandlerTestCase;
import org.mule.runtime.core.internal.exception.DefaultErrorTypeRepository;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.exception.OnCriticalErrorHandler;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="Error Handling")
public class OnCriticalErrorHandlerTestCase
extends AbstractErrorHandlerTestCase {
    private OnCriticalErrorHandler handler = (OnCriticalErrorHandler)Mockito.spy((Object)new OnCriticalErrorHandler((ErrorTypeMatcher)Mockito.mock(ErrorTypeMatcher.class)));
    private Error error;

    public OnCriticalErrorHandlerTestCase(SystemProperty verbose) {
        super(verbose);
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.error = (Error)Mockito.mock(Error.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.muleEvent = InternalEvent.builder((CoreEvent)this.muleEvent).error(this.error).build();
    }

    @Test
    public void logsException() {
        Mockito.when((Object)this.mockException.getDetailedMessage()).thenReturn((Object)"Log");
        Mockito.when((Object)this.mockException.getEvent()).thenReturn((Object)this.muleEvent);
        this.handler.apply((Exception)this.mockException);
        this.handler.handleException((Exception)this.mockException, this.muleEvent);
        ((OnCriticalErrorHandler)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.times((int)2))).logException((Throwable)org.mockito.Matchers.any(MessagingException.class));
    }

    @Test
    public void acceptsCritical() {
        Mockito.when((Object)this.error.getErrorType()).thenReturn((Object)DefaultErrorTypeRepository.CRITICAL_ERROR_TYPE);
        Assert.assertThat((Object)this.handler.accept(this.muleEvent), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void acceptsCriticalChild() {
        ErrorType errorType = (ErrorType)Mockito.mock(ErrorType.class);
        Mockito.when((Object)this.error.getErrorType()).thenReturn((Object)errorType);
        Mockito.when((Object)errorType.getParentErrorType()).thenReturn((Object)DefaultErrorTypeRepository.CRITICAL_ERROR_TYPE);
        Assert.assertThat((Object)this.handler.accept(this.muleEvent), (Matcher)Matchers.is((Object)true));
    }
}

