/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.AbstractErrorHandlerTestCase;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.exception.OnErrorContinueHandler;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.tck.util.MuleContextUtils;

@Feature(value="Error Handling")
@Story(value="On Error Continue")
public class OnErrorContinueHandlerTestCase
extends AbstractErrorHandlerTestCase {
    protected MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    private static final String DEFAULT_LOG_MESSAGE = "LOG";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private TestTransaction mockTransaction = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext));
    private TestTransaction mockXaTransaction = (TestTransaction)Mockito.spy((Object)new TestTransaction(this.muleContext, true));
    private OnErrorContinueHandler onErrorContinueHandler;

    public OnErrorContinueHandlerTestCase(SystemProperty verbose) {
        super(verbose);
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        Transaction currentTransaction = TransactionCoordination.getInstance().getTransaction();
        if (currentTransaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(currentTransaction);
        }
        this.onErrorContinueHandler = new OnErrorContinueHandler();
        this.onErrorContinueHandler.setAnnotations(OnErrorContinueHandlerTestCase.getFlowComponentLocationAnnotations((String)this.flow.getName()));
        this.onErrorContinueHandler.setMuleContext(this.muleContext);
        this.onErrorContinueHandler.setNotificationFirer((NotificationDispatcher)Mockito.mock(NotificationDispatcher.class));
    }

    @Test
    public void testHandleExceptionWithNoConfig() throws Exception {
        this.configureXaTransactionAndSingleResourceTransaction();
        Mockito.when((Object)this.mockException.handled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockException.getDetailedMessage()).thenReturn((Object)DEFAULT_LOG_MESSAGE);
        Mockito.when((Object)this.mockException.getEvent()).thenReturn((Object)this.muleEvent);
        CoreEvent resultEvent = this.onErrorContinueHandler.handleException((Exception)this.mockException, this.muleEvent);
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)this.muleEvent.getMessage().getPayload().getValue()));
        ((MessagingException)Mockito.verify((Object)this.mockException)).setHandled(true);
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).setRollbackOnly();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).commit();
        ((TestTransaction)Mockito.verify((Object)this.mockTransaction, (VerificationMode)VerificationModeFactory.times((int)0))).rollback();
    }

    @Test
    public void testHandleExceptionWithConfiguredMessageProcessors() throws Exception {
        this.onErrorContinueHandler.setMessageProcessors(Arrays.asList(this.createSetStringMessageProcessor("A"), this.createSetStringMessageProcessor("B")));
        LifecycleUtils.initialiseIfNeeded((Object)this.onErrorContinueHandler, (MuleContext)this.muleContext);
        Mockito.when((Object)this.mockException.handled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockException.getDetailedMessage()).thenReturn((Object)DEFAULT_LOG_MESSAGE);
        Mockito.when((Object)this.mockException.getEvent()).thenReturn((Object)this.muleEvent);
        CoreEvent result = this.onErrorContinueHandler.handleException((Exception)this.mockException, this.muleEvent);
        ((MessagingException)Mockito.verify((Object)this.mockException)).setHandled(true);
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"B"));
        Assert.assertThat((Object)result.getError().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testHandleExceptionWithMessageProcessorsChangingEvent() throws Exception {
        InternalEvent lastEventCreated = InternalEvent.builder((EventContext)this.context).message(Message.of((Object)"")).build();
        this.onErrorContinueHandler.setMessageProcessors(Arrays.asList(this.createChagingEventMessageProcessor((CoreEvent)InternalEvent.builder((EventContext)this.context).message(Message.of((Object)"")).build()), this.createChagingEventMessageProcessor((CoreEvent)lastEventCreated)));
        this.onErrorContinueHandler.setAnnotations(OnErrorContinueHandlerTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)this.onErrorContinueHandler, (MuleContext)this.muleContext);
        Mockito.when((Object)this.mockException.handled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockException.getDetailedMessage()).thenReturn((Object)DEFAULT_LOG_MESSAGE);
        Mockito.when((Object)this.mockException.getEvent()).thenReturn((Object)this.muleEvent);
        CoreEvent exceptionHandlingResult = this.onErrorContinueHandler.handleException((Exception)this.mockException, this.muleEvent);
        ((MessagingException)Mockito.verify((Object)this.mockException)).setHandled(true);
        Assert.assertThat((Object)exceptionHandlingResult.getCorrelationId(), (Matcher)Is.is((Object)lastEventCreated.getCorrelationId()));
    }

    @Test
    public void testMessageToStringNotCalledOnFailure() throws Exception {
        this.muleEvent = CoreEvent.builder((CoreEvent)this.muleEvent).message((Message)Mockito.spy((Object)Message.of((Object)""))).build();
        this.muleEvent = (CoreEvent)Mockito.spy((Object)this.muleEvent);
        Mockito.when((Object)this.mockException.getStackTrace()).thenReturn((Object)new StackTraceElement[0]);
        Mockito.when((Object)this.mockException.getEvent()).thenReturn((Object)this.muleEvent);
        InternalEvent lastEventCreated = InternalEvent.builder((EventContext)this.context).message(Message.of((Object)"")).build();
        this.onErrorContinueHandler.setMessageProcessors(Arrays.asList(this.createFailingEventMessageProcessor((CoreEvent)InternalEvent.builder((EventContext)this.context).message(Message.of((Object)"")).build()), this.createFailingEventMessageProcessor((CoreEvent)lastEventCreated)));
        LifecycleUtils.initialiseIfNeeded((Object)this.onErrorContinueHandler, (MuleContext)this.muleContext);
        Mockito.when((Object)this.muleEvent.getMessage().toString()).thenThrow(new Throwable[]{new RuntimeException("Message.toString() should not be called")});
        this.expectedException.expect(Exception.class);
        this.onErrorContinueHandler.handleException((Exception)this.mockException, this.muleEvent);
    }

    private Processor createChagingEventMessageProcessor(CoreEvent lastEventCreated) {
        return event -> lastEventCreated;
    }

    private Processor createFailingEventMessageProcessor(CoreEvent lastEventCreated) {
        return event -> {
            throw new DefaultMuleException((Throwable)this.mockException);
        };
    }

    private Processor createSetStringMessageProcessor(String appendText) {
        return event -> CoreEvent.builder((CoreEvent)event).message((Message)InternalMessage.builder((Message)event.getMessage()).value((Object)appendText).build()).build();
    }

    private void configureXaTransactionAndSingleResourceTransaction() throws TransactionException {
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockXaTransaction);
        TransactionCoordination.getInstance().suspendCurrentTransaction();
        TransactionCoordination.getInstance().bindTransaction((Transaction)this.mockTransaction);
    }
}

