/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.net.URL;
import java.net.URLClassLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.internal.execution.ClassLoaderInjectorInvocationHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ClassLoaderInjectorInvocationHandlerTestCase
extends AbstractMuleTestCase {
    @Test
    public void delegatesMethodInvocation() throws Exception {
        TestDelegate delegate = (TestDelegate)Mockito.mock(TestDelegate.class);
        ClassLoader classLoader = this.getContextClassLoader();
        TestDelegate proxy = (TestDelegate)ClassLoaderInjectorInvocationHandler.createClassLoaderInjectorInvocationHandler((Object)delegate, (ClassLoader)classLoader);
        proxy.doStuff();
        ((TestDelegate)Mockito.verify((Object)delegate)).doStuff();
    }

    @Test
    public void usesClassLoaderOnMethodDelegation() throws Exception {
        URLClassLoader classLoader = new URLClassLoader(new URL[0], ((Object)((Object)this)).getClass().getClassLoader());
        TestDelegate delegate = (TestDelegate)Mockito.mock(TestDelegate.class);
        ((TestDelegate)Mockito.doAnswer(invocation -> {
            MatcherAssert.assertThat((Object)this.getContextClassLoader(), (Matcher)CoreMatchers.equalTo((Object)classLoader));
            return null;
        }).when((Object)delegate)).doStuff();
        TestDelegate proxy = (TestDelegate)ClassLoaderInjectorInvocationHandler.createClassLoaderInjectorInvocationHandler((Object)delegate, (ClassLoader)classLoader);
        proxy.doStuff();
    }

    @Test
    public void restoresOriginalClassLoaderAfterMethodDelegation() throws Exception {
        ClassLoader originalClassLoader = this.getContextClassLoader();
        TestDelegate delegate = (TestDelegate)Mockito.mock(TestDelegate.class);
        URLClassLoader classLoader = new URLClassLoader(new URL[0], ((Object)((Object)this)).getClass().getClassLoader());
        ClassLoaderInjectorInvocationHandler.createClassLoaderInjectorInvocationHandler((Object)delegate, (ClassLoader)classLoader);
        Assert.assertSame((Object)originalClassLoader, (Object)this.getContextClassLoader());
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static interface TestDelegate {
        public void doStuff();
    }
}

