/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhase;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.ErrorTypeBuilder;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.EitherMatcher;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.junit4.matcher.MessagingExceptionMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

@SmallTest
public class ModuleFlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    private static final ErrorType ERROR_FROM_FLOW = ErrorTypeBuilder.builder().parentErrorType((ErrorType)Mockito.mock(ErrorType.class)).namespace("TEST").identifier("FLOW_FAILED").build();
    private FlowConstruct flow;
    private MessageProcessContext context;
    private ModuleFlowProcessingPhaseTemplate template;
    private PhaseResultNotifier notifier;
    private SourcePolicy sourcePolicy;
    private SourcePolicySuccessResult successResult;
    private SourcePolicyFailureResult failureResult;
    private CoreEvent event;
    private MessagingException messagingException;
    private RuntimeException mockException;
    private ModuleFlowProcessingPhase moduleFlowProcessingPhase;
    private Supplier<Map<String, Object>> failingParameterSupplier = () -> {
        throw this.mockException;
    };
    private Function<CoreEvent, Map<String, Object>> failingParameterFunction = event -> {
        throw this.mockException;
    };
    private PolicyManager policyManager;

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList(false, true);
    }

    @Before
    public void before() throws Exception {
        PrivilegedMuleContext muleContext = (PrivilegedMuleContext)MuleContextUtils.mockMuleContext();
        Mockito.when((Object)muleContext.getErrorTypeRepository()).thenReturn((Object)ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository());
        ErrorTypeLocator errorTypeLocator = (ErrorTypeLocator)Mockito.mock(ErrorTypeLocator.class);
        Mockito.when((Object)errorTypeLocator.lookupErrorType((Throwable)Matchers.any(Throwable.class))).thenReturn((Object)ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("ANY").build());
        Mockito.when((Object)muleContext.getErrorTypeLocator()).thenReturn((Object)errorTypeLocator);
        this.event = (CoreEvent)Mockito.mock(CoreEvent.class);
        this.mockException = (RuntimeException)Mockito.mock(RuntimeException.class);
        this.policyManager = (PolicyManager)Mockito.mock(PolicyManager.class);
        this.sourcePolicy = (SourcePolicy)Mockito.mock(SourcePolicy.class);
        Mockito.when((Object)this.policyManager.createSourcePolicyInstance((Component)Matchers.any(), (CoreEvent)Matchers.any(), (Processor)Matchers.any(), (MessageSourceResponseParametersProcessor)Matchers.any())).thenReturn((Object)this.sourcePolicy);
        this.successResult = (SourcePolicySuccessResult)Mockito.mock(SourcePolicySuccessResult.class);
        Mockito.when((Object)this.successResult.getResult()).then(invocation -> this.event);
        Mockito.when((Object)this.successResult.getResponseParameters()).thenReturn(() -> Collections.emptyMap());
        Mockito.when((Object)this.successResult.createErrorResponseParameters()).thenReturn(event -> Collections.emptyMap());
        this.failureResult = (SourcePolicyFailureResult)Mockito.mock(SourcePolicyFailureResult.class);
        Mockito.when((Object)this.failureResult.getMessagingException()).then(invocation -> this.messagingException);
        Mockito.when((Object)this.failureResult.getErrorResponseParameters()).thenReturn(() -> Collections.emptyMap());
        Mockito.when((Object)this.sourcePolicy.process((CoreEvent)Matchers.any())).thenAnswer(invocation -> {
            this.event = (CoreEvent)invocation.getArgumentAt(0, CoreEvent.class);
            return Mono.just((Object)Either.right((Object)this.successResult));
        });
        this.moduleFlowProcessingPhase = new ModuleFlowProcessingPhase(this.policyManager);
        this.moduleFlowProcessingPhase.setMuleContext((MuleContext)muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.moduleFlowProcessingPhase, (MuleContext)muleContext);
        this.flow = (FlowConstruct)Mockito.mock(FlowConstruct.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
        FlowExceptionHandler exceptionHandler = (FlowExceptionHandler)Mockito.mock(FlowExceptionHandler.class);
        Mockito.when((Object)this.flow.getExceptionListener()).thenReturn((Object)exceptionHandler);
        Mockito.when((Object)exceptionHandler.apply((Exception)Matchers.any())).thenAnswer(invocationOnMock -> Mono.error((Throwable)((Throwable)invocationOnMock.getArgumentAt(0, MessagingException.class))));
        Mockito.when((Object)this.flow.getMuleContext()).thenReturn((Object)muleContext);
        this.context = (MessageProcessContext)Mockito.mock(MessageProcessContext.class);
        MessageSource source = (MessageSource)Mockito.mock(MessageSource.class);
        Mockito.when((Object)source.getRootContainerLocation()).thenReturn((Object)Location.builder().globalName("root").build());
        Mockito.when((Object)source.getLocation()).thenReturn(Mockito.mock(ComponentLocation.class));
        Mockito.when((Object)this.context.getMessageSource()).thenReturn((Object)source);
        Mockito.when((Object)this.context.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)muleContext.getConfigurationComponentLocator().find((Location)Matchers.any(Location.class))).thenReturn(Optional.of(this.flow));
        this.template = (ModuleFlowProcessingPhaseTemplate)Mockito.mock(ModuleFlowProcessingPhaseTemplate.class);
        Mockito.when((Object)this.template.getMessage()).thenReturn((Object)Message.of(null));
        Mockito.when((Object)this.template.getNotificationFunctions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.template.sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any())).thenAnswer(invocation -> Mono.empty());
        Mockito.when((Object)this.template.sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any())).thenAnswer(invocation -> Mono.empty());
        this.notifier = (PhaseResultNotifier)Mockito.mock(PhaseResultNotifier.class);
    }

    @Test
    public void success() throws Exception {
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifySuccess();
    }

    @Test
    public void successDelayedResponseCompletion() throws Exception {
        Reference sinkReference = new Reference();
        Mockito.when((Object)this.template.sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any())).thenAnswer(invocation -> Mono.create(arg_0 -> ((Reference)sinkReference).set(arg_0)));
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((MonoSink)sinkReference.get()).success();
        this.verifySuccess();
    }

    @Test
    public void successResponseParametersError() throws Exception {
        Mockito.when((Object)this.successResult.getResponseParameters()).thenReturn(this.failingParameterSupplier);
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseGenerate());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)org.hamcrest.Matchers.any(MessagingException.class))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
    }

    @Test
    public void successResponseSendError() throws Exception {
        Mockito.when((Object)this.template.sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)Mono.error((Throwable)this.mockException));
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseSend());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)org.hamcrest.Matchers.any(MessagingException.class))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
    }

    @Test
    public void successResponseParameterAndErrorResponseParameterError() throws Exception {
        Mockito.when((Object)this.successResult.getResponseParameters()).thenReturn(this.failingParameterSupplier);
        Mockito.when((Object)this.successResult.createErrorResponseParameters()).thenReturn(this.failingParameterFunction);
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseGenerate());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseGenerate()))));
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.any());
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException.getClass())));
    }

    @Test
    public void successResponseParameterErrorAndErrorResponseSendError() throws Exception {
        Mockito.when((Object)this.successResult.getResponseParameters()).thenReturn(this.failingParameterSupplier);
        Mockito.when((Object)this.template.sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)Mono.error((Throwable)this.mockException));
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowErrorHandler(this.isErrorTypeSourceResponseGenerate());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseSend()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException.getClass())));
    }

    @Test
    public void failure() throws Exception {
        this.configureFailingFlow(this.mockException);
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        this.verifyFlowError();
    }

    @Test
    public void failureInErrorHandler() throws Exception {
        this.configureErrorHandlingFailingFlow(this.mockException);
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((FlowExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(), (CoreEvent)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseGenerate()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException.getClass())));
    }

    @Test
    public void failureDelayedErrorResponseSendCompletion() throws Exception {
        Reference sinkReference = new Reference();
        Mockito.reset((Object[])new ModuleFlowProcessingPhaseTemplate[]{this.template});
        Mockito.when((Object)this.template.getMessage()).thenReturn((Object)Message.of(null));
        Mockito.when((Object)this.template.getNotificationFunctions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.template.sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any())).thenAnswer(invocation -> Mono.create(arg_0 -> ((Reference)sinkReference).set(arg_0)));
        this.configureFailingFlow(this.mockException);
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((MonoSink)sinkReference.get()).success();
        this.verifyFlowError();
    }

    @Test
    public void failureDelayedErrorResponseSendFailure() throws Exception {
        Reference sinkReference = new Reference();
        this.configureFailingFlow(this.mockException);
        Mockito.when((Object)this.template.sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any())).thenAnswer(invocation -> Mono.create(arg_0 -> ((Reference)sinkReference).set(arg_0)));
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).afterPhaseExecution((Either)Matchers.any());
        ((MonoSink)sinkReference.get()).error((Throwable)this.mockException);
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseSend()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException.getClass())));
    }

    @Test
    public void failureErrorResponseParameterError() throws Exception {
        this.configureFailingFlow(this.mockException);
        Mockito.when((Object)this.failureResult.getErrorResponseParameters()).thenReturn(this.failingParameterSupplier);
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((FlowExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(), (CoreEvent)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseGenerate()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException.getClass())));
    }

    @Test
    public void failureErrorResponseSendError() throws Exception {
        this.configureFailingFlow(this.mockException);
        Mockito.when((Object)this.template.sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)Mono.error((Throwable)this.mockException));
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((FlowExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(), (CoreEvent)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeSourceErrorResponseSend()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException.getClass())));
    }

    @Test
    public void failurePolicyManager() throws Exception {
        Mockito.when((Object)this.policyManager.createSourcePolicyInstance((Component)Matchers.any(Component.class), (CoreEvent)Matchers.any(CoreEvent.class), (Processor)Matchers.any(Processor.class), (MessageSourceResponseParametersProcessor)Matchers.any(MessageSourceResponseParametersProcessor.class))).thenThrow(new Throwable[]{this.mockException});
        Mockito.when((Object)this.template.getFailedExecutionResponseParametersFunction()).thenReturn(coreEvent -> Collections.emptyMap());
        this.moduleFlowProcessingPhase.runPhase(this.template, this.context, this.notifier);
        ((FlowExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(), (CoreEvent)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseFailure((Exception)Matchers.argThat((Matcher)org.hamcrest.Matchers.instanceOf(this.mockException.getClass())));
    }

    private void verifySuccess() {
        ((FlowExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(), (CoreEvent)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.rightMatches((Matcher)org.hamcrest.Matchers.any(CoreEvent.class))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.any());
    }

    private void verifyFlowError() {
        ((FlowExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener(), (VerificationMode)Mockito.never())).handleException((Exception)Matchers.any(), (CoreEvent)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template, (VerificationMode)Mockito.never())).sendResponseToClient((CoreEvent)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).sendFailureResponseToClient((MessagingException)Matchers.any(), (Map)Matchers.any());
        ((ModuleFlowProcessingPhaseTemplate)Mockito.verify((Object)this.template)).afterPhaseExecution((Either)Matchers.argThat((Matcher)EitherMatcher.leftMatches((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)this.isErrorTypeFlowFailure()))));
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier)).phaseSuccessfully();
        ((PhaseResultNotifier)Mockito.verify((Object)this.notifier, (VerificationMode)Mockito.never())).phaseFailure((Exception)Matchers.any());
    }

    private void verifyFlowErrorHandler(EventMatcher errorHandlerEventMatcher) {
        ((FlowExceptionHandler)Mockito.verify((Object)this.flow.getExceptionListener())).apply((Exception)Matchers.argThat((Matcher)MessagingExceptionMatcher.withEventThat((EventMatcher)errorHandlerEventMatcher)));
    }

    private EventMatcher isErrorTypeSourceResponseGenerate() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE.getName());
    }

    private EventMatcher isErrorTypeSourceResponseSend() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND.getName());
    }

    private EventMatcher isErrorTypeFlowFailure() {
        return EventMatcher.hasErrorType((String)ERROR_FROM_FLOW.getNamespace(), (String)ERROR_FROM_FLOW.getIdentifier());
    }

    private EventMatcher isErrorTypeSourceErrorResponseGenerate() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE.getName());
    }

    private EventMatcher isErrorTypeSourceErrorResponseSend() {
        return EventMatcher.hasErrorType((String)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND.getNamespace(), (String)Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND.getName());
    }

    private void configureThrowingFlow(RuntimeException failure, boolean inErrorHandler) {
        Mockito.when((Object)this.sourcePolicy.process((CoreEvent)Matchers.any())).thenAnswer(invocation -> {
            this.messagingException = this.buildFailingFlowException((CoreEvent)invocation.getArgumentAt(0, CoreEvent.class), failure);
            this.messagingException.setInErrorHandler(inErrorHandler);
            return Mono.just((Object)Either.left((Object)this.failureResult));
        });
    }

    private void configureFailingFlow(RuntimeException failure) {
        this.configureThrowingFlow(failure, false);
    }

    private void configureErrorHandlingFailingFlow(RuntimeException failure) {
        this.configureThrowingFlow(failure, true);
    }

    private MessagingException buildFailingFlowException(CoreEvent event, Exception exception) {
        return new MessagingException(CoreEvent.builder((CoreEvent)event).error(ErrorBuilder.builder((Throwable)exception).errorType(ERROR_FROM_FLOW).build()).build(), (Throwable)exception);
    }
}

