/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.execution.ExecuteCallbackInterceptor;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.mule.runtime.core.internal.execution.ValidateTransactionalStateInterceptor;
import org.mule.runtime.core.privileged.transaction.xa.IllegalTransactionStateException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=Parameterized.class)
@SmallTest
public class ValidateTransactionalStateInterceptorTestCase
extends AbstractMuleTestCase {
    public static final MuleTransactionConfig MULE_TRANSACTION_CONFIG_ALWAYS_BEGIN = new MuleTransactionConfig(1);
    public static final MuleTransactionConfig MULE_TRANSACTION_CONFIG_BEGIN_OR_JOIN = new MuleTransactionConfig(2);
    public static final MuleTransactionConfig MULE_TRANSACTION_CONFIG_ALWAYS_JOIN = new MuleTransactionConfig(3);
    public static final MuleTransactionConfig MULE_TRANSACTION_CONFIG_INDIFFERENT = new MuleTransactionConfig(6);
    public static final MuleTransactionConfig MULE_TRANSACTION_CONFIG_JOIN_IF_POSSIBLE = new MuleTransactionConfig(4);
    public static final MuleTransactionConfig MULE_TRANSACTION_CONFIG_NEVER = new MuleTransactionConfig(5);
    public static final MuleTransactionConfig MULE_TRANSACTION_CONFIG_NONE = new MuleTransactionConfig(0);
    private static final Map<Boolean, Map<MuleTransactionConfig, Boolean>> resultMap = new HashMap<Boolean, Map<MuleTransactionConfig, Boolean>>();
    private boolean hasTransactionInContext;
    private TransactionConfig transactionConfig;
    private CoreEvent mockMuleEvent = (CoreEvent)Mockito.mock(CoreEvent.class);
    private Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);

    @Parameterized.Parameters(name="TX in Contex: {0}. TX Config: {1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false, MULE_TRANSACTION_CONFIG_ALWAYS_BEGIN}, {false, MULE_TRANSACTION_CONFIG_ALWAYS_JOIN}, {false, MULE_TRANSACTION_CONFIG_BEGIN_OR_JOIN}, {false, MULE_TRANSACTION_CONFIG_INDIFFERENT}, {false, MULE_TRANSACTION_CONFIG_JOIN_IF_POSSIBLE}, {false, MULE_TRANSACTION_CONFIG_NEVER}, {false, MULE_TRANSACTION_CONFIG_NONE}, {true, MULE_TRANSACTION_CONFIG_ALWAYS_JOIN}, {true, MULE_TRANSACTION_CONFIG_BEGIN_OR_JOIN}, {true, MULE_TRANSACTION_CONFIG_INDIFFERENT}, {true, MULE_TRANSACTION_CONFIG_JOIN_IF_POSSIBLE}, {true, MULE_TRANSACTION_CONFIG_NEVER}, {true, MULE_TRANSACTION_CONFIG_NONE});
    }

    public ValidateTransactionalStateInterceptorTestCase(boolean hasTransactionInContext, TransactionConfig transactionConfig) {
        this.hasTransactionInContext = hasTransactionInContext;
        this.transactionConfig = transactionConfig;
    }

    @Before
    public void removeTransaction() {
        TransactionCoordination.getInstance().clear();
    }

    @Test
    public void testTransactionalState() throws Exception {
        boolean shouldThrowException = resultMap.get(this.hasTransactionInContext).get(this.transactionConfig);
        IllegalTransactionStateException thrownException = null;
        CoreEvent result = null;
        if (this.hasTransactionInContext) {
            TransactionCoordination.getInstance().bindTransaction(this.mockTransaction);
        }
        ValidateTransactionalStateInterceptor interceptor = new ValidateTransactionalStateInterceptor((ExecutionInterceptor)new ExecuteCallbackInterceptor(), this.transactionConfig, false);
        try {
            result = (CoreEvent)interceptor.execute(() -> this.mockMuleEvent, new ExecutionContext());
        }
        catch (IllegalTransactionStateException e) {
            thrownException = e;
        }
        if (shouldThrowException) {
            Assert.assertThat((Object)((Object)thrownException), (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)((Object)thrownException), (Matcher)IsInstanceOf.instanceOf(IllegalTransactionStateException.class));
        } else {
            Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockMuleEvent));
        }
    }

    static {
        HashMap<MuleTransactionConfig, Boolean> falseResultMap = new HashMap<MuleTransactionConfig, Boolean>();
        HashMap<MuleTransactionConfig, Boolean> trueResultMap = new HashMap<MuleTransactionConfig, Boolean>();
        resultMap.put(false, falseResultMap);
        resultMap.put(true, trueResultMap);
        falseResultMap.put(MULE_TRANSACTION_CONFIG_ALWAYS_BEGIN, false);
        falseResultMap.put(MULE_TRANSACTION_CONFIG_ALWAYS_JOIN, true);
        falseResultMap.put(MULE_TRANSACTION_CONFIG_BEGIN_OR_JOIN, false);
        falseResultMap.put(MULE_TRANSACTION_CONFIG_INDIFFERENT, false);
        falseResultMap.put(MULE_TRANSACTION_CONFIG_JOIN_IF_POSSIBLE, false);
        falseResultMap.put(MULE_TRANSACTION_CONFIG_NEVER, false);
        falseResultMap.put(MULE_TRANSACTION_CONFIG_NONE, false);
        trueResultMap.put(MULE_TRANSACTION_CONFIG_ALWAYS_BEGIN, false);
        trueResultMap.put(MULE_TRANSACTION_CONFIG_ALWAYS_JOIN, false);
        trueResultMap.put(MULE_TRANSACTION_CONFIG_BEGIN_OR_JOIN, false);
        trueResultMap.put(MULE_TRANSACTION_CONFIG_INDIFFERENT, false);
        trueResultMap.put(MULE_TRANSACTION_CONFIG_JOIN_IF_POSSIBLE, false);
        trueResultMap.put(MULE_TRANSACTION_CONFIG_NEVER, true);
        trueResultMap.put(MULE_TRANSACTION_CONFIG_NONE, false);
    }
}

