/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.phases.LifecyclePhase;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase")
public class DefaultLifecycleInterceptorTestCase {
    public DefaultLifecycleInterceptor interceptor = new DefaultLifecycleInterceptor("start", "stop", Startable.class);
    private Object startableAndStoppableObject;
    private Object stoppableObject;
    private LifecyclePhase startLifecyclePhase;
    private LifecyclePhase stopLifecyclePhase;

    @Before
    public void before() {
        this.startableAndStoppableObject = Mockito.mock(Object.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Startable.class, Stoppable.class}));
        this.stoppableObject = Mockito.mock(Object.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Stoppable.class}));
        this.startLifecyclePhase = (LifecyclePhase)Mockito.mock(LifecyclePhase.class);
        this.stopLifecyclePhase = (LifecyclePhase)Mockito.mock(LifecyclePhase.class);
        Mockito.when((Object)this.startLifecyclePhase.getName()).thenReturn((Object)"start");
        Mockito.when((Object)this.stopLifecyclePhase.getName()).thenReturn((Object)"stop");
    }

    @Test
    public void applyStart() {
        Assert.assertThat((Object)this.interceptor.beforePhaseExecution(this.startLifecyclePhase, this.startableAndStoppableObject), (Matcher)Is.is((Object)true));
    }

    @Test
    public void stopIsNotAppliedIfStartWasNotCalled() {
        Assert.assertThat((Object)this.interceptor.beforePhaseExecution(this.stopLifecyclePhase, this.startableAndStoppableObject), (Matcher)Is.is((Object)false));
    }

    @Test
    public void stopIsAppliedIfObjectIsNotStartable() {
        Assert.assertThat((Object)this.interceptor.beforePhaseExecution(this.startLifecyclePhase, this.stoppableObject), (Matcher)Is.is((Object)true));
    }

    @Test
    public void stopIsNotInvokedIfStartFailed() {
        Assert.assertThat((Object)this.interceptor.beforePhaseExecution(this.startLifecyclePhase, this.startableAndStoppableObject), (Matcher)Is.is((Object)true));
        this.interceptor.afterPhaseExecution(this.startLifecyclePhase, this.startableAndStoppableObject, Optional.of(new RuntimeException()));
        Assert.assertThat((Object)this.interceptor.beforePhaseExecution(this.stopLifecyclePhase, this.startableAndStoppableObject), (Matcher)Is.is((Object)false));
    }
}

