/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.internal.lock.InstanceLockGroup;
import org.mule.runtime.core.internal.lock.LockProvider;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class InstanceLockGroupTestCase
extends AbstractMuleTestCase {
    public static final int THREAD_COUNT = 100;
    public static final int ITERATIONS_PER_THREAD = 100;
    private Latch threadStartLatch = new Latch();
    private String sharedKeyA = "A";
    private String sharedKeyB = "B";
    private InstanceLockGroup instanceLockGroup = new InstanceLockGroup((LockProvider)new SingleServerLockProvider());
    private InMemoryObjectStore objectStore = new InMemoryObjectStore();
    private LockProvider mockLockProvider;

    @Test
    public void testLockUnlock() throws Exception {
        this.testHighConcurrency(false);
    }

    @Test
    public void testTryLockUnlock() throws Exception {
        this.testHighConcurrency(true);
    }

    @Test
    public void testWhenUnlockThenDestroy() throws Exception {
        this.lockUnlockThenDestroy(1);
    }

    @Test
    public void testWhenSeveralLockOneUnlockThenDestroy() throws Exception {
        this.lockUnlockThenDestroy(5);
    }

    private void lockUnlockThenDestroy(int lockTimes) {
        this.mockLockProvider = (LockProvider)Mockito.mock(LockProvider.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        InstanceLockGroup instanceLockGroup = new InstanceLockGroup(this.mockLockProvider);
        for (int i = 0; i < lockTimes; ++i) {
            instanceLockGroup.lock("lockId");
        }
        instanceLockGroup.unlock("lockId");
        ((LockProvider)Mockito.verify((Object)this.mockLockProvider, (VerificationMode)VerificationModeFactory.times((int)1))).createLock("lockId");
    }

    private void testHighConcurrency(boolean useTryLock) throws InterruptedException, ObjectStoreException {
        ArrayList<IncrementKeyValueThread> threads = new ArrayList<IncrementKeyValueThread>(200);
        for (int i = 0; i < 100; ++i) {
            IncrementKeyValueThread incrementKeyValueThread = new IncrementKeyValueThread(this.sharedKeyA, useTryLock);
            threads.add(incrementKeyValueThread);
            incrementKeyValueThread.start();
            IncrementKeyValueThread incrementKeyValueThread2 = new IncrementKeyValueThread(this.sharedKeyB, useTryLock);
            threads.add(incrementKeyValueThread2);
            incrementKeyValueThread2.start();
        }
        this.threadStartLatch.release();
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertThat((Object)this.objectStore.retrieve(this.sharedKeyA), (Matcher)Is.is((Object)10000));
        Assert.assertThat((Object)this.objectStore.retrieve(this.sharedKeyB), (Matcher)Is.is((Object)10000));
    }

    public static class InMemoryObjectStore
    extends TemplateObjectStore<Integer> {
        private Map<String, Integer> store = new ConcurrentHashMap<String, Integer>();

        protected boolean doContains(String key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        protected void doStore(String key, Integer value) throws ObjectStoreException {
            this.store.put(key, value);
        }

        protected Integer doRetrieve(String key) throws ObjectStoreException {
            return this.store.get(key);
        }

        protected Integer doRemove(String key) throws ObjectStoreException {
            return this.store.remove(key);
        }

        public void clear() throws ObjectStoreException {
            this.store.clear();
        }

        public boolean isPersistent() {
            return false;
        }

        public void open() throws ObjectStoreException {
        }

        public void close() throws ObjectStoreException {
        }

        public List<String> allKeys() throws ObjectStoreException {
            return new ArrayList<String>(this.store.keySet());
        }

        public Map<String, Integer> retrieveAll() throws ObjectStoreException {
            return Collections.unmodifiableMap(this.store);
        }
    }

    public class IncrementKeyValueThread
    extends Thread {
        private String key;
        private boolean useTryLock;

        private IncrementKeyValueThread(String key, boolean useTryLock) {
            super("Thread-" + key);
            this.key = key;
            this.useTryLock = useTryLock;
        }

        @Override
        public void run() {
            try {
                InstanceLockGroupTestCase.this.threadStartLatch.await(5000L, TimeUnit.MILLISECONDS);
                for (int i = 0; i < 100 && !Thread.interrupted(); ++i) {
                    if (this.useTryLock) {
                        while (!InstanceLockGroupTestCase.this.instanceLockGroup.tryLock(this.key, 100L, TimeUnit.MILLISECONDS)) {
                        }
                    } else {
                        InstanceLockGroupTestCase.this.instanceLockGroup.lock(this.key);
                    }
                    try {
                        Integer value;
                        if (InstanceLockGroupTestCase.this.objectStore.contains(this.key)) {
                            value = (Integer)InstanceLockGroupTestCase.this.objectStore.retrieve(this.key);
                            InstanceLockGroupTestCase.this.objectStore.remove(this.key);
                        } else {
                            value = 0;
                        }
                        InstanceLockGroupTestCase.this.objectStore.store(this.key, Integer.valueOf(value + 1));
                        continue;
                    }
                    finally {
                        InstanceLockGroupTestCase.this.instanceLockGroup.unlock(this.key);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

