/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalLong;
import javax.activation.DataHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.internal.message.BaseAttributes;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.metadata.DefaultCollectionDataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeCompatibilityMatcher;
import org.mule.tck.testmodels.fruit.Apple;

public class DefaultMuleMessageBuilderTestCase
extends AbstractMuleTestCase {
    private static final String NEW_PAYLOAD = "new payload";
    private static final String EMPTY_JSON = "{}";
    private static final Object BASE_ATTRIBUTES = new BaseAttributes(){};
    private static final DataType BASE_ATTRIBUTES_DATATYPE = DataType.fromObject((Object)BASE_ATTRIBUTES);
    private static final String PROPERTY_KEY = "propertyKey";
    private static final Serializable PROPERTY_VALUE = "propertyValue";
    private static final MediaType HTML_STRING_UTF8 = MediaType.HTML.withCharset(StandardCharsets.UTF_8);

    @Test
    public void createNewAPIMessageViaMessageInterface() {
        Message message = Message.builder().value((Object)"test").mediaType(HTML_STRING_UTF8).build();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(String.class));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)HTML_STRING_UTF8));
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)message.getAttributes().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT.getMediaType()));
    }

    @Test
    public void createAPIMessageViaMessageInterfaceFromCopy() {
        Message message = Message.builder().value((Object)"test").build();
        Message messageCopy = Message.builder((Message)message).value((Object)true).attributesValue(BASE_ATTRIBUTES).build();
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.BOOLEAN));
        MatcherAssert.assertThat((Object)messageCopy.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)BASE_ATTRIBUTES));
        MatcherAssert.assertThat((Object)messageCopy.getAttributes().getDataType(), (Matcher)CoreMatchers.is((Object)BASE_ATTRIBUTES_DATATYPE));
    }

    @Test
    public void createNewMessageViaMessageInterface() {
        Message message = Message.builder().value((Object)"test").build();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void createNewMessageCollectionViaMessageInterface() {
        ArrayList<String> htmlStringList = new ArrayList<String>();
        htmlStringList.add("HTML1");
        htmlStringList.add("HTML2");
        htmlStringList.add("HTML3");
        InternalMessage message = InternalMessage.builder().collectionValue(htmlStringList, String.class).itemMediaType(MediaType.HTML).build();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is(htmlStringList));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(ArrayList.class));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType(), (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        MatcherAssert.assertThat((Object)((DefaultCollectionDataType)message.getPayload().getDataType()).getItemDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)MediaType.HTML));
    }

    @Test
    public void createNewMessageCollectionViaMessageInterfaceCopy() {
        ArrayList<String> htmlStringList = new ArrayList<String>();
        htmlStringList.add("HTML1");
        htmlStringList.add("HTML2");
        htmlStringList.add("HTML3");
        InternalMessage message = InternalMessage.builder().collectionValue(htmlStringList, String.class).itemMediaType(MediaType.HTML).build();
        InternalMessage copy = InternalMessage.builder((Message)message).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.is(htmlStringList));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(ArrayList.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType(), (Matcher)CoreMatchers.instanceOf(DefaultCollectionDataType.class));
        MatcherAssert.assertThat((Object)((DefaultCollectionDataType)copy.getPayload().getDataType()).getItemDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)MediaType.HTML));
    }

    @Test
    public void createMessageViaMessageInterfaceFromCopy() {
        InternalMessage messageCopy = InternalMessage.builder((Message)this.createTestMessage()).value((Object)true).attributesValue(BASE_ATTRIBUTES).build();
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)messageCopy.getPayload().getDataType(), (Matcher)CoreMatchers.is((Matcher)DataTypeCompatibilityMatcher.assignableTo((DataType)DataType.BOOLEAN)));
        MatcherAssert.assertThat((Object)messageCopy.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)BASE_ATTRIBUTES));
        MatcherAssert.assertThat((Object)messageCopy.getAttributes().getDataType(), (Matcher)CoreMatchers.is((Object)BASE_ATTRIBUTES_DATATYPE));
    }

    @Test
    public void testOnlyPayload() {
        Message message = Message.of((Object)"test");
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
    }

    @Test
    public void wholePayload() {
        Message message = Message.builder().payload(new TypedValue((Object)EMPTY_JSON, DataType.JSON_STRING)).build();
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)EMPTY_JSON));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(String.class));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JSON));
    }

    @Test
    public void messageAttributes() {
        this.assertTestMessage(this.createTestMessage());
    }

    @Test
    public void wholeAttributes() {
        Message message = Message.builder().nullValue().attributes(new TypedValue((Object)EMPTY_JSON, DataType.JSON_STRING)).build();
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.equalTo((Object)EMPTY_JSON));
        MatcherAssert.assertThat((Object)message.getAttributes().getDataType().getType(), (Matcher)CoreMatchers.equalTo(String.class));
        MatcherAssert.assertThat((Object)message.getAttributes().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JSON));
    }

    @Test
    public void messageAttributesCopy() {
        this.assertTestMessage((Message)new DefaultMessageBuilder(this.createTestMessage()).build());
    }

    @Test
    public void inboundPropertyMap() {
        Map<String, Serializable> inboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage message = new DefaultMessageBuilder().value((Object)"test").inboundProperties(inboundProperties).build();
        MatcherAssert.assertThat((Object)message.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void inboundPropertyMapCopy() {
        Map<String, Serializable> inboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage copy = new DefaultMessageBuilder((Message)new DefaultMessageBuilder().value((Object)"test").inboundProperties(inboundProperties).build()).build();
        MatcherAssert.assertThat((Object)copy.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)copy.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)copy.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)copy.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundPropertyMap() {
        Map<String, Serializable> outboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage message = new DefaultMessageBuilder().value((Object)"test").outboundProperties(outboundProperties).build();
        MatcherAssert.assertThat((Object)message.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundPropertyMapCopy() {
        Map<String, Serializable> outboundProperties = Collections.singletonMap(PROPERTY_KEY, PROPERTY_VALUE);
        InternalMessage copy = new DefaultMessageBuilder((Message)new DefaultMessageBuilder().value((Object)"test").outboundProperties(outboundProperties).build()).build();
        MatcherAssert.assertThat((Object)copy.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)copy.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)copy.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)copy.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void inboundProperty() {
        InternalMessage message = new DefaultMessageBuilder().value((Object)"test").addInboundProperty(PROPERTY_KEY, PROPERTY_VALUE).build();
        MatcherAssert.assertThat((Object)message.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void inboundPropertyDataType() {
        InternalMessage message = new DefaultMessageBuilder().value((Object)"test").addInboundProperty(PROPERTY_KEY, PROPERTY_VALUE, DataType.HTML_STRING).build();
        MatcherAssert.assertThat((Object)message.getInboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getInboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.HTML_STRING));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getInboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundProperty() {
        InternalMessage message = new DefaultMessageBuilder().value((Object)"test").addOutboundProperty(PROPERTY_KEY, PROPERTY_VALUE).build();
        MatcherAssert.assertThat((Object)message.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.STRING));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void outboundPropertyDataType() {
        InternalMessage message = new DefaultMessageBuilder().value((Object)"test").addOutboundProperty(PROPERTY_KEY, PROPERTY_VALUE, DataType.HTML_STRING).build();
        MatcherAssert.assertThat((Object)message.getOutboundProperty(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)PROPERTY_VALUE));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyDataType(PROPERTY_KEY), (Matcher)CoreMatchers.equalTo((Object)DataType.HTML_STRING));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)message.getOutboundPropertyNames(), (Matcher)CoreMatchers.hasItem((Object)PROPERTY_KEY));
    }

    @Test
    public void nullPayload() {
        Message message = Message.of(null);
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(Object.class));
    }

    @Test
    public void mutateEntirePayload() {
        Message message = this.createTestMessage();
        InternalMessage copy = new DefaultMessageBuilder(message).payload(new TypedValue((Object)EMPTY_JSON, DataType.JSON_STRING)).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)EMPTY_JSON));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(String.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.APPLICATION_JSON));
    }

    @Test
    public void mutatePayloadSameTypeConserveTypeAndMimeType() {
        Message message = this.createTestMessage();
        InternalMessage copy = new DefaultMessageBuilder(message).value((Object)NEW_PAYLOAD).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)NEW_PAYLOAD));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(String.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT));
    }

    @Test
    public void mutatePayloadDifferentTypeUpdateTypeAndConserveMimeType() {
        InternalMessage copy = new DefaultMessageBuilder(this.createTestMessage()).value((Object)1).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(Integer.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT));
    }

    @Test
    public void mutatePayloadDifferentTypeWithMediaTypeUpdateTypeAndConserveMimeType() {
        Long payload = new Long(1L);
        DataHandler dataHandler = new DataHandler((Object)payload, MediaType.XML.toString());
        InternalMessage copy = new DefaultMessageBuilder(this.createTestMessage()).value((Object)dataHandler).build();
        MatcherAssert.assertThat((Object)copy.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)dataHandler));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getType(), (Matcher)CoreMatchers.equalTo(DataHandler.class));
        MatcherAssert.assertThat((Object)copy.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.XML));
    }

    @Test
    public void copyPreservesDataType() {
        Apple apple = new Apple();
        long appleSize = 111L;
        InternalMessage message = new DefaultMessageBuilder().payload(new TypedValue((Object)apple, DataType.fromObject((Object)apple), OptionalLong.of(appleSize))).build();
        InternalMessage copy = new DefaultMessageBuilder((Message)message).build();
        MatcherAssert.assertThat((Object)copy.getPayload(), (Matcher)CoreMatchers.is((Object)message.getPayload()));
        MatcherAssert.assertThat((Object)copy.getAttributes(), (Matcher)CoreMatchers.is((Object)message.getAttributes()));
        MatcherAssert.assertThat((Object)message.getPayload().getByteLength().getAsLong(), (Matcher)CoreMatchers.is((Object)appleSize));
        MatcherAssert.assertThat((Object)copy.getPayload().getByteLength().getAsLong(), (Matcher)CoreMatchers.is((Object)appleSize));
    }

    private Message createTestMessage() {
        return new DefaultMessageBuilder().value((Object)"test").mediaType(MediaType.TEXT).build();
    }

    private void assertTestMessage(Message message) {
        MatcherAssert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.TEXT_STRING));
        MatcherAssert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)message.getAttributes().getDataType(), (Matcher)CoreMatchers.is((Object)DataType.OBJECT));
    }
}

