/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DefaultMuleMessageSerializationTestCase
extends AbstractMuleContextTestCase {
    private static final String INNER_TEST_MESSAGE = "TestTestTestHello";

    @After
    public void teardown() {
        DefaultMuleContext.currentMuleContext.set(null);
    }

    @Test
    public void testSerializablePayload() throws Exception {
        InternalMessage message = InternalMessage.builder().value((Object)"Test Message").addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        InternalMessage deserializedMessage = this.serializationRoundtrip((Message)message);
        Assert.assertEquals((Object)"Test Message", (Object)deserializedMessage.getPayload().getValue());
        Assert.assertEquals((Object)"bar", (Object)deserializedMessage.getOutboundProperty("foo"));
    }

    @Test
    public void testNonSerializablePayload() throws Exception {
        ((MuleContextWithRegistries)muleContext).getRegistry().registerTransformer((Transformer)new NonSerializableToByteArray());
        InternalMessage message = InternalMessage.builder().value((Object)new NonSerializable()).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        DefaultMuleContext.currentMuleContext.set(muleContext);
        InternalMessage deserializedMessage = this.serializationRoundtrip((Message)message);
        Assert.assertTrue((boolean)(deserializedMessage.getPayload().getValue() instanceof byte[]));
        Assert.assertEquals((Object)INNER_TEST_MESSAGE, (Object)this.getPayloadAsString((Message)deserializedMessage));
    }

    @Test
    public void testStreamPayloadSerialization() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream("Test Message".getBytes());
        InternalMessage message = InternalMessage.builder().value((Object)stream).addOutboundProperty("foo", (Serializable)((Object)"bar")).build();
        DefaultMuleContext.currentMuleContext.set(muleContext);
        InternalMessage deserializedMessage = this.serializationRoundtrip((Message)message);
        Assert.assertEquals(byte[].class, (Object)deserializedMessage.getPayload().getDataType().getType());
        byte[] payload = (byte[])deserializedMessage.getPayload().getValue();
        Assert.assertTrue((boolean)Arrays.equals("Test Message".getBytes(), payload));
    }

    private InternalMessage serializationRoundtrip(Message message) throws Exception {
        return (InternalMessage)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)message));
    }

    static class NonSerializableToByteArray
    extends ObjectToByteArray {
        public NonSerializableToByteArray() {
            this.registerSourceType(DataType.fromType(NonSerializable.class));
            this.setReturnDataType(DataType.BYTE_ARRAY);
        }

        public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
            String content = ((NonSerializable)src).getContent();
            return content.getBytes();
        }
    }

    static class NonSerializable {
        private String content = "TestTestTestHello";

        NonSerializable() {
        }

        String getContent() {
            return this.content;
        }
    }
}

