/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
public class MuleMessageDataTypePropagationTestCase
extends AbstractMuleTestCase {
    public static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    public static final Charset CUSTOM_ENCODING = StandardCharsets.UTF_16;
    public static final String TEST_PROPERTY = "testProperty";
    public static final MediaType CUSTOM_MIME_TYPE = MediaType.TEXT;
    public static final MediaType APPLICATION_XML_DEFAULT = MediaType.APPLICATION_XML.withCharset(DEFAULT_ENCODING);
    public static final MediaType APPLICATION_XML_CUSTOM = MediaType.APPLICATION_XML.withCharset(CUSTOM_ENCODING);
    public static final String CUSTOM_CONTENT_TYPE = CUSTOM_MIME_TYPE + "; charset=" + CUSTOM_ENCODING;
    private MuleContextWithRegistries muleContext = (MuleContextWithRegistries)Mockito.mock(MuleContextWithRegistries.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private ExtendedTransformationService transformationService;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleContext.getConfiguration().getDefaultEncoding()).thenReturn((Object)DEFAULT_ENCODING.name());
        MuleContextUtils.registerIntoMockContext((MuleContextWithRegistries)this.muleContext, (String)"_defaultRetryPolicyTemplate", (Object)Mockito.mock(RetryPolicyTemplate.class));
        this.transformationService = new ExtendedTransformationService((MuleContext)this.muleContext);
    }

    @Test
    public void defaultEmptyEncodingWithNoProperty() throws Exception {
        Message message = Message.of((Object)"test");
        this.assertEmptyDataType(message);
    }

    @Test
    public void usesCustomEncodingWithNoProperty() throws Exception {
        Message message = Message.builder().value((Object)"test").mediaType(MediaType.ANY.withCharset(CUSTOM_ENCODING)).build();
        MatcherAssert.assertThat(message.getPayload().getDataType().getMediaType().getCharset().get(), (Matcher)Matchers.equalTo((Object)CUSTOM_ENCODING));
        this.assertCustomEncoding(message);
    }

    @Test
    public void setsDataTypeFromPreviousMessageOnCreation() throws Exception {
        Message message = Message.builder().value((Object)1).mediaType(APPLICATION_XML_CUSTOM).build();
        this.assertDataType((Message)InternalMessage.builder((Message)message).build(), message.getPayload().getDataType());
    }

    @Test
    public void overridesDataTypeFromPreviousMessageOnCreation() throws Exception {
        Message message = Message.builder().value((Object)1).mediaType(APPLICATION_XML_CUSTOM).build();
        this.assertDataType((Message)InternalMessage.builder((Message)message).value((Object)"TEST").build(), String.class, MediaType.APPLICATION_XML, CUSTOM_ENCODING);
    }

    @Test
    public void updatesDataTypeWhenPayloadIsReplacedWithNullPayload() throws Exception {
        Message muleMessage = Message.of((Object)"test");
        this.assertDataType((Message)InternalMessage.builder((Message)muleMessage).nullValue().build(), Object.class, MediaType.ANY, null);
    }

    @Test
    public void setsNullPayloadWithDataType() throws Exception {
        Message muleMessage = Message.of((Object)"test");
        this.assertDataType((Message)InternalMessage.builder((Message)muleMessage).nullValue().mediaType(APPLICATION_XML_CUSTOM).build(), Object.class, MediaType.APPLICATION_XML, CUSTOM_ENCODING);
    }

    @Test
    public void setsPayloadWithDataType() throws Exception {
        Message muleMessage = Message.of((Object)"test");
        this.assertDataType((Message)InternalMessage.builder((Message)muleMessage).value((Object)1).mediaType(APPLICATION_XML_CUSTOM).build(), Integer.class, MediaType.APPLICATION_XML, CUSTOM_ENCODING);
    }

    @Test
    public void updatesTypeOnTransformation() throws Exception {
        Message message = Message.builder().value((Object)1).mediaType(APPLICATION_XML_DEFAULT).build();
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataType.builder().type(Integer.class).mediaType(MediaType.ANY).charset(DEFAULT_ENCODING).build();
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        Mockito.when((Object)transformer.transform(org.mockito.Matchers.anyObject())).thenReturn((Object)1);
        CoreEvent muleEvent = (CoreEvent)Mockito.mock(CoreEvent.class);
        Message result = this.transformationService.applyTransformers(message, muleEvent, Collections.singletonList(transformer));
        this.assertDataType(result, Integer.class, MediaType.APPLICATION_XML, DEFAULT_ENCODING);
    }

    @Test
    public void updatesEncodingOnTransformation() throws Exception {
        Message message = Message.builder().value((Object)"test").mediaType(APPLICATION_XML_DEFAULT).build();
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataType.builder().type(Integer.class).charset(CUSTOM_ENCODING).build();
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        Mockito.when((Object)transformer.transform(org.mockito.Matchers.anyObject())).thenReturn((Object)1);
        CoreEvent muleEvent = (CoreEvent)Mockito.mock(CoreEvent.class);
        Message result = this.transformationService.applyTransformers(message, muleEvent, Collections.singletonList(transformer));
        this.assertDataType(result, Integer.class, MediaType.APPLICATION_XML, CUSTOM_ENCODING);
    }

    @Test
    public void updatesMimeTypeOnTransformation() throws Exception {
        Message message = Message.builder().value((Object)"test").mediaType(MediaType.ANY.withCharset(CUSTOM_ENCODING)).build();
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataType.builder().type(Integer.class).mediaType(MediaType.APPLICATION_XML).build();
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        Mockito.when((Object)transformer.transform((Object)org.mockito.Matchers.anyString())).thenReturn((Object)1);
        CoreEvent muleEvent = (CoreEvent)Mockito.mock(CoreEvent.class);
        Message result = this.transformationService.applyTransformers(message, muleEvent, Collections.singletonList(transformer));
        this.assertDataType(result, Integer.class, MediaType.APPLICATION_XML, CUSTOM_ENCODING);
    }

    @Test
    public void maintainsCurrentDataTypeClassWhenTransformerOutputTypeIsObject() throws Exception {
        Message message = Message.of((Object)"test");
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataType.builder().type(Object.class).mediaType(MediaType.ANY).build();
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        Mockito.when((Object)transformer.transform((Object)message)).thenReturn((Object)"test");
        CoreEvent muleEvent = (CoreEvent)Mockito.mock(CoreEvent.class);
        Message result = this.transformationService.applyTransformers(message, muleEvent, Collections.singletonList(transformer));
        this.assertDataType(result, String.class, MediaType.ANY, DEFAULT_ENCODING);
    }

    @Test
    public void maintainsDataTypeOnGetPayloadTransformation() throws Exception {
        InputStream payload = (InputStream)Mockito.mock(InputStream.class);
        Message message = Message.builder().value((Object)payload).mediaType(APPLICATION_XML_CUSTOM).build();
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.transform(org.mockito.Matchers.anyObject(), (Charset)org.mockito.Matchers.anyObject())).thenReturn((Object)"test");
        Mockito.when((Object)muleRegistry.lookupTransformer((DataType)org.mockito.Matchers.any(), (DataType)org.mockito.Matchers.any())).thenReturn((Object)transformer);
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType().getPrimaryType(), (Matcher)Matchers.equalTo((Object)MediaType.APPLICATION_XML.getPrimaryType()));
        MatcherAssert.assertThat((Object)message.getPayload().getDataType().getMediaType().getSubType(), (Matcher)Matchers.equalTo((Object)MediaType.APPLICATION_XML.getSubType()));
        MatcherAssert.assertThat(message.getPayload().getDataType().getMediaType().getCharset().get(), (Matcher)Matchers.equalTo((Object)CUSTOM_ENCODING));
    }

    @Test
    public void setsDefaultOutboundPropertyDataType() throws Exception {
        InternalMessage message = InternalMessage.builder().value((Object)"test").addOutboundProperty(TEST_PROPERTY, (Serializable)((Object)"test")).build();
        this.assertDefaultOutboundPropertyDataType(message);
    }

    @Test
    public void setsCustomOutboundPropertyDataType() throws Exception {
        MediaType mediaType = APPLICATION_XML_CUSTOM;
        InternalMessage message = InternalMessage.builder().value((Object)"test").addOutboundProperty(TEST_PROPERTY, (Serializable)((Object)"test"), mediaType).build();
        this.assertOutboundPropertyDataType(message, DataType.builder().type(String.class).mediaType(mediaType).build());
    }

    @Test
    public void setsDefaultOutboundScopePropertyDataType() throws Exception {
        InternalMessage message = InternalMessage.builder().value((Object)"test").addOutboundProperty(TEST_PROPERTY, (Serializable)((Object)"test")).build();
        this.assertDefaultOutboundPropertyDataType(message);
    }

    @Test
    public void setsDefaultInboundPropertyDataType() throws Exception {
        InternalMessage message = InternalMessage.builder().value((Object)"test").addInboundProperty(TEST_PROPERTY, (Serializable)((Object)"test")).build();
        this.assertDefaultInboundPropertyDataType(message);
    }

    @Test
    public void setsCustomInboundPropertyDataType() throws Exception {
        MediaType mediaType = APPLICATION_XML_CUSTOM;
        InternalMessage message = InternalMessage.builder().value((Object)"test").addInboundProperty(TEST_PROPERTY, (Serializable)((Object)"test"), mediaType).build();
        this.assertInboundPropertyDataType(message, DataType.builder().type(String.class).mediaType(mediaType).build());
    }

    @Test
    public void setsDefaultInboundScopePropertyDataType() throws Exception {
        InternalMessage message = InternalMessage.builder().value((Object)"test").addInboundProperty(TEST_PROPERTY, (Serializable)((Object)"test")).build();
        this.assertDefaultInboundPropertyDataType(message);
    }

    @Test
    public void setsDefaultFlowVariableDataType() throws Exception {
        CoreEvent muleEvent = CoreEvent.builder((CoreEvent)this.testEvent()).addVariable(TEST_PROPERTY, (Object)"test").build();
        this.assertVariableDataType(muleEvent, DataType.STRING);
    }

    @Test
    public void setsCustomFlowVariableDataType() throws Exception {
        DataType dataType = DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_XML).charset(CUSTOM_ENCODING).build();
        CoreEvent muleEvent = CoreEvent.builder((CoreEvent)this.testEvent()).addVariable(TEST_PROPERTY, (Object)"test", dataType).build();
        this.assertVariableDataType(muleEvent, dataType);
    }

    @Test
    public void setsDefaultSessionVariableDataType() throws Exception {
        ((PrivilegedEvent)this.testEvent()).getSession().setProperty(TEST_PROPERTY, (Serializable)((Object)"test"));
        this.assertSessionVariableDataType(this.testEvent(), DataType.STRING);
    }

    @Test
    public void setsCustomSessionVariableDataType() throws Exception {
        DataType dataType = DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_XML).charset(CUSTOM_ENCODING).build();
        ((PrivilegedEvent)this.testEvent()).getSession().setProperty(TEST_PROPERTY, (Serializable)((Object)"test"), dataType);
        this.assertSessionVariableDataType(this.testEvent(), dataType);
    }

    @Test
    public void setsCustomPropertyDataType() throws Exception {
        MediaType mediaType = APPLICATION_XML_CUSTOM;
        InternalMessage message = InternalMessage.builder().value((Object)"test").addOutboundProperty(TEST_PROPERTY, (Serializable)((Object)"test"), mediaType).build();
        this.assertOutboundPropertyDataType(message, DataType.builder((DataType)DataType.STRING).mediaType(mediaType).build());
    }

    private void assertEmptyDataType(Message muleMessage) {
        MatcherAssert.assertThat((Object)muleMessage.getPayload().getDataType().getMediaType().getCharset().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    private void assertCustomEncoding(Message muleMessage) {
        MatcherAssert.assertThat(muleMessage.getPayload().getDataType().getMediaType().getCharset().get(), (Matcher)Matchers.is((Object)CUSTOM_ENCODING));
    }

    private void assertDataType(Message muleMessage, Class<?> type, MediaType mimeType, Charset encoding) {
        MatcherAssert.assertThat((Object)muleMessage.getPayload().getDataType(), (Matcher)DataTypeMatcher.like(type, (MediaType)mimeType, (Charset)encoding));
    }

    private void assertDataType(Message muleMessage, DataType dataType) {
        MatcherAssert.assertThat((Object)muleMessage.getPayload().getDataType(), (Matcher)DataTypeMatcher.like((DataType)dataType));
    }

    private void assertDefaultInboundPropertyDataType(InternalMessage muleMessage) {
        this.assertInboundPropertyDataType(muleMessage, DataType.STRING);
    }

    private void assertDefaultOutboundPropertyDataType(InternalMessage muleMessage) {
        this.assertOutboundPropertyDataType(muleMessage, DataType.STRING);
    }

    private void assertInboundPropertyDataType(InternalMessage muleMessage, DataType dataType) {
        DataType actualDataType = muleMessage.getInboundPropertyDataType(TEST_PROPERTY);
        MatcherAssert.assertThat((Object)actualDataType, (Matcher)DataTypeMatcher.like((DataType)dataType));
    }

    private void assertOutboundPropertyDataType(InternalMessage muleMessage, DataType dataType) {
        DataType actualDataType = muleMessage.getOutboundPropertyDataType(TEST_PROPERTY);
        MatcherAssert.assertThat((Object)actualDataType, (Matcher)DataTypeMatcher.like((DataType)dataType));
    }

    private void assertVariableDataType(CoreEvent event, DataType dataType) {
        DataType actualDataType = ((TypedValue)event.getVariables().get(TEST_PROPERTY)).getDataType();
        MatcherAssert.assertThat((Object)actualDataType, (Matcher)DataTypeMatcher.like((DataType)dataType));
    }

    private void assertSessionVariableDataType(CoreEvent event, DataType dataType) {
        DataType actualDataType = ((PrivilegedEvent)event).getSession().getPropertyDataType(TEST_PROPERTY);
        MatcherAssert.assertThat((Object)actualDataType, (Matcher)DataTypeMatcher.like((DataType)dataType));
    }
}

