/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.UUID;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.DefaultPolicyStateHandler;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.message.StringAttributes;
import org.mule.tck.util.MuleContextUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class AbstractPolicyProcessorTestCase
extends AbstractMuleTestCase {
    private static final String PAYLOAD = "payload";
    protected static final Message MESSAGE = Message.builder().value((Object)"payload").attributesValue((Object)new StringAttributes()).build();
    private static final String INIT_VAR_NAME = "initVarName";
    private static final String INIT_VAR_VALUE = "initVarValue";
    private static final String ADDED_VAR_NAME = "addedVarName";
    private static final String ADDED_VAR_VALUE = "addedVarValue";
    private MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    protected Policy policy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    protected Processor flowProcessor = (Processor)Mockito.mock(Processor.class);
    protected PolicyStateHandler policyStateHandler;
    protected CoreEvent initialEvent;
    protected String executionId;
    protected Processor policyProcessor;
    protected ArgumentCaptor<Publisher> eventCaptor = ArgumentCaptor.forClass(Publisher.class);
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    @Before
    public void before() {
        Mockito.when((Object)this.mockFlowConstruct.getMuleContext()).thenReturn((Object)this.muleContext);
        this.executionId = UUID.randomUUID().toString();
        this.initialEvent = this.createTestEvent();
        this.policyStateHandler = new DefaultPolicyStateHandler();
        this.policyProcessor = this.getProcessor();
    }

    protected abstract Processor getProcessor();

    @Test
    public void variablesAddedInNextProcessorNotPropagated() throws MuleException {
        CoreEvent initialEventWithVars = CoreEvent.builder((CoreEvent)this.initialEvent).addVariable(INIT_VAR_NAME, (Object)INIT_VAR_VALUE).build();
        CoreEvent modifiedVarsEvent = CoreEvent.builder((CoreEvent)this.initialEvent).addVariable(ADDED_VAR_NAME, (Object)ADDED_VAR_VALUE).build();
        Mockito.when((Object)this.flowProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)modifiedVarsEvent));
        Mockito.when((Object)this.policy.getPolicyChain().apply((Publisher)Matchers.any())).thenAnswer(invocation -> Mono.just((Object)initialEventWithVars).transform((Function)this.policyStateHandler.retrieveNextOperation(this.executionId)));
        CoreEvent resultEvent = (CoreEvent)Mono.just((Object)initialEventWithVars).transform((Function)this.policyProcessor).block();
        Assert.assertEquals(resultEvent.getVariables().keySet(), initialEventWithVars.getVariables().keySet());
    }

    @Test
    public void variablesAddedBeforeNextProcessorNotPropagatedToIt() throws MuleException {
        CoreEvent initialEventWithVars = CoreEvent.builder((CoreEvent)this.initialEvent).addVariable(INIT_VAR_NAME, (Object)INIT_VAR_VALUE).build();
        CoreEvent modifiedVarsEvent = CoreEvent.builder((CoreEvent)this.initialEvent).addVariable(ADDED_VAR_NAME, (Object)ADDED_VAR_VALUE).build();
        Mockito.when((Object)this.flowProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)initialEventWithVars));
        Mockito.when((Object)this.policy.getPolicyChain().apply((Publisher)Matchers.any())).thenAnswer(invocation -> Mono.just((Object)modifiedVarsEvent).transform((Function)this.policyStateHandler.retrieveNextOperation(this.executionId)));
        Mono.just((Object)initialEventWithVars).transform((Function)this.policyProcessor).block();
        ((Processor)Mockito.verify((Object)this.flowProcessor)).apply((Publisher)this.eventCaptor.capture());
        Assert.assertEquals(((CoreEvent)Mono.from((Publisher)((Publisher)this.eventCaptor.getValue())).block()).getVariables().keySet(), initialEventWithVars.getVariables().keySet());
    }

    @Test
    public void messageModifiedByNextProcessorIsPropagated() throws MuleException {
        CoreEvent modifiedMessageEvent = CoreEvent.builder((CoreEvent)this.initialEvent).message(MESSAGE).build();
        Mockito.when((Object)this.flowProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)modifiedMessageEvent));
        Mockito.when((Object)this.policy.getPolicyChain().apply((Publisher)Matchers.any())).thenAnswer(invocation -> Mono.just((Object)this.initialEvent).transform((Function)this.policyStateHandler.retrieveNextOperation(this.executionId)));
        CoreEvent resultEvent = (CoreEvent)Mono.just((Object)this.initialEvent).transform((Function)this.policyProcessor).block();
        Assert.assertEquals((Object)resultEvent.getMessage(), (Object)MESSAGE);
    }

    @Test
    public void messageModifiedBeforeNextProcessorIsPropagatedToIt() throws MuleException {
        CoreEvent modifiedMessageEvent = CoreEvent.builder((CoreEvent)this.initialEvent).message(MESSAGE).build();
        Mockito.when((Object)this.flowProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)modifiedMessageEvent));
        Mockito.when((Object)this.policy.getPolicyChain().isPropagateMessageTransformations()).thenReturn((Object)true);
        Mockito.when((Object)this.policy.getPolicyChain().apply((Publisher)Matchers.any())).thenAnswer(invocation -> Mono.just((Object)modifiedMessageEvent).transform((Function)this.policyStateHandler.retrieveNextOperation(this.executionId)));
        Mono.just((Object)this.initialEvent).transform((Function)this.policyProcessor).block();
        ((Processor)Mockito.verify((Object)this.flowProcessor)).apply((Publisher)this.eventCaptor.capture());
        Assert.assertEquals((Object)((CoreEvent)Mono.from((Publisher)((Publisher)this.eventCaptor.getValue())).block()).getMessage(), (Object)MESSAGE);
    }

    @Test
    public void sessionModifiedByNextProcessorIsPropagated() throws MuleException {
        DefaultMuleSession session = new DefaultMuleSession();
        PrivilegedEvent modifiedSessionEvent = PrivilegedEvent.builder((CoreEvent)this.initialEvent).session((MuleSession)session).build();
        Mockito.when((Object)this.flowProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)modifiedSessionEvent));
        Mockito.when((Object)this.policy.getPolicyChain().apply((Publisher)Matchers.any())).thenAnswer(invocation -> Mono.just((Object)this.initialEvent).transform((Function)this.policyStateHandler.retrieveNextOperation(this.executionId)));
        CoreEvent resultEvent = (CoreEvent)Mono.just((Object)this.initialEvent).transform((Function)this.policyProcessor).block();
        Assert.assertEquals((Object)((PrivilegedEvent)resultEvent).getSession(), (Object)session);
    }

    @Test
    public void sessionModifiedBeforeNextProcessorIsPropagatedToIt() throws MuleException {
        DefaultMuleSession session = new DefaultMuleSession();
        PrivilegedEvent modifiedSessionEvent = PrivilegedEvent.builder((CoreEvent)this.initialEvent).session((MuleSession)session).build();
        Mockito.when((Object)this.flowProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)modifiedSessionEvent));
        Mockito.when((Object)this.policy.getPolicyChain().apply((Publisher)Matchers.any())).thenAnswer(arg_0 -> this.lambda$sessionModifiedBeforeNextProcessorIsPropagatedToIt$5((CoreEvent)modifiedSessionEvent, arg_0));
        Mono.just((Object)this.initialEvent).transform((Function)this.policyProcessor).block();
        ((Processor)Mockito.verify((Object)this.flowProcessor)).apply((Publisher)this.eventCaptor.capture());
        Assert.assertEquals((Object)((PrivilegedEvent)Mono.from((Publisher)((Publisher)this.eventCaptor.getValue())).block()).getSession(), (Object)session);
    }

    private CoreEvent createTestEvent() {
        Mockito.when((Object)this.mockFlowConstruct.getUniqueIdString()).thenReturn((Object)this.executionId);
        return CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.mockFlowConstruct, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"http"))).message(Message.builder().nullValue().build()).build();
    }

    private /* synthetic */ Object lambda$sessionModifiedBeforeNextProcessorIsPropagatedToIt$5(CoreEvent modifiedSessionEvent, InvocationOnMock invocation) throws Throwable {
        return Mono.just((Object)modifiedSessionEvent).transform((Function)this.policyStateHandler.retrieveNextOperation(this.executionId));
    }
}

