/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.policy.CompositeOperationPolicy;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CompositeOperationPolicyTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private CompositeOperationPolicy compositeOperationPolicy;
    private Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer = Optional.of(Mockito.mock(OperationPolicyParametersTransformer.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
    private OperationParametersProcessor operationParametersProcessor = (OperationParametersProcessor)Mockito.mock(OperationParametersProcessor.class);
    private Policy firstPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Policy secondPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private CoreEvent initialEvent;
    private CoreEvent firstPolicyProcessorResultEvent;
    private CoreEvent secondPolicyResultProcessorEvent;
    private OperationExecutionFunction operationExecutionFunction = (OperationExecutionFunction)Mockito.mock(OperationExecutionFunction.class);
    private CoreEvent nextProcessResultEvent;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory = (OperationPolicyProcessorFactory)Mockito.mock(OperationPolicyProcessorFactory.class);
    private Processor firstPolicyOperationPolicyProcessor = (Processor)Mockito.mock(Processor.class);
    private Processor secondPolicyOperationPolicyProcessor = (Processor)Mockito.mock(Processor.class);
    private StreamingManager streamingManager = (StreamingManager)Mockito.mock(StreamingManager.class);

    @Before
    public void setUp() throws Exception {
        this.initialEvent = this.createTestEvent();
        this.firstPolicyProcessorResultEvent = this.createTestEvent();
        this.secondPolicyResultProcessorEvent = this.createTestEvent();
        this.nextProcessResultEvent = CoreEvent.builder((CoreEvent)this.createTestEvent()).message(Message.of((Object)"HELLO")).build();
        Mockito.when((Object)this.operationPolicyParametersTransformer.get().fromParametersToMessage((Map)Matchers.any())).thenReturn((Object)Message.of(null));
        Mockito.when((Object)this.operationExecutionFunction.execute((Map)Matchers.any(), (CoreEvent)Matchers.any())).thenAnswer(invocationOnMock -> Mono.just((Object)this.nextProcessResultEvent));
        Mockito.when((Object)this.firstPolicy.getPolicyChain().apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)this.firstPolicyProcessorResultEvent));
        Mockito.when((Object)this.secondPolicy.getPolicyChain().apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)this.secondPolicyResultProcessorEvent));
        Mockito.when((Object)this.operationPolicyProcessorFactory.createOperationPolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any())).thenReturn((Object)this.secondPolicyOperationPolicyProcessor);
        Mockito.when((Object)this.operationPolicyProcessorFactory.createOperationPolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.firstPolicyOperationPolicyProcessor.apply((Publisher)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                Mono.just((Object)this.initialEvent).transform((Function)((Processor)policyFactoryInvocation.getArguments()[1])).block();
                return Mono.just((Object)this.firstPolicyProcessorResultEvent);
            });
            return this.firstPolicyOperationPolicyProcessor;
        });
        Mockito.when((Object)this.operationPolicyProcessorFactory.createOperationPolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.secondPolicyOperationPolicyProcessor.apply((Publisher)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                Mono.just((Object)this.initialEvent).transform((Function)((Processor)policyFactoryInvocation.getArguments()[1])).block();
                return Mono.just((Object)this.secondPolicyResultProcessorEvent);
            });
            return this.secondPolicyOperationPolicyProcessor;
        });
    }

    @Test
    public void singlePolicy() throws Exception {
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction, this.streamingManager);
        CoreEvent result = (CoreEvent)Mono.from((Publisher)this.compositeOperationPolicy.process(this.initialEvent)).doOnNext(event1 -> System.out.println("FINAL " + event1.getMessage().getPayload().getValue())).block();
        Assert.assertThat((Object)result.getMessage(), (Matcher)Is.is((Object)this.nextProcessResultEvent.getMessage()));
        ((OperationExecutionFunction)Mockito.verify((Object)this.operationExecutionFunction)).execute((Map)Matchers.any(), (CoreEvent)Matchers.same((Object)this.initialEvent));
        ((OperationPolicyProcessorFactory)Mockito.verify((Object)this.operationPolicyProcessorFactory)).createOperationPolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicyOperationPolicyProcessor)).apply((Publisher)Matchers.any());
    }

    @Test
    public void compositePolicy() throws Exception {
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction, this.streamingManager);
        CoreEvent result = (CoreEvent)Mono.from((Publisher)this.compositeOperationPolicy.process(this.initialEvent)).block();
        Assert.assertThat((Object)result.getMessage(), (Matcher)Is.is((Object)this.nextProcessResultEvent.getMessage()));
        ((OperationExecutionFunction)Mockito.verify((Object)this.operationExecutionFunction)).execute((Map)Matchers.any(), (CoreEvent)Matchers.same((Object)this.initialEvent));
        ((OperationPolicyProcessorFactory)Mockito.verify((Object)this.operationPolicyProcessorFactory)).createOperationPolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((OperationPolicyProcessorFactory)Mockito.verify((Object)this.operationPolicyProcessorFactory)).createOperationPolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicyOperationPolicyProcessor)).apply((Publisher)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicyOperationPolicyProcessor)).apply((Publisher)Matchers.any());
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyPolicyList() throws Exception {
        this.compositeOperationPolicy = new CompositeOperationPolicy(Collections.emptyList(), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction, this.streamingManager);
    }

    @Test
    public void policyExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.when((Object)this.operationPolicyProcessorFactory.createOperationPolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.firstPolicyOperationPolicyProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.error((Throwable)policyException));
            return this.firstPolicyOperationPolicyProcessor;
        });
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction, this.streamingManager);
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectCause(Is.is((Object)policyException));
        try {
            Mono.from((Publisher)this.compositeOperationPolicy.process(this.initialEvent)).block();
        }
        catch (Throwable throwable) {
            throw Exceptions.rxExceptionToMuleException((Throwable)throwable);
        }
    }

    @Test
    public void nextProcessorExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.when((Object)this.operationExecutionFunction.execute((Map)Matchers.any(), (CoreEvent)Matchers.any())).thenReturn((Object)Mono.error((Throwable)policyException));
        this.compositeOperationPolicy = new CompositeOperationPolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.operationPolicyParametersTransformer, this.operationPolicyProcessorFactory, this.operationParametersProcessor, this.operationExecutionFunction, this.streamingManager);
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectCause(Is.is((Object)policyException));
        try {
            Mono.from((Publisher)this.compositeOperationPolicy.process(this.initialEvent)).block();
        }
        catch (Throwable throwable) {
            throw Exceptions.rxExceptionToMuleException((Throwable)throwable);
        }
    }

    private CoreEvent createTestEvent() {
        return CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.mockFlowConstruct, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"http"))).message(Message.of(null)).build();
    }
}

