/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.CompositeSourcePolicy;
import org.mule.runtime.core.internal.policy.FlowExecutionException;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CompositeSourcePolicyTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private CompositeSourcePolicy compositeSourcePolicy;
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer = Optional.of(Mockito.mock(SourcePolicyParametersTransformer.class));
    private MessageSourceResponseParametersProcessor sourceParametersTransformer = (MessageSourceResponseParametersProcessor)Mockito.mock(MessageSourceResponseParametersProcessor.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Policy firstPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Policy secondPolicy = (Policy)Mockito.mock(Policy.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private CoreEvent initialEvent;
    private CoreEvent modifiedEvent;
    private CoreEvent firstPolicyResultEvent;
    private CoreEvent secondPolicyResultEvent;
    private Processor flowExecutionProcessor = (Processor)Mockito.mock(Processor.class);
    private CoreEvent nextProcessResultEvent = (CoreEvent)Mockito.mock(CoreEvent.class);
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory = (SourcePolicyProcessorFactory)Mockito.mock(SourcePolicyProcessorFactory.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private Processor firstPolicySourcePolicyProcessor = (Processor)Mockito.mock(Processor.class);
    private Processor secondPolicySourcePolicyProcessor = (Processor)Mockito.mock(Processor.class);
    private ArgumentCaptor<Publisher> publisherArgumentCaptor = ArgumentCaptor.forClass(Publisher.class);

    @Before
    public void setUp() throws Exception {
        this.initialEvent = this.createTestEvent();
        this.modifiedEvent = this.createTestEvent();
        this.firstPolicyResultEvent = this.createTestEvent();
        this.secondPolicyResultEvent = this.createTestEvent();
        Mockito.when((Object)this.nextProcessResultEvent.getMessage()).thenReturn(Mockito.mock(Message.class));
        Mockito.when((Object)this.flowExecutionProcessor.apply((Publisher)Matchers.any())).thenAnswer(invocation -> {
            Mono mono = Mono.from((Publisher)((Publisher)invocation.getArgumentAt(0, Publisher.class)));
            return mono.doOnNext(event -> ((BaseEventContext)event.getContext()).success(event));
        });
        Mockito.when((Object)this.firstPolicy.getPolicyChain().apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)this.firstPolicyResultEvent));
        Mockito.when((Object)this.secondPolicy.getPolicyChain().apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)this.secondPolicyResultEvent));
        Mockito.when((Object)this.sourcePolicyProcessorFactory.createSourcePolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.firstPolicySourcePolicyProcessor.apply((Publisher)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                Mono.just((Object)this.modifiedEvent).transform((Function)((Processor)policyFactoryInvocation.getArguments()[1])).block();
                return Mono.just((Object)this.firstPolicyResultEvent);
            });
            return this.firstPolicySourcePolicyProcessor;
        });
        Mockito.when((Object)this.sourcePolicyProcessorFactory.createSourcePolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.secondPolicySourcePolicyProcessor.apply((Publisher)Matchers.any())).thenAnswer(policyProcessorInvocation -> {
                Mono.just((Object)this.modifiedEvent).transform((Function)((Processor)policyFactoryInvocation.getArguments()[1])).block();
                return Mono.just((Object)this.secondPolicyResultEvent);
            });
            return this.secondPolicySourcePolicyProcessor;
        });
    }

    @Test
    public void singlePolicy() throws Exception {
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        Either sourcePolicyResult = (Either)Mono.from((Publisher)this.compositeSourcePolicy.process(this.initialEvent)).block();
        Assert.assertThat((Object)sourcePolicyResult.isRight(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SourcePolicySuccessResult)sourcePolicyResult.getRight()).getResult().getMessage(), (Matcher)Is.is((Object)this.firstPolicyResultEvent.getMessage()));
        ((Processor)Mockito.verify((Object)this.flowExecutionProcessor)).apply((Publisher)this.publisherArgumentCaptor.capture());
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)((Publisher)this.publisherArgumentCaptor.getValue())).block()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.modifiedEvent.getMessage()));
        ((SourcePolicyProcessorFactory)Mockito.verify((Object)this.sourcePolicyProcessorFactory)).createSourcePolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicySourcePolicyProcessor)).apply((Publisher)this.publisherArgumentCaptor.capture());
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)((Publisher)this.publisherArgumentCaptor.getValue())).block()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.initialEvent.getMessage()));
    }

    @Test
    public void compositePolicy() throws Exception {
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        Either sourcePolicyResult = (Either)Mono.from((Publisher)this.compositeSourcePolicy.process(this.initialEvent)).block();
        Assert.assertThat((Object)sourcePolicyResult.isRight(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SourcePolicySuccessResult)sourcePolicyResult.getRight()).getResult().getMessage(), (Matcher)Is.is((Object)this.firstPolicyResultEvent.getMessage()));
        ((Processor)Mockito.verify((Object)this.flowExecutionProcessor)).apply((Publisher)this.publisherArgumentCaptor.capture());
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)((Publisher)this.publisherArgumentCaptor.getValue())).block()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.modifiedEvent.getMessage()));
        ((SourcePolicyProcessorFactory)Mockito.verify((Object)this.sourcePolicyProcessorFactory)).createSourcePolicy((Policy)Matchers.same((Object)this.firstPolicy), (Processor)Matchers.any());
        ((SourcePolicyProcessorFactory)Mockito.verify((Object)this.sourcePolicyProcessorFactory)).createSourcePolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any());
        ((Processor)Mockito.verify((Object)this.firstPolicySourcePolicyProcessor)).apply((Publisher)this.publisherArgumentCaptor.capture());
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)((Publisher)this.publisherArgumentCaptor.getValue())).block()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.initialEvent.getMessage()));
        ((Processor)Mockito.verify((Object)this.secondPolicySourcePolicyProcessor)).apply((Publisher)this.publisherArgumentCaptor.capture());
        Assert.assertThat((Object)((CoreEvent)Mono.from((Publisher)((Publisher)this.publisherArgumentCaptor.getValue())).block()).getMessage(), (Matcher)CoreMatchers.equalTo((Object)this.modifiedEvent.getMessage()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyPolicyList() throws Exception {
        this.compositeSourcePolicy = new CompositeSourcePolicy(Collections.emptyList(), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
    }

    @Test
    public void policyExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.when((Object)this.sourcePolicyProcessorFactory.createSourcePolicy((Policy)Matchers.same((Object)this.secondPolicy), (Processor)Matchers.any())).thenAnswer(policyFactoryInvocation -> {
            Mockito.when((Object)this.secondPolicySourcePolicyProcessor.apply((Publisher)Matchers.any(Publisher.class))).thenReturn((Object)Mono.error((Throwable)policyException));
            return this.secondPolicySourcePolicyProcessor;
        });
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        Either sourcePolicyResult = (Either)Mono.from((Publisher)this.compositeSourcePolicy.process(this.initialEvent)).block();
        Assert.assertThat((Object)sourcePolicyResult.isLeft(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SourcePolicyFailureResult)sourcePolicyResult.getLeft()).getMessagingException().getCause().getCause(), (Matcher)Is.is((Object)policyException));
    }

    @Test
    public void nextProcessorExecutionFailurePropagates() throws Exception {
        RuntimeException policyException = new RuntimeException("policy failure");
        Mockito.reset((Object[])new Processor[]{this.flowExecutionProcessor});
        Mockito.when((Object)this.flowExecutionProcessor.apply((Publisher)Matchers.any())).thenAnswer(invocation -> {
            Mono mono = Mono.from((Publisher)((Publisher)invocation.getArgumentAt(0, Publisher.class)));
            mono.doOnNext(event -> ((BaseEventContext)event.getContext()).error((Throwable)new MessagingException(event, (Throwable)policyException))).subscribe();
            return Mono.empty();
        });
        this.compositeSourcePolicy = new CompositeSourcePolicy(Arrays.asList(this.firstPolicy, this.secondPolicy), this.sourcePolicyParametersTransformer, this.sourcePolicyProcessorFactory, this.flowExecutionProcessor, this.sourceParametersTransformer);
        Either sourcePolicyResult = (Either)Mono.from((Publisher)this.compositeSourcePolicy.process(this.initialEvent)).block();
        Assert.assertThat((Object)sourcePolicyResult.isLeft(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((SourcePolicyFailureResult)sourcePolicyResult.getLeft()).getMessagingException(), (Matcher)CoreMatchers.instanceOf(FlowExecutionException.class));
        Assert.assertThat((Object)((SourcePolicyFailureResult)sourcePolicyResult.getLeft()).getMessagingException().getCause(), (Matcher)Is.is((Object)policyException));
    }

    private CoreEvent createTestEvent() {
        return CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.mockFlowConstruct, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)"http"))).message(Message.builder().nullValue().build()).build();
    }
}

