/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.BiConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.DefaultPolicyStateHandler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultPolicyStateHandlerTestCase
extends AbstractMuleTestCase {
    private static final String TEST_EXECUTION_ID = "test-id";
    private static final String TEST_EXECUTION_ID2 = "test-id2";
    private static final String TEST_POLICY_ID = "test-policy-id";
    private static final String TEST_POLICY_ID2 = "test-policy-id2";
    private InternalEvent eventTestExecutionId = (InternalEvent)Mockito.mock(InternalEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private InternalEvent eventTestExecutionId2 = (InternalEvent)Mockito.mock(InternalEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private DefaultPolicyStateHandler defaultPolicyStateHandler = new DefaultPolicyStateHandler();

    @Test
    public void destroyStateWithNoData() {
        this.defaultPolicyStateHandler.destroyState(TEST_EXECUTION_ID);
    }

    @Test
    public void samePolicyDifferentExecutionId() {
        PolicyStateId policyStateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID);
        PolicyStateId policyStateExecutionId2 = new PolicyStateId(TEST_EXECUTION_ID2, TEST_POLICY_ID);
        this.defaultPolicyStateHandler.updateState(policyStateExecutionId, (CoreEvent)this.eventTestExecutionId);
        this.defaultPolicyStateHandler.updateState(policyStateExecutionId2, (CoreEvent)this.eventTestExecutionId2);
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policyStateExecutionId).get(), (Matcher)Is.is((Object)this.eventTestExecutionId));
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policyStateExecutionId2).get(), (Matcher)Is.is((Object)this.eventTestExecutionId2));
    }

    @Test
    public void sameExecutionDifferentPolicyId() {
        PolicyStateId policy1StateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID);
        PolicyStateId policy2StateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID2);
        this.defaultPolicyStateHandler.updateState(policy1StateExecutionId, (CoreEvent)this.eventTestExecutionId);
        this.defaultPolicyStateHandler.updateState(policy2StateExecutionId, (CoreEvent)this.eventTestExecutionId2);
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policy1StateExecutionId).get(), (Matcher)Is.is((Object)this.eventTestExecutionId));
        Assert.assertThat(this.defaultPolicyStateHandler.getLatestState(policy2StateExecutionId).get(), (Matcher)Is.is((Object)this.eventTestExecutionId2));
    }

    @Test
    public void destroyState() {
        PolicyStateId policyStateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID);
        this.defaultPolicyStateHandler.destroyState(policyStateExecutionId.getExecutionIdentifier());
        Assert.assertThat((Object)this.defaultPolicyStateHandler.getLatestState(policyStateExecutionId).isPresent(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.defaultPolicyStateHandler.retrieveNextOperation(policyStateExecutionId.getExecutionIdentifier()), (Matcher)IsNull.nullValue());
    }

    @Test
    public void destroyStateWhenEventIsCompleted() {
        PolicyStateId policyStateExecutionId = new PolicyStateId(TEST_EXECUTION_ID, TEST_POLICY_ID);
        Reference subscriberReference = new Reference();
        BaseEventContext rootEventContext = this.eventTestExecutionId.getContext().getRootContext();
        ((BaseEventContext)Mockito.doAnswer(invocationOnMock -> {
            subscriberReference.set((Object)((BiConsumer)invocationOnMock.getArguments()[0]));
            return null;
        }).when((Object)rootEventContext)).onTerminated((BiConsumer)Matchers.any(BiConsumer.class));
        this.defaultPolicyStateHandler.updateState(policyStateExecutionId, (CoreEvent)this.eventTestExecutionId);
        ((BiConsumer)subscriberReference.get()).accept(null, null);
        Assert.assertThat((Object)this.defaultPolicyStateHandler.getLatestState(policyStateExecutionId).isPresent(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.defaultPolicyStateHandler.policyStateIdsByExecutionIdentifier.containsKey((Object)policyStateExecutionId.getExecutionIdentifier()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.defaultPolicyStateHandler.nextOperationMap.containsKey(policyStateExecutionId.getExecutionIdentifier()), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.defaultPolicyStateHandler.stateMap.containsKey(policyStateExecutionId), (Matcher)Is.is((Object)false));
    }
}

