/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.AbstractPolicyProcessorTestCase;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SourcePolicyProcessorTestCase
extends AbstractPolicyProcessorTestCase {
    @Override
    protected Processor getProcessor() {
        return new SourcePolicyProcessor(this.policy, this.policyStateHandler, this.flowProcessor);
    }

    @Test
    public void messageModifiedBeforeNextProcessorIsNotPropagatedToItWhenPropagationDisabled() throws MuleException {
        CoreEvent modifiedMessageEvent = CoreEvent.builder((CoreEvent)this.initialEvent).message(MESSAGE).build();
        Mockito.when((Object)this.flowProcessor.apply((Publisher)Matchers.any())).thenReturn((Object)Mono.just((Object)modifiedMessageEvent));
        Mockito.when((Object)this.policy.getPolicyChain().isPropagateMessageTransformations()).thenReturn((Object)false);
        Mockito.when((Object)this.policy.getPolicyChain().apply((Publisher)Matchers.any())).thenAnswer(invocation -> Mono.just((Object)modifiedMessageEvent).transform((Function)this.policyStateHandler.retrieveNextOperation(this.executionId)));
        Mono.just((Object)this.initialEvent).transform((Function)this.policyProcessor).block();
        ((Processor)Mockito.verify((Object)this.flowProcessor)).apply((Publisher)this.eventCaptor.capture());
        Assert.assertEquals((Object)((CoreEvent)Mono.from((Publisher)((Publisher)this.eventCaptor.getValue())).block()).getMessage(), (Object)this.initialEvent.getMessage());
    }
}

