/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.beans.ExceptionListener;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;

public class AsyncDelegateMessageProcessorTestCase
extends AbstractReactiveProcessorTestCase
implements ExceptionListener {
    private AsyncDelegateMessageProcessor messageProcessor;
    protected TestListener target = new TestListener();
    private Exception exceptionThrown;
    protected Latch latch = new Latch();
    private Latch asyncEntryLatch = new Latch();
    private Flow flow;
    @Rule
    public ExpectedException expected;

    public AsyncDelegateMessageProcessorTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
        this.setStartContext(true);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.componentLocator);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.flow = MuleTestUtils.createAndRegisterFlow((MuleContext)muleContext, (String)"appleFlow", (ConfigurationComponentLocator)this.componentLocator);
        this.messageProcessor = this.createAsyncDelegateMessageProcessor(this.target, (FlowConstruct)this.flow);
        this.messageProcessor.start();
    }

    protected void doTearDown() throws Exception {
        this.messageProcessor.stop();
        this.messageProcessor.dispose();
        super.doTearDown();
    }

    @Test
    public void process() throws Exception {
        CoreEvent request = this.testEvent();
        CoreEvent result = this.process((Processor)this.messageProcessor, request);
        ((BaseEventContext)request.getContext()).success(result);
        Assert.assertThat((Object)((BaseEventContext)request.getContext()).isTerminated(), (Matcher)CoreMatchers.is((Object)false));
        this.asyncEntryLatch.countDown();
        Assert.assertThat((Object)this.latch.await(30000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        while (!((BaseEventContext)this.target.sensedEvent.getContext()).isTerminated()) {
            this.park100ns();
        }
        Assert.assertThat((Object)this.target.sensedEvent, (Matcher)CoreMatchers.notNullValue());
        while (!((BaseEventContext)request.getContext()).isTerminated()) {
            this.park100ns();
        }
        Assert.assertThat((Object)((BaseEventContext)this.target.sensedEvent.getContext()).isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((BaseEventContext)request.getContext()).isTerminated(), (Matcher)CoreMatchers.is((Object)true));
        this.assertTargetEvent(request);
        this.assertResponse(result);
    }

    private void park100ns() {
        LockSupport.parkNanos(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void processWithTx() throws Exception {
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            CoreEvent request = this.testEvent();
            CoreEvent result = this.process((Processor)this.messageProcessor, request);
            this.asyncEntryLatch.countDown();
            Assert.assertThat((Object)this.latch.await(30000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
            this.assertTargetEvent(request);
            this.assertResponse(result);
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    @Test
    public void processWithBlockingProcessingStrategy() throws Exception {
        this.flow.dispose();
        this.flow = Flow.builder((String)"flow", (MuleContext)muleContext).processingStrategyFactory((ProcessingStrategyFactory)new BlockingProcessingStrategyFactory()).build();
        this.flow.initialise();
        this.flow.start();
        this.process();
    }

    @Test
    public void processWithDirectProcessingStrategy() throws Exception {
        this.flow.dispose();
        this.flow = Flow.builder((String)"flow", (MuleContext)muleContext).processingStrategyFactory((ProcessingStrategyFactory)new DirectProcessingStrategyFactory()).build();
        this.flow.initialise();
        this.flow.start();
        this.process();
    }

    private void assertTargetEvent(CoreEvent request) {
        Assert.assertNotNull((Object)this.target.sensedEvent);
        Assert.assertThat((Object)request, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)this.target.sensedEvent)));
        Assert.assertThat((Object)request.getCorrelationId(), (Matcher)CoreMatchers.equalTo((Object)this.target.sensedEvent.getCorrelationId()));
        Assert.assertThat((Object)request.getMessage(), (Matcher)CoreMatchers.sameInstance((Object)this.target.sensedEvent.getMessage()));
        Assert.assertThat((Object)this.target.thread, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)Thread.currentThread())));
    }

    private void assertResponse(CoreEvent result) throws MuleException {
        Assert.assertThat((Object)this.testEvent(), (Matcher)CoreMatchers.sameInstance((Object)result));
        Assert.assertThat((Object)this.exceptionThrown, (Matcher)CoreMatchers.nullValue());
    }

    private AsyncDelegateMessageProcessor createAsyncDelegateMessageProcessor(Processor listener, FlowConstruct flowConstruct) throws Exception {
        AsyncDelegateMessageProcessor mp = new AsyncDelegateMessageProcessor(MessageProcessors.newChain(Optional.of(flowConstruct.getProcessingStrategy()), (Processor[])new Processor[]{listener}), "thread");
        mp.setAnnotations(AsyncDelegateMessageProcessorTestCase.getAppleFlowComponentLocationAnnotations());
        LifecycleUtils.initialiseIfNeeded((Object)mp, (boolean)true, (MuleContext)muleContext);
        return mp;
    }

    @Override
    public void exceptionThrown(Exception e) {
        this.exceptionThrown = e;
    }

    class TestListener
    implements Processor {
        CoreEvent sensedEvent;
        Thread thread;

        TestListener() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            try {
                AsyncDelegateMessageProcessorTestCase.this.asyncEntryLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.sensedEvent = event;
            this.thread = Thread.currentThread();
            AsyncDelegateMessageProcessorTestCase.this.latch.countDown();
            return event;
        }
    }
}

