/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.InvokerMessageProcessor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class InvokerMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private InvokerMessageProcessor invoker;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.invoker = new InvokerMessageProcessor();
        this.invoker.setObject((Object)new TestInvokeObject());
        this.invoker.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        this.invoker.setMuleContext(muleContext);
    }

    @Test
    public void testMethodWithNoArgs() throws MuleException, Exception {
        this.invoker.setMethodName("testNoArgs");
        this.invoker.initialise();
        this.invoker.process(this.testEvent());
    }

    @Test
    public void testMethodFound() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod");
        this.invoker.setArgumentExpressionsString("#[mel:'1'],#[mel:'2'],#[mel:'3'],#[mel:'4'],#[mel:'5'],#[mel:'6'],#[mel:'7'],#[mel:'8'],#[mel:'true'],#[mel:'true'],#[mel:'1']");
        this.invoker.initialise();
        this.invoker.process(this.testEvent());
    }

    @Test
    public void testMethodFoundNestedExpression() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("#[mel:#[mel:'1']]");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1 echo", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    @Test
    public void testMethodFoundParseStringWithExpressions() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("1-#[mel:#[mel:'2']]-3");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1-2-3 echo", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    @Test
    public void testMethodFoundParseStringNoExpressions() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("1");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1 echo", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    @Test
    public void testMethodFoundNullArgument() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArguments(Collections.singletonList(null));
        this.invoker.initialise();
        Assert.assertEquals((Object)"null echo", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    @Test
    public void testMethodNameNotFound() throws MuleException, Exception {
        this.invoker.setMethodName("testMethodNotHere");
        this.invoker.setArgumentExpressionsString("#[mel:'1']");
        try {
            this.invoker.initialise();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals(InitialisationException.class, e.getClass());
        }
    }

    @Test
    public void testMethodWithArgsNotFound() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod");
        this.invoker.setArgumentExpressionsString("#[mel:'1']");
        try {
            this.invoker.initialise();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals(InitialisationException.class, e.getClass());
        }
    }

    @Test
    public void testMethodWithArgTypes() throws MuleException, Exception {
        this.invoker.setMethodName("testDuplicateNameMethod");
        this.invoker.setArgumentExpressionsString("#[mel:'1'], #[mel:'2']");
        this.invoker.setArgumentTypes(new Class[]{String.class, Integer.TYPE});
        this.invoker.initialise();
        Assert.assertEquals((Object)"12(string and int)", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    @Test
    public void testMethodWithPrimitiveArgTypes() throws MuleException, Exception {
        this.invoker.setMethodName("testDuplicateNameMethod");
        this.invoker.setArgumentTypes(new Class[]{String.class, Integer.class});
        this.invoker.setArguments(Arrays.asList("some String", 42));
        this.invoker.initialise();
        Assert.assertEquals((Object)"some String42(string and int)", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    @Test
    public void testCantTransform() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod2");
        this.invoker.setArgumentExpressionsString("#[mel:'1']");
        this.invoker.initialise();
        try {
            this.invoker.process(this.testEvent());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals(MessagingException.class, e.getClass());
            Assert.assertEquals(TransformerException.class, e.getCause().getClass());
        }
    }

    @Test
    public void testReplacePayload() throws MuleException, Exception {
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("#[mel:payload:]");
        this.invoker.initialise();
        Assert.assertEquals((Object)"test echo", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    @Test
    public void testArrayArg() throws MuleException, Exception {
        this.invoker.setMethodName("testArrayArg");
        this.invoker.setArguments(Collections.singletonList(new String[]{"#[mel:'1']", "#[mel:'2']"}));
        this.invoker.initialise();
        CoreEvent result = this.invoker.process(this.testEvent());
        Assert.assertEquals(String[].class, (Object)result.getMessage().getPayload().getDataType().getType());
        Assert.assertEquals((Object)"1", (Object)((String[])result.getMessage().getPayload().getValue())[0]);
        Assert.assertEquals((Object)"2", (Object)((String[])result.getMessage().getPayload().getValue())[1]);
    }

    @Test
    public void testListArg() throws MuleException, Exception {
        this.invoker.setMethodName("testListArg");
        this.invoker.setArguments(Collections.singletonList(Collections.singletonList("#[mel:'1']")));
        this.invoker.initialise();
        CoreEvent result = this.invoker.process(this.testEvent());
        Assert.assertTrue((boolean)List.class.isAssignableFrom(result.getMessage().getPayload().getDataType().getType()));
        Assert.assertEquals((Object)"1", ((List)result.getMessage().getPayload().getValue()).get(0));
    }

    @Test
    public void testListNestedMapArg() throws MuleException, Exception {
        this.invoker.setMethodName("testListArg");
        this.invoker.setArguments(Collections.singletonList(Collections.singletonList(Collections.singletonMap("#[mel:'key']", "#[mel:'val']"))));
        this.invoker.initialise();
        CoreEvent result = this.invoker.process(this.testEvent());
        Assert.assertTrue((boolean)List.class.isAssignableFrom(result.getMessage().getPayload().getDataType().getType()));
        Assert.assertEquals((Object)"val", ((Map)((List)result.getMessage().getPayload().getValue()).get(0)).get("key"));
    }

    @Test
    public void testMapArg() throws MuleException, Exception {
        this.invoker.setMethodName("testMapArg");
        this.invoker.setArguments(Collections.singletonList(Collections.singletonMap("#[mel:'key']", "#[mel:'val']")));
        this.invoker.initialise();
        CoreEvent result = this.invoker.process(this.testEvent());
        Assert.assertTrue((boolean)Map.class.isAssignableFrom(result.getMessage().getPayload().getDataType().getType()));
        Assert.assertEquals((Object)"val", ((Map)result.getMessage().getPayload().getValue()).get("key"));
    }

    @Test
    public void testLookupClassInstance() throws MuleException, Exception {
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject("object", (Object)new TestInvokeObject());
        this.invoker = new InvokerMessageProcessor();
        this.invoker.setMuleContext(muleContext);
        this.invoker.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        this.invoker.setObjectType(TestInvokeObject.class);
        this.invoker.setMethodName("testMethod3");
        this.invoker.setArgumentExpressionsString("#[mel:'1']");
        this.invoker.initialise();
        Assert.assertEquals((Object)"1 echo", (Object)((PrivilegedEvent)this.invoker.process(this.testEvent())).getMessageAsString(muleContext));
    }

    private class TestInvokeObject {
        private TestInvokeObject() {
        }

        public void testMethod(Integer arg1, int arg2, Long arg3, long arg4, Double arg5, double arg6, Float arg7, float arg8, Boolean arg9, boolean arg10, String arg11) {
        }

        public void testNoArgs() {
        }

        public void testMethod2(Apple apple) {
        }

        public String testMethod3(String text) {
            return text + " echo";
        }

        public String testDuplicateNameMethod(String text, String text2) {
            return text + text2 + " (two strings)";
        }

        public String testDuplicateNameMethod(String text, int i) {
            return text + i + "(string and int)";
        }

        public String[] testArrayArg(String[] array) {
            return array;
        }

        public List<String> testListArg(List<String> list) {
            return list;
        }

        public Map<String, String> testMapArg(Map<String, String> map) {
            return map;
        }
    }
}

