/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.processor.LoggerMessageProcessor;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.slf4j.Logger;

public class LoggerMessageProcessorTestCase
extends AbstractMuleTestCase {
    private Flow flow;

    @Before
    public void before() throws RegistrationException {
        this.flow = Flow.builder((String)"flow", (MuleContext)MuleContextUtils.mockContextWithServices()).build();
        this.flow.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
    }

    @Test
    public void logNullEvent() {
        this.verifyNullEventByLevel("TRACE");
        this.verifyNullEventByLevel("DEBUG");
        this.verifyNullEventByLevel("INFO");
        this.verifyNullEventByLevel("WARN");
        this.verifyNullEventByLevel("ERROR");
    }

    @Test
    public void logMuleEvent() {
        this.verifyMuleEventByLevel("TRACE");
        this.verifyMuleEventByLevel("DEBUG");
        this.verifyMuleEventByLevel("INFO");
        this.verifyMuleEventByLevel("WARN");
        this.verifyMuleEventByLevel("ERROR");
    }

    @Test
    public void logWithMessage() {
        this.verifyLoggerMessageByLevel("TRACE");
        this.verifyLoggerMessageByLevel("DEBUG");
        this.verifyLoggerMessageByLevel("INFO");
        this.verifyLoggerMessageByLevel("WARN");
        this.verifyLoggerMessageByLevel("ERROR");
    }

    private void verifyLogCall(LoggerMessageProcessor loggerMessageProcessor, String logLevel, String enabledLevel, CoreEvent muleEvent, String message) {
        Mockito.when((Object)loggerMessageProcessor.logger.isTraceEnabled()).thenReturn((Object)"TRACE".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isDebugEnabled()).thenReturn((Object)"DEBUG".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isInfoEnabled()).thenReturn((Object)"INFO".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isWarnEnabled()).thenReturn((Object)"WARN".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isErrorEnabled()).thenReturn((Object)"ERROR".equals(enabledLevel));
        loggerMessageProcessor.log(muleEvent);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("TRACE".equals(enabledLevel) ? 1 : 0)))).trace(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("DEBUG".equals(enabledLevel) ? 1 : 0)))).debug(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("INFO".equals(enabledLevel) ? 1 : 0)))).info(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("WARN".equals(enabledLevel) ? 1 : 0)))).warn(message);
        ((Logger)Mockito.verify((Object)loggerMessageProcessor.logger, (VerificationMode)Mockito.times((int)("ERROR".equals(enabledLevel) ? 1 : 0)))).error(message);
    }

    private void verifyExpressionEvaluation(LoggerMessageProcessor loggerMessageProcessor, String level, String enabledLevel, CoreEvent muleEvent, VerificationMode timesEvaluateExpression) {
        Mockito.when((Object)loggerMessageProcessor.logger.isTraceEnabled()).thenReturn((Object)"TRACE".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isDebugEnabled()).thenReturn((Object)"DEBUG".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isInfoEnabled()).thenReturn((Object)"INFO".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isWarnEnabled()).thenReturn((Object)"WARN".equals(enabledLevel));
        Mockito.when((Object)loggerMessageProcessor.logger.isErrorEnabled()).thenReturn((Object)"ERROR".equals(enabledLevel));
        loggerMessageProcessor.expressionManager = this.buildExpressionManager();
        loggerMessageProcessor.log(muleEvent);
        ((ExtendedExpressionManager)Mockito.verify((Object)loggerMessageProcessor.expressionManager, (VerificationMode)timesEvaluateExpression)).parseLogTemplate("some expression", muleEvent, this.flow.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    private void verifyNullEventByLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, level, null, null);
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, "not" + level, null, null);
    }

    private void verifyMuleEventByLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        CoreEvent muleEvent = this.buildMuleEvent();
        this.verifyLogCall(loggerMessageProcessor, level, level, muleEvent, muleEvent.getMessage().toString());
        loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        this.verifyLogCall(loggerMessageProcessor, level, "not" + level, muleEvent, muleEvent.getMessage().toString());
    }

    private void verifyLoggerMessageByLevel(String level) {
        CoreEvent muleEvent = this.buildMuleEvent();
        this.verifyLogCall(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, level, muleEvent, "text to log".toString());
        this.verifyLogCall(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, "not" + level, muleEvent, "text to log".toString());
        this.verifyExpressionEvaluation(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, level, muleEvent, Mockito.times((int)1));
        this.verifyExpressionEvaluation(this.buildLoggerMessageProcessorForExpressionEvaluation(level), level, "not" + level, muleEvent, Mockito.never());
    }

    private Logger buildMockLogger() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).error((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).warn((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).info((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).debug((String)Matchers.any());
        ((Logger)Mockito.doNothing().when((Object)mockLogger)).trace((String)Matchers.any());
        Mockito.when((Object)mockLogger.isErrorEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isWarnEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isInfoEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isDebugEnabled()).thenReturn((Object)true);
        Mockito.when((Object)mockLogger.isTraceEnabled()).thenReturn((Object)true);
        return mockLogger;
    }

    private LoggerMessageProcessor buildLoggerMessageProcessorWithLevel(String level) {
        LoggerMessageProcessor loggerMessageProcessor = new LoggerMessageProcessor();
        loggerMessageProcessor.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        loggerMessageProcessor.initLogger();
        loggerMessageProcessor.logger = this.buildMockLogger();
        loggerMessageProcessor.setLevel(level);
        return loggerMessageProcessor;
    }

    private LoggerMessageProcessor buildLoggerMessageProcessorForExpressionEvaluation(String level) {
        LoggerMessageProcessor loggerMessageProcessor = this.buildLoggerMessageProcessorWithLevel(level);
        loggerMessageProcessor.expressionManager = this.buildExpressionManager();
        loggerMessageProcessor.setMessage("some expression");
        return loggerMessageProcessor;
    }

    private CoreEvent buildMuleEvent() {
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        InternalMessage message = (InternalMessage)Mockito.mock(InternalMessage.class);
        Mockito.when((Object)message.toString()).thenReturn((Object)"text to log");
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        return event;
    }

    private ExtendedExpressionManager buildExpressionManager() {
        ExtendedExpressionManager expressionLanguage = (ExtendedExpressionManager)Mockito.mock(ExtendedExpressionManager.class);
        Mockito.when((Object)expressionLanguage.parseLogTemplate(Matchers.anyString(), (CoreEvent)Matchers.any(CoreEvent.class), (ComponentLocation)Matchers.eq((Object)this.flow.getLocation()), (BindingContext)Matchers.any(BindingContext.class))).thenReturn((Object)"text to log");
        return expressionLanguage;
    }
}

