/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.processor.ResponseMessageProcessorAdapter;
import org.mule.runtime.core.internal.transformer.simple.StringAppendTransformer;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.tck.junit4.AbstractReactiveProcessorTestCase;
import org.mule.tck.util.MuleContextUtils;

public class ResponseMessageProcessorAdapterTestCase
extends AbstractReactiveProcessorTestCase {
    public ResponseMessageProcessorAdapterTestCase(AbstractReactiveProcessorTestCase.Mode mode) {
        super(mode);
    }

    @Test
    public void testResponseAdaptorSingleMP() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)this.createStringAppendTransformer("3"));
        responseMessageProcessorAdapter.setMuleContext(muleContext);
        builder.chain(new Processor[]{this.createStringAppendTransformer("1"), responseMessageProcessorAdapter, this.createStringAppendTransformer("2")});
        Assert.assertEquals((Object)"0123", (Object)((PrivilegedEvent)this.process((Processor)builder.build(), MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"0")).build())).getMessageAsString(muleContext));
    }

    @Test
    public void testResponseAdaptorSingleMPReturnsNull() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)new ReturnNullMP());
        responseMessageProcessorAdapter.setMuleContext(muleContext);
        builder.chain(new Processor[]{this.createStringAppendTransformer("1"), responseMessageProcessorAdapter, this.createStringAppendTransformer("2")});
        Assert.assertEquals((Object)"012", (Object)((PrivilegedEvent)this.process((Processor)builder.build(), MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"0")).build())).getMessageAsString(muleContext));
    }

    @Test
    public void testResponseAdaptorNestedChain() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.createStringAppendTransformer("a"), this.createStringAppendTransformer("b")}).build());
        responseMessageProcessorAdapter.setMuleContext(muleContext);
        builder.chain(new Processor[]{this.createStringAppendTransformer("1"), responseMessageProcessorAdapter, this.createStringAppendTransformer("2")});
        Assert.assertEquals((Object)"012ab", (Object)((PrivilegedEvent)this.process((Processor)builder.build(), MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"0")).build())).getMessageAsString(muleContext));
    }

    @Test
    public void testResponseAdaptorNestedChainReturnsNull() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        ResponseMessageProcessorAdapter responseMessageProcessorAdapter = new ResponseMessageProcessorAdapter((Processor)new DefaultMessageProcessorChainBuilder().chain(new Processor[]{this.createStringAppendTransformer("a"), this.createStringAppendTransformer("b"), new ReturnNullMP()}).build());
        responseMessageProcessorAdapter.setMuleContext(muleContext);
        builder.chain(new Processor[]{this.createStringAppendTransformer("1"), responseMessageProcessorAdapter, this.createStringAppendTransformer("2")});
        Assert.assertEquals((Object)"012", (Object)((PrivilegedEvent)this.process((Processor)builder.build(), MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"0")).build())).getMessageAsString(muleContext));
    }

    private StringAppendTransformer createStringAppendTransformer(String append) {
        StringAppendTransformer transformer = new StringAppendTransformer(append);
        transformer.setMuleContext(muleContext);
        return transformer;
    }

    private static class ReturnNullMP
    implements Processor {
        private ReturnNullMP() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            return null;
        }
    }
}

