/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultInterceptionEventTestCase
extends AbstractMuleTestCase {
    @Test
    public void correlationIdAutogenerated() throws MuleException {
        InternalEvent event = InternalEvent.builder((EventContext)EventContextFactory.create((String)"id", (String)"serverId", (ComponentLocation)TEST_CONNECTOR_LOCATION, (FlowExceptionHandler)((FlowExceptionHandler)Mockito.mock(FlowExceptionHandler.class)))).message(Message.of((Object)"test")).build();
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(event);
        Assert.assertThat((Object)interceptionEvent.getCorrelationId(), (Matcher)Matchers.is((Object)"id"));
    }

    @Test
    public void correlationIdGiven() throws MuleException {
        InternalEvent event = InternalEvent.builder((EventContext)EventContextFactory.create((String)"id", (String)"serverId", (ComponentLocation)TEST_CONNECTOR_LOCATION, (String)"corr1", (FlowExceptionHandler)((FlowExceptionHandler)Mockito.mock(FlowExceptionHandler.class)))).message(Message.of((Object)"test")).build();
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(event);
        Assert.assertThat((Object)interceptionEvent.getCorrelationId(), (Matcher)Matchers.is((Object)"corr1"));
    }

    @Test
    public void correlationIdLegacy() throws MuleException {
        InternalEvent event = InternalEvent.builder((EventContext)EventContextFactory.create((String)"id", (String)"serverId", (ComponentLocation)TEST_CONNECTOR_LOCATION, (FlowExceptionHandler)((FlowExceptionHandler)Mockito.mock(FlowExceptionHandler.class)))).correlationId("corr1").message(Message.of((Object)"test")).build();
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(event);
        Assert.assertThat((Object)interceptionEvent.getCorrelationId(), (Matcher)Matchers.is((Object)"corr1"));
    }

    @Test
    public void addSession() throws MuleException {
        InternalEvent event = ((InternalEvent.Builder)this.getEventBuilder()).message(Message.of((Object)"test")).build();
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(event);
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        interceptionEvent.session(session);
        Assert.assertThat((Object)interceptionEvent.resolve().getSession(), (Matcher)Matchers.sameInstance((Object)session));
    }

    @Test
    public void changeSession() throws MuleException {
        InternalEvent event = ((InternalEvent.Builder)this.getEventBuilder()).message(Message.of((Object)"test")).session((MuleSession)Mockito.mock(MuleSession.class)).build();
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(event);
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        interceptionEvent.session(session);
        Assert.assertThat((Object)interceptionEvent.resolve().getSession(), (Matcher)Matchers.sameInstance((Object)session));
    }

    @Test
    public void updateSession() throws MuleException {
        InternalEvent event = ((InternalEvent.Builder)this.getEventBuilder()).message(Message.of((Object)"test")).build();
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(event);
        MuleSession session = event.getSession();
        session.setProperty("myKey", (Serializable)((Object)"myValue"));
        interceptionEvent.session(session);
        Assert.assertThat((Object)interceptionEvent.resolve().getSession().getProperty("myKey"), (Matcher)Matchers.is((Object)"myValue"));
    }
}

